/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.Compiler;
import clojure.lang.IFn;
import clojure.lang.IMapEntry;
import clojure.lang.IObj;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.IPersistentVector;
import clojure.lang.ISeq;
import clojure.lang.Keyword;
import clojure.lang.LazilyPersistentVector;
import clojure.lang.LineNumberingPushbackReader;
import clojure.lang.Numbers;
import clojure.lang.PersistentHashMap;
import clojure.lang.PersistentHashSet;
import clojure.lang.PersistentList;
import clojure.lang.PersistentTreeMap;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LispReader {
    static Symbol QUOTE = Symbol.create(null, "quote");
    static Symbol CONCAT = Symbol.create("clojure", "concat");
    static Symbol LIST = Symbol.create("clojure", "list");
    static Symbol APPLY = Symbol.create("clojure", "apply");
    static Symbol HASHMAP = Symbol.create("clojure", "hash-map");
    static Symbol HASHSET = Symbol.create("clojure", "hash-set");
    static Symbol VECTOR = Symbol.create("clojure", "vector");
    static Symbol WITH_META = Symbol.create("clojure", "with-meta");
    static Symbol META = Symbol.create("clojure", "meta");
    static Symbol DEREF = Symbol.create("clojure", "deref");
    static IFn[] macros = new IFn[256];
    static IFn[] dispatchMacros = new IFn[256];
    static Pattern symbolPat = Pattern.compile("[:]?([\\D&&[^:/]][^/]*/)?([\\D&&[^:/]][^/]*)");
    static Pattern intPat = Pattern.compile("[-+]?[0-9]+\\.?");
    static Pattern ratioPat = Pattern.compile("([-+]?[0-9]+)/([0-9]+)");
    static Pattern floatPat = Pattern.compile("[-+]?[0-9]+(\\.[0-9]+)?([eE][-+]?[0-9]+)?[M]?");
    static final Symbol SLASH = Symbol.create("/");
    static Var GENSYM_ENV = Var.create(null);
    static Var ARG_ENV = Var.create(null);

    static boolean isWhitespace(int ch) {
        return Character.isWhitespace(ch) || ch == 44;
    }

    static void unread(PushbackReader r, int ch) throws IOException {
        if (ch != -1) {
            r.unread(ch);
        }
    }

    public static Object read(PushbackReader r, boolean eofIsError, Object eofValue, boolean isRecursive) throws Exception {
        try {
            int ch;
            block13: {
                Object ret;
                do {
                    ch = r.read();
                    while (LispReader.isWhitespace(ch)) {
                        ch = r.read();
                    }
                    if (ch == -1) {
                        if (eofIsError) {
                            throw new Exception("EOF while reading");
                        }
                        return eofValue;
                    }
                    if (Character.isDigit(ch)) {
                        Object n = LispReader.readNumber(r, (char)ch);
                        if (RT.suppressRead()) {
                            return null;
                        }
                        return n;
                    }
                    IFn macroFn = LispReader.getMacro(ch);
                    if (macroFn == null) break block13;
                    ret = macroFn.invoke(r, Character.valueOf((char)ch));
                    if (!RT.suppressRead()) continue;
                    return null;
                } while (ret == r);
                return ret;
            }
            if (ch == 43 || ch == 45) {
                int ch2 = r.read();
                if (Character.isDigit(ch2)) {
                    LispReader.unread(r, ch2);
                    Object n = LispReader.readNumber(r, (char)ch);
                    if (RT.suppressRead()) {
                        return null;
                    }
                    return n;
                }
                LispReader.unread(r, ch2);
            }
            String token = LispReader.readToken(r, (char)ch);
            if (RT.suppressRead()) {
                return null;
            }
            return LispReader.interpretToken(token);
        }
        catch (Exception e) {
            if (isRecursive || !(r instanceof LineNumberingPushbackReader)) {
                throw e;
            }
            LineNumberingPushbackReader rdr = (LineNumberingPushbackReader)r;
            throw new Exception(String.format("ReaderError:(%d,1) %s", rdr.getLineNumber(), e.getMessage()), e);
        }
    }

    private static String readToken(PushbackReader r, char initch) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(initch);
        while (true) {
            int ch;
            if ((ch = r.read()) == -1 || LispReader.isWhitespace(ch) || LispReader.isTerminatingMacro(ch)) {
                LispReader.unread(r, ch);
                return sb.toString();
            }
            sb.append((char)ch);
        }
    }

    private static Object readNumber(PushbackReader r, char initch) throws Exception {
        int ch;
        StringBuilder sb = new StringBuilder();
        sb.append(initch);
        while (true) {
            if ((ch = r.read()) == -1 || LispReader.isWhitespace(ch) || LispReader.isMacro(ch)) break;
            sb.append((char)ch);
        }
        LispReader.unread(r, ch);
        String s = sb.toString();
        Object n = LispReader.matchNumber(s);
        if (n == null) {
            throw new IllegalArgumentException("Invalid number: " + s);
        }
        return n;
    }

    private static int readUnicodeChar(String token, int offset, int length, int base) throws Exception {
        if (token.length() != offset + length) {
            throw new IllegalArgumentException("Invalid unicode character: \\" + token);
        }
        int uc = 0;
        for (int i = offset; i < offset + length; ++i) {
            int d = Character.digit(token.charAt(i), base);
            if (d == -1) {
                throw new IllegalArgumentException("Invalid digit: " + (char)d);
            }
            uc = uc * base + d;
        }
        return (char)uc;
    }

    private static int readUnicodeChar(PushbackReader r, int initch, int base, int length, boolean exact) throws Exception {
        int i;
        int uc = Character.digit(initch, base);
        if (uc == -1) {
            throw new IllegalArgumentException("Invalid digit: " + initch);
        }
        for (i = 1; i < length; ++i) {
            int ch = r.read();
            if (ch == -1 || LispReader.isWhitespace(ch) || LispReader.isMacro(ch)) {
                LispReader.unread(r, ch);
                break;
            }
            int d = Character.digit(ch, base);
            if (d == -1) {
                throw new IllegalArgumentException("Invalid digit: " + (char)ch);
            }
            uc = uc * base + d;
        }
        if (i != length && exact) {
            throw new IllegalArgumentException("Invalid character length: " + i + ", should be: " + length);
        }
        return uc;
    }

    private static Object interpretToken(String s) throws Exception {
        if (s.equals("nil")) {
            return null;
        }
        if (s.equals("true")) {
            return RT.T;
        }
        if (s.equals("false")) {
            return RT.F;
        }
        if (s.equals("/")) {
            return SLASH;
        }
        Object ret = null;
        ret = LispReader.matchSymbol(s);
        if (ret != null) {
            return ret;
        }
        throw new Exception("Invalid token: " + s);
    }

    private static Object matchSymbol(String s) {
        Matcher m = symbolPat.matcher(s);
        if (m.matches()) {
            int gc = m.groupCount();
            String ns = m.group(1);
            String name = m.group(2);
            if (ns != null && ns.endsWith(":/") || name.endsWith(":") || s.contains("::")) {
                return null;
            }
            boolean isKeyword = s.charAt(0) == ':';
            Symbol sym = Symbol.intern(s.substring(isKeyword ? 1 : 0));
            if (isKeyword) {
                return Keyword.intern(sym);
            }
            return sym;
        }
        return null;
    }

    private static Object matchNumber(String s) {
        Matcher m = intPat.matcher(s);
        if (m.matches()) {
            return Numbers.reduce(new BigInteger(s));
        }
        m = floatPat.matcher(s);
        if (m.matches()) {
            if (s.charAt(s.length() - 1) == 'M') {
                return new BigDecimal(s.substring(0, s.length() - 1));
            }
            return Double.parseDouble(s);
        }
        m = ratioPat.matcher(s);
        if (m.matches()) {
            return Numbers.divide(new BigInteger(m.group(1)), new BigInteger(m.group(2)));
        }
        return null;
    }

    private static IFn getMacro(int ch) {
        if (ch < macros.length) {
            return macros[ch];
        }
        return null;
    }

    private static boolean isMacro(int ch) {
        return ch < macros.length && macros[ch] != null;
    }

    private static boolean isTerminatingMacro(int ch) {
        return ch != 35 && ch < macros.length && macros[ch] != null;
    }

    static Symbol garg(int n) {
        return Symbol.intern(null, (n == -1 ? "rest" : "p" + n) + "__" + RT.nextID());
    }

    static Symbol registerArg(int n) {
        PersistentTreeMap argsyms = (PersistentTreeMap)ARG_ENV.get();
        if (argsyms == null) {
            throw new IllegalStateException("arg literal not in #()");
        }
        Symbol ret = (Symbol)argsyms.valAt(n);
        if (ret == null) {
            ret = LispReader.garg(n);
            ARG_ENV.set(argsyms.assoc(n, ret));
        }
        return ret;
    }

    public static List readDelimitedList(char delim, PushbackReader r, boolean isRecursive) throws Exception {
        ArrayList<Object> a = new ArrayList<Object>();
        while (true) {
            int ch = r.read();
            while (LispReader.isWhitespace(ch)) {
                ch = r.read();
            }
            if (ch == -1) {
                throw new Exception("EOF while reading");
            }
            if (ch == delim) break;
            IFn macroFn = LispReader.getMacro(ch);
            if (macroFn != null) {
                Object mret = macroFn.invoke(r, Character.valueOf((char)ch));
                if (mret == r) continue;
                a.add(mret);
                continue;
            }
            LispReader.unread(r, ch);
            Object o = LispReader.read(r, true, null, isRecursive);
            if (o == r) continue;
            a.add(o);
        }
        return a;
    }

    static {
        LispReader.macros[34] = new StringReader();
        LispReader.macros[59] = new CommentReader();
        LispReader.macros[39] = new WrappingReader(Compiler.QUOTE);
        LispReader.macros[64] = new WrappingReader(DEREF);
        LispReader.macros[94] = new WrappingReader(META);
        LispReader.macros[96] = new SyntaxQuoteReader();
        LispReader.macros[126] = new UnquoteReader();
        LispReader.macros[40] = new ListReader();
        LispReader.macros[41] = new UnmatchedDelimiterReader();
        LispReader.macros[91] = new VectorReader();
        LispReader.macros[93] = new UnmatchedDelimiterReader();
        LispReader.macros[123] = new MapReader();
        LispReader.macros[125] = new UnmatchedDelimiterReader();
        LispReader.macros[92] = new CharacterReader();
        LispReader.macros[37] = new ArgReader();
        LispReader.macros[35] = new DispatchReader();
        LispReader.dispatchMacros[94] = new MetaReader();
        LispReader.dispatchMacros[39] = new WrappingReader(Compiler.THE_VAR);
        LispReader.dispatchMacros[34] = new RegexReader();
        LispReader.dispatchMacros[40] = new FnReader();
        LispReader.dispatchMacros[123] = new SetReader();
    }

    static class UnmatchedDelimiterReader
    extends AFn {
        UnmatchedDelimiterReader() {
        }

        public Object invoke(Object reader, Object rightdelim) throws Exception {
            throw new Exception("Unmatched delimiter: " + rightdelim);
        }
    }

    static class SetReader
    extends AFn {
        SetReader() {
        }

        public Object invoke(Object reader, Object leftbracket) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            return PersistentHashSet.create(LispReader.readDelimitedList('}', r, true));
        }
    }

    static class MapReader
    extends AFn {
        MapReader() {
        }

        public Object invoke(Object reader, Object leftparen) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            return PersistentHashMap.create(LispReader.readDelimitedList('}', r, true));
        }
    }

    static class VectorReader
    extends AFn {
        VectorReader() {
        }

        public Object invoke(Object reader, Object leftparen) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            return LazilyPersistentVector.create(LispReader.readDelimitedList(']', r, true));
        }
    }

    static class ListReader
    extends AFn {
        ListReader() {
        }

        public Object invoke(Object reader, Object leftparen) throws Exception {
            List list;
            PushbackReader r = (PushbackReader)reader;
            int line = -1;
            if (r instanceof LineNumberingPushbackReader) {
                line = ((LineNumberingPushbackReader)r).getLineNumber();
            }
            if ((list = LispReader.readDelimitedList(')', r, true)).isEmpty()) {
                return PersistentList.EMPTY;
            }
            IObj s = (IObj)((Object)PersistentList.create(list));
            if (line != -1) {
                return s.withMeta(RT.map(RT.LINE_KEY, line));
            }
            return s;
        }
    }

    static class CharacterReader
    extends AFn {
        CharacterReader() {
        }

        public Object invoke(Object reader, Object backslash) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            int ch = r.read();
            if (ch == -1) {
                throw new Exception("EOF while reading character");
            }
            String token = LispReader.readToken(r, (char)ch);
            if (token.length() == 1) {
                return Character.valueOf(token.charAt(0));
            }
            if (token.equals("newline")) {
                return Character.valueOf('\n');
            }
            if (token.equals("space")) {
                return Character.valueOf(' ');
            }
            if (token.equals("tab")) {
                return Character.valueOf('\t');
            }
            if (token.equals("backspace")) {
                return Character.valueOf('\b');
            }
            if (token.equals("formfeed")) {
                return Character.valueOf('\f');
            }
            if (token.startsWith("u")) {
                return Character.valueOf((char)LispReader.readUnicodeChar(token, 1, 4, 16));
            }
            if (token.startsWith("o")) {
                int len = token.length() - 1;
                if (len > 3) {
                    throw new Exception("Invalid octal escape sequence length: " + len);
                }
                int uc = LispReader.readUnicodeChar(token, 1, len, 8);
                if (uc > 255) {
                    throw new Exception("Octal escape sequence must be in range [0, 377].");
                }
                return Character.valueOf((char)uc);
            }
            throw new Exception("Unsupported character: \\" + token);
        }
    }

    static class UnquoteReader
    extends AFn {
        UnquoteReader() {
        }

        public Object invoke(Object reader, Object comma) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            int ch = r.read();
            if (ch == -1) {
                throw new Exception("EOF while reading character");
            }
            if (ch == 64) {
                Object o = LispReader.read(r, true, null, true);
                return new UnquoteSplicing(o);
            }
            LispReader.unread(r, ch);
            Object o = LispReader.read(r, true, null, true);
            return new Unquote(o);
        }
    }

    static class UnquoteSplicing {
        final Object o;

        public UnquoteSplicing(Object o) {
            this.o = o;
        }
    }

    static class Unquote {
        final Object o;

        public Unquote(Object o) {
            this.o = o;
        }
    }

    static class SyntaxQuoteReader
    extends AFn {
        SyntaxQuoteReader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object reader, Object backquote) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            try {
                Var.pushThreadBindings(RT.map(GENSYM_ENV, PersistentHashMap.EMPTY));
                Object form = LispReader.read(r, true, null, true);
                Object object = SyntaxQuoteReader.syntaxQuote(form);
                return object;
            }
            finally {
                Var.popThreadBindings();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static Object syntaxQuote(Object form) throws Exception {
            Object ret;
            if (Compiler.isSpecial(form)) {
                ret = RT.list(Compiler.QUOTE, form);
            } else if (form instanceof Symbol) {
                Symbol sym = (Symbol)form;
                if (sym.ns == null && sym.name.endsWith("#")) {
                    IPersistentMap gmap = (IPersistentMap)GENSYM_ENV.get();
                    if (gmap == null) {
                        throw new IllegalStateException("Gensym literal not in syntax-quote");
                    }
                    Symbol gs = (Symbol)gmap.valAt(sym);
                    if (gs == null) {
                        gs = Symbol.intern(null, sym.name.substring(0, sym.name.length() - 1) + "__" + RT.nextID());
                        GENSYM_ENV.set(gmap.assoc(sym, gs));
                    }
                    sym = gs;
                } else {
                    sym = Compiler.resolveSymbol(sym);
                }
                ret = RT.list(Compiler.QUOTE, sym);
            } else {
                if (form instanceof Unquote) {
                    return ((Unquote)form).o;
                }
                if (form instanceof UnquoteSplicing) {
                    throw new IllegalStateException("splice not in list");
                }
                if (form instanceof IPersistentCollection) {
                    if (form instanceof IPersistentMap) {
                        IPersistentVector keyvals = SyntaxQuoteReader.flattenMap(form);
                        ret = RT.list(APPLY, HASHMAP, RT.cons(CONCAT, SyntaxQuoteReader.sqExpandList(keyvals.seq())));
                    } else if (form instanceof IPersistentVector) {
                        ret = RT.list(APPLY, VECTOR, RT.cons(CONCAT, SyntaxQuoteReader.sqExpandList(((IPersistentVector)form).seq())));
                    } else if (form instanceof IPersistentSet) {
                        ret = RT.list(APPLY, HASHSET, RT.cons(CONCAT, SyntaxQuoteReader.sqExpandList(((IPersistentSet)form).seq())));
                    } else {
                        if (!(form instanceof ISeq)) throw new UnsupportedOperationException("Unknown Collection type");
                        ISeq seq = RT.seq(form);
                        ret = RT.cons(CONCAT, SyntaxQuoteReader.sqExpandList(seq));
                    }
                } else {
                    ret = form instanceof Keyword || form instanceof Number || form instanceof Character || form instanceof String ? form : RT.list(Compiler.QUOTE, form);
                }
            }
            if (!(form instanceof IObj) || ((IObj)form).meta() == null) return ret;
            return RT.list(WITH_META, ret, SyntaxQuoteReader.syntaxQuote(((IObj)form).meta()));
        }

        private static ISeq sqExpandList(ISeq seq) throws Exception {
            PersistentVector ret = PersistentVector.EMPTY;
            while (seq != null) {
                Object item = seq.first();
                ret = item instanceof Unquote ? ret.cons(RT.list(LIST, ((Unquote)item).o)) : (item instanceof UnquoteSplicing ? ret.cons(((UnquoteSplicing)item).o) : ret.cons(RT.list(LIST, SyntaxQuoteReader.syntaxQuote(item))));
                seq = seq.rest();
            }
            return ret.seq();
        }

        private static IPersistentVector flattenMap(Object form) {
            IPersistentVector keyvals = PersistentVector.EMPTY;
            for (ISeq s = RT.seq(form); s != null; s = s.rest()) {
                IMapEntry e = (IMapEntry)s.first();
                keyvals = keyvals.cons(e.key());
                keyvals = keyvals.cons(e.val());
            }
            return keyvals;
        }
    }

    static class MetaReader
    extends AFn {
        MetaReader() {
        }

        public Object invoke(Object reader, Object caret) throws Exception {
            Object meta;
            PushbackReader r = (PushbackReader)reader;
            int line = -1;
            if (r instanceof LineNumberingPushbackReader) {
                line = ((LineNumberingPushbackReader)r).getLineNumber();
            }
            if ((meta = LispReader.read(r, true, null, true)) instanceof Symbol || meta instanceof Keyword || meta instanceof String) {
                meta = RT.map(RT.TAG_KEY, meta);
            } else if (!(meta instanceof IPersistentMap)) {
                throw new IllegalArgumentException("Metadata must be Symbol,Keyword,String or Map");
            }
            Object o = LispReader.read(r, true, null, true);
            if (o instanceof IObj) {
                if (line != -1 && o instanceof ISeq) {
                    meta = ((IPersistentMap)meta).assoc(RT.LINE_KEY, line);
                }
                return ((IObj)o).withMeta((IPersistentMap)meta);
            }
            throw new IllegalArgumentException("Metadata can only be applied to IObjs");
        }
    }

    static class ArgReader
    extends AFn {
        ArgReader() {
        }

        public Object invoke(Object reader, Object pct) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            int ch = r.read();
            LispReader.unread(r, ch);
            if (ch == -1 || LispReader.isWhitespace(ch) || LispReader.isTerminatingMacro(ch)) {
                return LispReader.registerArg(1);
            }
            Object n = LispReader.read(r, true, null, true);
            if (n.equals(Compiler._AMP_)) {
                return LispReader.registerArg(-1);
            }
            if (!(n instanceof Number)) {
                throw new IllegalStateException("arg literal must be %, %& or %integer");
            }
            return LispReader.registerArg(((Number)n).intValue());
        }
    }

    static class FnReader
    extends AFn {
        FnReader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object reader, Object lparen) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            if (ARG_ENV.get() != null) {
                throw new IllegalStateException("Nested #()s are not allowed");
            }
            try {
                Var.pushThreadBindings(RT.map(ARG_ENV, PersistentTreeMap.EMPTY));
                r.unread(40);
                Object form = LispReader.read(r, true, null, true);
                PersistentVector args = PersistentVector.EMPTY;
                PersistentTreeMap argsyms = (PersistentTreeMap)ARG_ENV.get();
                ISeq rargs = argsyms.rseq();
                if (rargs != null) {
                    Object restsym;
                    int higharg = (Integer)((Map.Entry)rargs.first()).getKey();
                    if (higharg > 0) {
                        for (int i = 1; i <= higharg; ++i) {
                            Object sym = argsyms.valAt(i);
                            if (sym == null) {
                                sym = LispReader.garg(i);
                            }
                            args = args.cons(sym);
                        }
                    }
                    if ((restsym = argsyms.valAt(-1)) != null) {
                        args = args.cons(Compiler._AMP_);
                        args = args.cons(restsym);
                    }
                }
                ISeq iSeq = RT.list(Compiler.FN, args, form);
                return iSeq;
            }
            finally {
                Var.popThreadBindings();
            }
        }
    }

    static class DispatchReader
    extends AFn {
        DispatchReader() {
        }

        public Object invoke(Object reader, Object hash) throws Exception {
            int ch = ((Reader)reader).read();
            if (ch == -1) {
                throw new Exception("EOF while reading character");
            }
            IFn fn = dispatchMacros[ch];
            if (fn == null) {
                throw new Exception(String.format("No dispatch macro for: %c", Character.valueOf((char)ch)));
            }
            return fn.invoke(reader, ch);
        }
    }

    static class WrappingReader
    extends AFn {
        final Symbol sym;

        public WrappingReader(Symbol sym) {
            this.sym = sym;
        }

        public Object invoke(Object reader, Object quote) throws Exception {
            PushbackReader r = (PushbackReader)reader;
            Object o = LispReader.read(r, true, null, true);
            return RT.list(this.sym, o);
        }
    }

    static class CommentReader
    extends AFn {
        CommentReader() {
        }

        public Object invoke(Object reader, Object semicolon) throws Exception {
            int ch;
            Reader r = (Reader)reader;
            while ((ch = r.read()) != -1 && ch != 10 && ch != 13) {
            }
            return r;
        }
    }

    static class StringReader
    extends AFn {
        StringReader() {
        }

        public Object invoke(Object reader, Object doublequote) throws Exception {
            StringBuilder sb = new StringBuilder();
            Reader r = (Reader)reader;
            int ch = r.read();
            while (ch != 34) {
                if (ch == -1) {
                    throw new Exception("EOF while reading string");
                }
                if (ch == 92) {
                    ch = r.read();
                    if (ch == -1) {
                        throw new Exception("EOF while reading string");
                    }
                    switch (ch) {
                        case 116: {
                            ch = 9;
                            break;
                        }
                        case 114: {
                            ch = 13;
                            break;
                        }
                        case 110: {
                            ch = 10;
                            break;
                        }
                        case 92: {
                            break;
                        }
                        case 34: {
                            break;
                        }
                        case 98: {
                            ch = 8;
                            break;
                        }
                        case 102: {
                            ch = 12;
                            break;
                        }
                        case 117: {
                            ch = r.read();
                            if (Character.isDigit(ch)) {
                                ch = LispReader.readUnicodeChar((PushbackReader)r, ch, 16, 4, true);
                                break;
                            }
                            throw new Exception("Invalid unicode escape: \\" + (char)ch);
                        }
                        default: {
                            if (Character.isDigit(ch)) {
                                if ((ch = LispReader.readUnicodeChar((PushbackReader)r, ch, 8, 3, false)) <= 255) break;
                                throw new Exception("Octal escape sequence must be in range [0, 377].");
                            }
                            throw new Exception("Unsupported escape character: \\" + (char)ch);
                        }
                    }
                }
                sb.append((char)ch);
                ch = r.read();
            }
            return sb.toString();
        }
    }

    static class RegexReader
    extends AFn {
        static StringReader stringrdr = new StringReader();

        RegexReader() {
        }

        public Object invoke(Object reader, Object doublequote) throws Exception {
            String str = (String)stringrdr.invoke(reader, doublequote);
            return Pattern.compile(str);
        }
    }
}

