/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.ASeq;
import clojure.lang.ArraySeq;
import clojure.lang.IFn;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentList;
import clojure.lang.IPersistentMap;
import clojure.lang.IReduce;
import clojure.lang.ISeq;
import clojure.lang.Obj;
import clojure.lang.RT;
import clojure.lang.RestFn;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class PersistentList
extends ASeq
implements IPersistentList,
IReduce {
    private final Object _first;
    private final IPersistentList _rest;
    private final int _count;
    public static IFn creator = new RestFn(0){

        protected Object doInvoke(Object args) throws Exception {
            if (args instanceof ArraySeq) {
                Object[] argsarray = (Object[])((ArraySeq)args).array;
                IPersistentList ret = EMPTY;
                for (int i = argsarray.length - 1; i >= 0; --i) {
                    ret = (IPersistentList)ret.cons(argsarray[i]);
                }
                return ret;
            }
            LinkedList<Object> list = new LinkedList<Object>();
            for (ISeq s = RT.seq(args); s != null; s = s.rest()) {
                list.add(s.first());
            }
            return PersistentList.create(list);
        }
    };
    public static final EmptyList EMPTY = new EmptyList(null);

    public PersistentList(Object first) {
        this._first = first;
        this._rest = null;
        this._count = 1;
    }

    PersistentList(IPersistentMap meta, Object _first, IPersistentList _rest, int _count) {
        super(meta);
        this._first = _first;
        this._rest = _rest;
        this._count = _count;
    }

    public static IPersistentList create(List init) {
        IPersistentList ret = EMPTY;
        ListIterator i = init.listIterator(init.size());
        while (i.hasPrevious()) {
            ret = (IPersistentList)ret.cons(i.previous());
        }
        return ret;
    }

    public Object first() {
        return this._first;
    }

    public ISeq rest() {
        if (this._count == 1) {
            return null;
        }
        return (ISeq)((Object)this._rest);
    }

    public Object peek() {
        return this.first();
    }

    public IPersistentList pop() {
        if (this._rest == null) {
            return EMPTY.withMeta(this._meta);
        }
        return this._rest;
    }

    public int count() {
        return this._count;
    }

    public PersistentList cons(Object o) {
        return new PersistentList(this.meta(), o, this, this._count + 1);
    }

    public IPersistentCollection empty() {
        return EMPTY.withMeta(this.meta());
    }

    public PersistentList withMeta(IPersistentMap meta) {
        if (meta != this._meta) {
            return new PersistentList(meta, this._first, this._rest, this._count);
        }
        return this;
    }

    public Object reduce(IFn f) throws Exception {
        Object ret = this.first();
        for (ISeq s = this.rest(); s != null; s = s.rest()) {
            ret = f.invoke(ret, s.first());
        }
        return ret;
    }

    public Object reduce(IFn f, Object start) throws Exception {
        Object ret = f.invoke(start, this.first());
        for (ISeq s = this.rest(); s != null; s = s.rest()) {
            ret = f.invoke(ret, s.first());
        }
        return ret;
    }

    static class EmptyList
    extends Obj
    implements IPersistentList {
        EmptyList(IPersistentMap meta) {
            super(meta);
        }

        public PersistentList cons(Object o) {
            return new PersistentList(this.meta(), o, null, 1);
        }

        public IPersistentCollection empty() {
            return this;
        }

        public EmptyList withMeta(IPersistentMap meta) {
            if (meta != this.meta()) {
                return new EmptyList(meta);
            }
            return this;
        }

        public Object peek() {
            return null;
        }

        public IPersistentList pop() {
            throw new IllegalStateException("Can't pop empty list");
        }

        public int count() {
            return 0;
        }

        public ISeq seq() {
            return null;
        }
    }
}

