/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.APersistentMap;
import clojure.lang.APersistentVector;
import clojure.lang.ArraySeq;
import clojure.lang.Associative;
import clojure.lang.Compiler;
import clojure.lang.DynamicClassLoader;
import clojure.lang.EnumerationSeq;
import clojure.lang.IFn;
import clojure.lang.IMapEntry;
import clojure.lang.IObj;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentList;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.IPersistentStack;
import clojure.lang.IPersistentVector;
import clojure.lang.ISeq;
import clojure.lang.IteratorSeq;
import clojure.lang.Keyword;
import clojure.lang.LazilyPersistentVector;
import clojure.lang.LineNumberingPushbackReader;
import clojure.lang.MapEntry;
import clojure.lang.Namespace;
import clojure.lang.Obj;
import clojure.lang.PersistentArrayMap;
import clojure.lang.PersistentHashMap;
import clojure.lang.PersistentHashSet;
import clojure.lang.PersistentList;
import clojure.lang.PersistentVector;
import clojure.lang.Sequential;
import clojure.lang.StringSeq;
import clojure.lang.Symbol;
import clojure.lang.Util;
import clojure.lang.Var;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RT {
    public static final Boolean T = Boolean.TRUE;
    public static final Boolean F = Boolean.FALSE;
    static final IPersistentMap DEFAULT_IMPORTS = RT.map(Symbol.create("Boolean"), Boolean.class, Symbol.create("Byte"), Byte.class, Symbol.create("Character"), Character.class, Symbol.create("Class"), Class.class, Symbol.create("ClassLoader"), ClassLoader.class, Symbol.create("Compiler"), Compiler.class, Symbol.create("Double"), Double.class, Symbol.create("Enum"), Enum.class, Symbol.create("Float"), Float.class, Symbol.create("InheritableThreadLocal"), InheritableThreadLocal.class, Symbol.create("Integer"), Integer.class, Symbol.create("Long"), Long.class, Symbol.create("Math"), Math.class, Symbol.create("Number"), Number.class, Symbol.create("Object"), Object.class, Symbol.create("Package"), Package.class, Symbol.create("Process"), Process.class, Symbol.create("ProcessBuilder"), ProcessBuilder.class, Symbol.create("Runtime"), Runtime.class, Symbol.create("RuntimePermission"), RuntimePermission.class, Symbol.create("SecurityManager"), SecurityManager.class, Symbol.create("Short"), Short.class, Symbol.create("StackTraceElement"), StackTraceElement.class, Symbol.create("StrictMath"), StrictMath.class, Symbol.create("String"), String.class, Symbol.create("StringBuffer"), StringBuffer.class, Symbol.create("StringBuilder"), StringBuilder.class, Symbol.create("System"), System.class, Symbol.create("Thread"), Thread.class, Symbol.create("ThreadGroup"), ThreadGroup.class, Symbol.create("ThreadLocal"), ThreadLocal.class, Symbol.create("Throwable"), Throwable.class, Symbol.create("Void"), Void.class, Symbol.create("Appendable"), Appendable.class, Symbol.create("CharSequence"), CharSequence.class, Symbol.create("Cloneable"), Cloneable.class, Symbol.create("Comparable"), Comparable.class, Symbol.create("Iterable"), Iterable.class, Symbol.create("Readable"), Readable.class, Symbol.create("Runnable"), Runnable.class, Symbol.create("Callable"), Callable.class, Symbol.create("Exception"), Exception.class, Symbol.create("BigInteger"), BigInteger.class, Symbol.create("BigDecimal"), BigDecimal.class);
    public static final Namespace CLOJURE_NS = Namespace.findOrCreate(Symbol.create("clojure"));
    public static final Var OUT = Var.intern(CLOJURE_NS, Symbol.create("*out*"), new OutputStreamWriter(System.out));
    public static final Var IN = Var.intern(CLOJURE_NS, Symbol.create("*in*"), new LineNumberingPushbackReader(new InputStreamReader(System.in)));
    static final Keyword TAG_KEY = Keyword.intern(null, "tag");
    public static final Var AGENT = Var.intern(CLOJURE_NS, Symbol.create("*agent*"), null);
    public static final Var MACRO_META = Var.intern(CLOJURE_NS, Symbol.create("*macro-meta*"), null);
    public static final Var MATH_CONTEXT = Var.intern(CLOJURE_NS, Symbol.create("*math-context*"), null);
    static Keyword LINE_KEY = Keyword.intern(null, "line");
    static Keyword FILE_KEY = Keyword.intern(null, "file");
    static final Symbol LOAD_FILE = Symbol.create("load-file");
    static final Symbol IN_NAMESPACE = Symbol.create("in-ns");
    static final Symbol IDENTICAL = Symbol.create("identical?");
    static final Var CMD_LINE_ARGS = Var.intern(CLOJURE_NS, Symbol.create("*command-line-args*"), null);
    public static final Var CURRENT_NS = Var.intern(CLOJURE_NS, Symbol.create("*ns*"), CLOJURE_NS);
    static final Var PRINT_META = Var.intern(CLOJURE_NS, Symbol.create("*print-meta*"), F);
    static final Var PRINT_READABLY = Var.intern(CLOJURE_NS, Symbol.create("*print-readably*"), T);
    static final Var WARN_ON_REFLECTION = Var.intern(CLOJURE_NS, Symbol.create("*warn-on-reflection*"), F);
    static final IFn inNamespace = new AFn(){

        public Object invoke(Object arg1) throws Exception {
            Symbol nsname = (Symbol)arg1;
            Namespace ns = Namespace.findOrCreate(nsname);
            CURRENT_NS.set(ns);
            return ns;
        }
    };
    public static final Object[] EMPTY_ARRAY = new Object[0];
    public static final Comparator DEFAULT_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    };
    static AtomicInteger id = new AtomicInteger(1);
    public static final DynamicClassLoader ROOT_CLASSLOADER = new DynamicClassLoader();

    public static List<String> processCommandLine(String[] args) {
        List<String> arglist = Arrays.asList(args);
        int split = arglist.indexOf("--");
        if (split >= 0) {
            CMD_LINE_ARGS.bindRoot(RT.seq(arglist.subList(split + 1, args.length)));
            return arglist.subList(0, split);
        }
        return arglist;
    }

    public static void addURL(Object url) throws Exception {
        URL u = url instanceof String ? new URL((String)url) : (URL)url;
        ROOT_CLASSLOADER.addURL(u);
    }

    public static Var var(String ns, String name) {
        return Var.intern(Namespace.findOrCreate(Symbol.intern(null, ns)), Symbol.intern(null, name));
    }

    public static void loadResourceScript(String name) throws Exception {
        RT.loadResourceScript(RT.class, name);
    }

    public static void loadResourceScript(Class c, String name) throws Exception {
        InputStream ins = c.getResourceAsStream("/" + name);
        if (ins != null) {
            Compiler.load(new InputStreamReader(ins), name, name);
            ins.close();
        }
    }

    public static void init() throws Exception {
        System.err.println("No need to call RT.init() anymore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doInit() throws Exception {
        RT.loadResourceScript(RT.class, "boot.clj");
        RT.loadResourceScript(RT.class, "proxy.clj");
        RT.loadResourceScript(RT.class, "zip.clj");
        RT.loadResourceScript(RT.class, "xml.clj");
        RT.loadResourceScript(RT.class, "set.clj");
        Var.pushThreadBindings(RT.map(CURRENT_NS, CURRENT_NS.get(), WARN_ON_REFLECTION, WARN_ON_REFLECTION.get()));
        try {
            Symbol USER = Symbol.create("user");
            Symbol CLOJURE = Symbol.create("clojure");
            Var in_ns = RT.var("clojure", "in-ns");
            Var refer = RT.var("clojure", "refer");
            in_ns.invoke(USER);
            refer.invoke(CLOJURE);
            RT.loadResourceScript(RT.class, "user.clj");
        }
        finally {
            Var.popThreadBindings();
        }
    }

    public static int nextID() {
        return id.getAndIncrement();
    }

    public static ISeq seq(Object coll) {
        if (coll == null) {
            return null;
        }
        if (coll instanceof IPersistentCollection) {
            return ((IPersistentCollection)coll).seq();
        }
        if (coll instanceof Iterable) {
            return IteratorSeq.create(((Iterable)coll).iterator());
        }
        if (coll.getClass().isArray()) {
            return ArraySeq.createFromObject(coll);
        }
        if (coll instanceof String) {
            return StringSeq.create((String)coll);
        }
        if (coll instanceof Map) {
            return RT.seq(((Map)coll).entrySet());
        }
        if (coll instanceof Iterator) {
            return IteratorSeq.create((Iterator)coll);
        }
        if (coll instanceof Enumeration) {
            return EnumerationSeq.create((Enumeration)coll);
        }
        throw new IllegalArgumentException("Don't know how to create ISeq from: " + coll.getClass().getSimpleName());
    }

    public static ISeq keys(Object coll) {
        return APersistentMap.KeySeq.create(RT.seq(coll));
    }

    public static ISeq vals(Object coll) {
        return APersistentMap.ValSeq.create(RT.seq(coll));
    }

    public static IPersistentMap meta(Object x) {
        if (x == null) {
            return null;
        }
        return ((Obj)x).meta();
    }

    public static int count(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof IPersistentCollection) {
            return ((IPersistentCollection)o).count();
        }
        if (o instanceof String) {
            return ((String)o).length();
        }
        if (o instanceof Collection) {
            return ((Collection)o).size();
        }
        if (o instanceof Map) {
            return ((Map)o).size();
        }
        if (o.getClass().isArray()) {
            return Array.getLength(o);
        }
        throw new UnsupportedOperationException("count not supported on this type: " + o.getClass().getSimpleName());
    }

    public static IPersistentCollection conj(IPersistentCollection coll, Object x) {
        if (coll == null) {
            return new PersistentList(x);
        }
        return coll.cons(x);
    }

    public static ISeq cons(Object x, ISeq y) {
        if (y == null) {
            return new PersistentList(x);
        }
        return y.cons(x);
    }

    public static Object first(Object x) {
        ISeq seq = RT.seq(x);
        if (seq == null) {
            return null;
        }
        return seq.first();
    }

    public static Object second(Object x) {
        return RT.first(RT.rest(x));
    }

    public static Object third(Object x) {
        return RT.first(RT.rest(RT.rest(x)));
    }

    public static Object fourth(Object x) {
        return RT.first(RT.rest(RT.rest(RT.rest(x))));
    }

    public static ISeq rest(Object x) {
        ISeq seq = RT.seq(x);
        if (seq == null) {
            return null;
        }
        return seq.rest();
    }

    public static ISeq rrest(Object x) {
        return RT.rest(RT.rest(x));
    }

    public static Object peek(Object x) {
        if (x == null) {
            return null;
        }
        return ((IPersistentStack)x).peek();
    }

    public static Object pop(Object x) {
        if (x == null) {
            return null;
        }
        return ((IPersistentStack)x).pop();
    }

    public static Object get(Object coll, Object key) {
        if (coll == null) {
            return null;
        }
        if (coll instanceof Associative) {
            return ((Associative)coll).valAt(key);
        }
        if (coll instanceof Map) {
            Map m = (Map)coll;
            return m.get(key);
        }
        if (coll instanceof IPersistentSet) {
            IPersistentSet set = (IPersistentSet)coll;
            if (set.contains(key)) {
                return key;
            }
        } else if (key instanceof Number && (coll instanceof String || coll.getClass().isArray())) {
            int n = ((Number)key).intValue();
            if (n >= 0 && n < RT.count(coll)) {
                return RT.nth(coll, n);
            }
            return null;
        }
        return null;
    }

    public static Object get(Object coll, Object key, Object notFound) {
        if (coll == null) {
            return notFound;
        }
        if (coll instanceof Associative) {
            return ((Associative)coll).valAt(key, notFound);
        }
        if (coll instanceof Map) {
            Map m = (Map)coll;
            if (m.containsKey(key)) {
                return m.get(key);
            }
            return notFound;
        }
        if (coll instanceof IPersistentSet) {
            IPersistentSet set = (IPersistentSet)coll;
            if (set.contains(key)) {
                return key;
            }
            return notFound;
        }
        if (key instanceof Number && (coll instanceof String || coll.getClass().isArray())) {
            int n = ((Number)key).intValue();
            return n >= 0 && n < RT.count(coll) ? RT.nth(coll, n) : notFound;
        }
        return notFound;
    }

    public static Associative assoc(Object coll, Object key, Object val) {
        if (coll == null) {
            return new PersistentArrayMap(new Object[]{key, val});
        }
        return ((Associative)coll).assoc(key, val);
    }

    public static Object contains(Object coll, Object key) {
        if (coll == null) {
            return F;
        }
        if (coll instanceof Associative) {
            return ((Associative)coll).containsKey(key) ? T : F;
        }
        if (coll instanceof IPersistentSet) {
            return ((IPersistentSet)coll).contains(key) ? T : F;
        }
        if (coll instanceof Map) {
            Map m = (Map)coll;
            return m.containsKey(key) ? T : F;
        }
        if (key instanceof Number && (coll instanceof String || coll.getClass().isArray())) {
            int n = ((Number)key).intValue();
            return n >= 0 && n < RT.count(coll);
        }
        return F;
    }

    public static Object find(Object coll, Object key) {
        if (coll == null) {
            return null;
        }
        if (coll instanceof Map) {
            Map m = (Map)coll;
            if (m.containsKey(key)) {
                return new MapEntry(key, m.get(key));
            }
            return null;
        }
        return ((Associative)coll).entryAt(key);
    }

    public static ISeq findKey(Keyword key, ISeq keyvals) throws Exception {
        while (keyvals != null) {
            ISeq r = keyvals.rest();
            if (r == null) {
                throw new Exception("Malformed keyword argslist");
            }
            if (keyvals.first() == key) {
                return r;
            }
            keyvals = r.rest();
        }
        return null;
    }

    public static Object dissoc(Object coll, Object key) throws Exception {
        if (coll == null) {
            return null;
        }
        return ((IPersistentMap)coll).without(key);
    }

    public static Object nth(Object coll, int n) {
        if (coll == null) {
            return null;
        }
        if (coll instanceof IPersistentVector) {
            return ((IPersistentVector)coll).nth(n);
        }
        if (coll instanceof String) {
            return Character.valueOf(((String)coll).charAt(n));
        }
        if (coll.getClass().isArray()) {
            return Array.get(coll, n);
        }
        if (coll instanceof List) {
            return ((List)coll).get(n);
        }
        if (coll instanceof Matcher) {
            return ((Matcher)coll).group(n);
        }
        if (coll instanceof Sequential) {
            ISeq seq = ((IPersistentCollection)coll).seq();
            for (int i = 0; i <= n && seq != null; ++i, seq = seq.rest()) {
                if (i != n) continue;
                return seq.first();
            }
            return null;
        }
        throw new UnsupportedOperationException("nth not supported on this type: " + coll.getClass().getSimpleName());
    }

    public static Object assocN(int n, Object val, Object coll) {
        if (coll == null) {
            return null;
        }
        if (coll instanceof IPersistentVector) {
            return ((IPersistentVector)coll).assocN(n, val);
        }
        if (coll instanceof Object[]) {
            Object[] array = (Object[])coll;
            array[n] = val;
            return array;
        }
        return null;
    }

    static boolean hasTag(Object o, Object tag) {
        if (!(o instanceof IObj)) {
            return false;
        }
        IPersistentMap meta = ((IObj)o).meta();
        return Util.equal(tag, RT.get(meta, TAG_KEY));
    }

    public static Object box(Object x) {
        return x;
    }

    public static Character box(char x) {
        return Character.valueOf(x);
    }

    public static Object box(boolean x) {
        return x ? T : F;
    }

    public static Object box(Boolean x) {
        return x;
    }

    public static Number box(byte x) {
        return x;
    }

    public static Number box(short x) {
        return x;
    }

    public static Number box(int x) {
        return x;
    }

    public static Number box(long x) {
        return x;
    }

    public static Number box(float x) {
        return Float.valueOf(x);
    }

    public static Number box(double x) {
        return x;
    }

    public static char charCast(Object x) {
        if (x instanceof Character) {
            return ((Character)x).charValue();
        }
        return (char)((Number)x).intValue();
    }

    public static boolean booleanCast(Object x) {
        if (x instanceof Boolean) {
            return (Boolean)x;
        }
        return x != null;
    }

    public static byte byteCast(Object x) {
        return ((Number)x).byteValue();
    }

    public static short shortCast(Object x) {
        return ((Number)x).shortValue();
    }

    public static int intCast(Object x) {
        if (x instanceof Number) {
            return ((Number)x).intValue();
        }
        return ((Character)x).charValue();
    }

    public static int intCast(int x) {
        return x;
    }

    public static int intCast(float x) {
        return (int)x;
    }

    public static int intCast(long x) {
        return (int)x;
    }

    public static int intCast(double x) {
        return (int)x;
    }

    public static long longCast(Object x) {
        return ((Number)x).longValue();
    }

    public static long longCast(int x) {
        return x;
    }

    public static long longCast(float x) {
        return (long)x;
    }

    public static long longCast(long x) {
        return x;
    }

    public static long longCast(double x) {
        return (long)x;
    }

    public static float floatCast(Object x) {
        return ((Number)x).floatValue();
    }

    public static float floatCast(int x) {
        return x;
    }

    public static float floatCast(float x) {
        return x;
    }

    public static float floatCast(long x) {
        return x;
    }

    public static float floatCast(double x) {
        return (float)x;
    }

    public static double doubleCast(Object x) {
        return ((Number)x).doubleValue();
    }

    public static double doubleCast(int x) {
        return x;
    }

    public static double doubleCast(float x) {
        return x;
    }

    public static double doubleCast(long x) {
        return x;
    }

    public static double doubleCast(double x) {
        return x;
    }

    public static IPersistentMap map(Object ... init) {
        if (init != null && init.length == 2) {
            return new PersistentArrayMap(init);
        }
        return PersistentHashMap.create(init);
    }

    public static IPersistentSet set(Object ... init) {
        return PersistentHashSet.create(init);
    }

    public static IPersistentVector vector(Object ... init) {
        return LazilyPersistentVector.createOwning(init);
    }

    public static IPersistentVector subvec(IPersistentVector v, int start, int end) {
        if (end < start || start < 0 || end > v.count()) {
            throw new IndexOutOfBoundsException();
        }
        if (start == end) {
            return PersistentVector.EMPTY;
        }
        return new APersistentVector.SubVector(null, v, start, end);
    }

    public static ISeq list() {
        return null;
    }

    public static ISeq list(Object arg1) {
        return new PersistentList(arg1);
    }

    public static ISeq list(Object arg1, Object arg2) {
        return RT.listStar(arg1, arg2, null);
    }

    public static ISeq list(Object arg1, Object arg2, Object arg3) {
        return RT.listStar(arg1, arg2, arg3, null);
    }

    public static ISeq list(Object arg1, Object arg2, Object arg3, Object arg4) {
        return RT.listStar(arg1, arg2, arg3, arg4, null);
    }

    public static ISeq list(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return RT.listStar(arg1, arg2, arg3, arg4, arg5, null);
    }

    public static ISeq listStar(Object arg1, ISeq rest) {
        return RT.cons(arg1, rest);
    }

    public static ISeq listStar(Object arg1, Object arg2, ISeq rest) {
        return RT.cons(arg1, RT.cons(arg2, rest));
    }

    public static ISeq listStar(Object arg1, Object arg2, Object arg3, ISeq rest) {
        return RT.cons(arg1, RT.cons(arg2, RT.cons(arg3, rest)));
    }

    public static ISeq listStar(Object arg1, Object arg2, Object arg3, Object arg4, ISeq rest) {
        return RT.cons(arg1, RT.cons(arg2, RT.cons(arg3, RT.cons(arg4, rest))));
    }

    public static ISeq listStar(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, ISeq rest) {
        return RT.cons(arg1, RT.cons(arg2, RT.cons(arg3, RT.cons(arg4, RT.cons(arg5, rest)))));
    }

    public static ISeq arrayToList(Object[] a) throws Exception {
        ISeq ret = null;
        for (int i = a.length - 1; i >= 0; --i) {
            ret = RT.cons(a[i], ret);
        }
        return ret;
    }

    public static Object[] toArray(Object coll) throws Exception {
        if (coll == null) {
            return EMPTY_ARRAY;
        }
        if (coll instanceof Object[]) {
            return (Object[])coll;
        }
        if (coll instanceof Collection) {
            return ((Collection)coll).toArray();
        }
        if (coll instanceof String) {
            char[] chars = ((String)coll).toCharArray();
            Object[] ret = new Object[chars.length];
            for (int i = 0; i < chars.length; ++i) {
                ret[i] = Character.valueOf(chars[i]);
            }
            return ret;
        }
        if (coll.getClass().isArray()) {
            ISeq s = RT.seq(coll);
            Object[] ret = new Object[RT.count(s)];
            int i = 0;
            while (i < ret.length) {
                ret[i] = s.first();
                ++i;
                s = s.rest();
            }
            return ret;
        }
        throw new Exception("Unable to convert: " + coll.getClass() + " to Object[]");
    }

    public static Object[] seqToArray(ISeq seq) {
        int len = RT.length(seq);
        Object[] ret = new Object[len];
        int i = 0;
        while (seq != null) {
            ret[i] = seq.first();
            ++i;
            seq = seq.rest();
        }
        return ret;
    }

    public static Object seqToTypedArray(ISeq seq) throws Exception {
        int len = RT.length(seq);
        Object ret = Array.newInstance(len > 0 ? seq.first().getClass() : Object.class, len);
        int i = 0;
        while (seq != null) {
            Array.set(ret, i, seq.first());
            ++i;
            seq = seq.rest();
        }
        return ret;
    }

    public static int length(ISeq list) {
        int i = 0;
        for (ISeq c = list; c != null; c = c.rest()) {
            ++i;
        }
        return i;
    }

    public static int boundedLength(ISeq list, int limit) throws Exception {
        int i = 0;
        for (ISeq c = list; c != null && i <= limit; ++i, c = c.rest()) {
        }
        return i;
    }

    static Character readRet(int ret) {
        if (ret == -1) {
            return null;
        }
        return RT.box((char)ret);
    }

    public static Character readChar(Reader r) throws Exception {
        int ret = r.read();
        return RT.readRet(ret);
    }

    public static Character peekChar(Reader r) throws Exception {
        int ret;
        if (r instanceof PushbackReader) {
            ret = r.read();
            ((PushbackReader)r).unread(ret);
        } else {
            r.mark(1);
            ret = r.read();
            r.reset();
        }
        return RT.readRet(ret);
    }

    public static int getLineNumber(Reader r) {
        if (r instanceof LineNumberingPushbackReader) {
            return ((LineNumberingPushbackReader)r).getLineNumber();
        }
        return 0;
    }

    public static LineNumberingPushbackReader getLineNumberingReader(Reader r) {
        if (RT.isLineNumberingReader(r)) {
            return (LineNumberingPushbackReader)r;
        }
        return new LineNumberingPushbackReader(r);
    }

    public static boolean isLineNumberingReader(Reader r) {
        return r instanceof LineNumberingPushbackReader;
    }

    public static String resolveClassNameInContext(String className) {
        return className;
    }

    public static boolean suppressRead() {
        return false;
    }

    public static void print(Object x, Writer w) throws Exception {
        Object s;
        Obj o;
        boolean readably = RT.booleanCast(PRINT_READABLY.get());
        if (x instanceof Obj && RT.count((o = (Obj)x).meta()) > 0 && readably && RT.booleanCast(PRINT_META.get())) {
            IPersistentMap meta = o.meta();
            w.write("#^");
            if (meta.count() == 1 && meta.containsKey(TAG_KEY)) {
                RT.print(meta.valAt(TAG_KEY), w);
            } else {
                RT.print(meta, w);
            }
            w.write(32);
        }
        if (x == null) {
            w.write("nil");
        } else if (x instanceof ISeq || x instanceof IPersistentList) {
            w.write(40);
            RT.printInnerSeq(RT.seq(x), w);
            w.write(41);
        } else if (x instanceof String) {
            s = (String)x;
            if (!readably) {
                w.write((String)s);
            } else {
                w.write(34);
                block16: for (int i = 0; i < ((String)s).length(); ++i) {
                    char c = ((String)s).charAt(i);
                    switch (c) {
                        case '\n': {
                            w.write("\\n");
                            continue block16;
                        }
                        case '\t': {
                            w.write("\\t");
                            continue block16;
                        }
                        case '\r': {
                            w.write("\\r");
                            continue block16;
                        }
                        case '\"': {
                            w.write("\\\"");
                            continue block16;
                        }
                        case '\\': {
                            w.write("\\\\");
                            continue block16;
                        }
                        case '\f': {
                            w.write("\\f");
                            continue block16;
                        }
                        case '\b': {
                            w.write("\\b");
                            continue block16;
                        }
                        default: {
                            w.write(c);
                        }
                    }
                }
                w.write(34);
            }
        } else if (x instanceof IPersistentMap) {
            w.write(123);
            for (s = RT.seq(x); s != null; s = s.rest()) {
                IMapEntry e = (IMapEntry)s.first();
                RT.print(e.key(), w);
                w.write(32);
                RT.print(e.val(), w);
                if (s.rest() == null) continue;
                w.write(", ");
            }
            w.write(125);
        } else if (x instanceof IPersistentVector) {
            IPersistentVector a = (IPersistentVector)x;
            w.write(91);
            for (int i = 0; i < a.count(); ++i) {
                RT.print(a.nth(i), w);
                if (i >= a.count() - 1) continue;
                w.write(32);
            }
            w.write(93);
        } else if (x instanceof IPersistentSet) {
            w.write("#{");
            for (s = RT.seq(x); s != null; s = s.rest()) {
                RT.print(s.first(), w);
                if (s.rest() == null) continue;
                w.write(" ");
            }
            w.write(125);
        } else if (x instanceof Character) {
            char c = ((Character)x).charValue();
            if (!readably) {
                w.write(c);
            } else {
                w.write(92);
                switch (c) {
                    case '\n': {
                        w.write("newline");
                        break;
                    }
                    case '\t': {
                        w.write("tab");
                        break;
                    }
                    case ' ': {
                        w.write("space");
                        break;
                    }
                    case '\b': {
                        w.write("backspace");
                        break;
                    }
                    case '\f': {
                        w.write("formfeed");
                        break;
                    }
                    default: {
                        w.write(c);
                    }
                }
            }
        } else if (x instanceof BigDecimal && readably) {
            w.write(x.toString());
            w.write(77);
        } else {
            w.write(x.toString());
        }
    }

    private static void printInnerSeq(ISeq x, Writer w) throws Exception {
        for (ISeq s = x; s != null; s = s.rest()) {
            RT.print(s.first(), w);
            if (s.rest() == null) continue;
            w.write(32);
        }
    }

    public static void formatAesthetic(Writer w, Object obj) throws IOException {
        if (obj == null) {
            w.write("null");
        } else {
            w.write(obj.toString());
        }
    }

    public static void formatStandard(Writer w, Object obj) throws IOException {
        if (obj == null) {
            w.write("null");
        } else if (obj instanceof String) {
            w.write(34);
            w.write((String)obj);
            w.write(34);
        } else if (obj instanceof Character) {
            w.write(92);
            char c = ((Character)obj).charValue();
            switch (c) {
                case '\n': {
                    w.write("newline");
                    break;
                }
                case '\t': {
                    w.write("tab");
                    break;
                }
                case ' ': {
                    w.write("space");
                    break;
                }
                case '\b': {
                    w.write("backspace");
                    break;
                }
                case '\f': {
                    w.write("formfeed");
                    break;
                }
                default: {
                    w.write(c);
                    break;
                }
            }
        } else {
            w.write(obj.toString());
        }
    }

    public static Object format(Object o, String s, Object ... args) throws Exception {
        Writer w = o == null ? new StringWriter() : (Util.equal(o, T) ? (Writer)OUT.get() : (Writer)o);
        RT.doFormat(w, s, ArraySeq.create(args));
        if (o == null) {
            return w.toString();
        }
        return null;
    }

    public static ISeq doFormat(Writer w, String s, ISeq args) throws Exception {
        int i = 0;
        block12: while (i < s.length()) {
            char c = s.charAt(i++);
            block0 : switch (Character.toLowerCase(c)) {
                case '~': {
                    char d = s.charAt(i++);
                    switch (Character.toLowerCase(d)) {
                        case '%': {
                            w.write(10);
                            break block0;
                        }
                        case 't': {
                            w.write(9);
                            break block0;
                        }
                        case 'a': {
                            if (args == null) {
                                throw new IllegalArgumentException("Missing argument");
                            }
                            RT.formatAesthetic(w, RT.first(args));
                            args = RT.rest(args);
                            break block0;
                        }
                        case 's': {
                            if (args == null) {
                                throw new IllegalArgumentException("Missing argument");
                            }
                            RT.formatStandard(w, RT.first(args));
                            args = RT.rest(args);
                            break block0;
                        }
                        case '{': {
                            int j = s.indexOf("~}", i);
                            if (j == -1) {
                                throw new IllegalArgumentException("Missing ~}");
                            }
                            String subs = s.substring(i, j);
                            ISeq sargs = RT.seq(RT.first(args));
                            while (sargs != null) {
                                sargs = RT.doFormat(w, subs, sargs);
                            }
                            args = RT.rest(args);
                            i = j + 2;
                            break block0;
                        }
                        case '^': {
                            if (args != null) continue block12;
                            return null;
                        }
                        case '~': {
                            w.write(126);
                            break block0;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported ~ directive: " + d);
                        }
                    }
                }
                default: {
                    w.write(c);
                }
            }
        }
        return args;
    }

    public static Object[] setValues(Object ... vals) {
        if (vals.length > 0) {
            return vals;
        }
        return null;
    }

    public static ClassLoader makeClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new DynamicClassLoader(ROOT_CLASSLOADER);
            }
        });
    }

    public static Class classForName(String name) throws ClassNotFoundException {
        return Class.forName(name, false, ROOT_CLASSLOADER);
    }

    public static float aget(float[] xs, int i) {
        return xs[i];
    }

    public static float aset(float[] xs, int i, float v) {
        xs[i] = v;
        return v;
    }

    public static int alength(float[] xs) {
        return xs.length;
    }

    public static float[] aclone(float[] xs) {
        return (float[])xs.clone();
    }

    public static double aget(double[] xs, int i) {
        return xs[i];
    }

    public static double aset(double[] xs, int i, double v) {
        xs[i] = v;
        return v;
    }

    public static int alength(double[] xs) {
        return xs.length;
    }

    public static double[] aclone(double[] xs) {
        return (double[])xs.clone();
    }

    public static int aget(int[] xs, int i) {
        return xs[i];
    }

    public static int aset(int[] xs, int i, int v) {
        xs[i] = v;
        return v;
    }

    public static int alength(int[] xs) {
        return xs.length;
    }

    public static int[] aclone(int[] xs) {
        return (int[])xs.clone();
    }

    public static long aget(long[] xs, int i) {
        return xs[i];
    }

    public static long aset(long[] xs, int i, long v) {
        xs[i] = v;
        return v;
    }

    public static int alength(long[] xs) {
        return xs.length;
    }

    public static long[] aclone(long[] xs) {
        return (long[])xs.clone();
    }

    public static char aget(char[] xs, int i) {
        return xs[i];
    }

    public static char aset(char[] xs, int i, char v) {
        xs[i] = v;
        return v;
    }

    public static int alength(char[] xs) {
        return xs.length;
    }

    public static char[] aclone(char[] xs) {
        return (char[])xs.clone();
    }

    public static byte aget(byte[] xs, int i) {
        return xs[i];
    }

    public static byte aset(byte[] xs, int i, byte v) {
        xs[i] = v;
        return v;
    }

    public static int alength(byte[] xs) {
        return xs.length;
    }

    public static byte[] aclone(byte[] xs) {
        return (byte[])xs.clone();
    }

    public static short aget(short[] xs, int i) {
        return xs[i];
    }

    public static short aset(short[] xs, int i, short v) {
        xs[i] = v;
        return v;
    }

    public static int alength(short[] xs) {
        return xs.length;
    }

    public static short[] aclone(short[] xs) {
        return (short[])xs.clone();
    }

    public static boolean aget(boolean[] xs, int i) {
        return xs[i];
    }

    public static boolean aset(boolean[] xs, int i, boolean v) {
        xs[i] = v;
        return v;
    }

    public static int alength(boolean[] xs) {
        return xs.length;
    }

    public static boolean[] aclone(boolean[] xs) {
        return (boolean[])xs.clone();
    }

    public static Object aget(Object[] xs, int i) {
        return xs[i];
    }

    public static Object aset(Object[] xs, int i, Object v) {
        xs[i] = v;
        return v;
    }

    public static int alength(Object[] xs) {
        return xs.length;
    }

    public static Object[] aclone(Object[] xs) {
        return (Object[])xs.clone();
    }

    public static Object aget(Object xs, int i) {
        return Array.get(xs, i);
    }

    public static Object aset(Object xs, int i, Object v) {
        Array.set(xs, i, v);
        return v;
    }

    public static int alength(Object xs) {
        return Array.getLength(xs);
    }

    static {
        Keyword dockw = Keyword.intern(null, "doc");
        Keyword arglistskw = Keyword.intern(null, "arglists");
        Symbol namesym = Symbol.create("name");
        OUT.setTag(Symbol.create("java.io.Writer"));
        CURRENT_NS.setTag(Symbol.create("clojure.lang.Namespace"));
        MATH_CONTEXT.setTag(Symbol.create("java.math.MathContext"));
        Var v = Var.intern(CLOJURE_NS, IN_NAMESPACE, inNamespace);
        v.setMeta(RT.map(dockw, "Sets *ns* to the namespace named by the symbol, creating it if needed.", arglistskw, RT.list(RT.vector(namesym))));
        v = Var.intern(CLOJURE_NS, LOAD_FILE, new AFn(){

            public Object invoke(Object arg1) throws Exception {
                return Compiler.loadFile((String)arg1);
            }
        });
        v.setMeta(RT.map(dockw, "Sequentially read and evaluate the set of forms contained in the file.", arglistskw, RT.list(RT.vector(namesym))));
        v = Var.intern(CLOJURE_NS, IDENTICAL, new AFn(){

            public Object invoke(Object arg1, Object arg2) throws Exception {
                return arg1 == arg2 ? T : F;
            }
        });
        v.setMeta(RT.map(dockw, "Tests if 2 arguments are the same object", arglistskw, RT.list(RT.vector(Symbol.create("x"), Symbol.create("y")))));
        try {
            RT.doInit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

