/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.ISeq;
import clojure.lang.RT;
import clojure.lang.SeqIterator;
import clojure.lang.Util;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public abstract class APersistentSet
extends AFn
implements IPersistentSet,
Collection,
Set {
    int _hash = -1;
    final IPersistentMap impl;

    protected APersistentSet(IPersistentMap meta, IPersistentMap impl) {
        super(meta);
        this.impl = impl;
    }

    public String toString() {
        return RT.printString(this);
    }

    public boolean contains(Object key) {
        return this.impl.containsKey(key);
    }

    public Object get(Object key) {
        return this.impl.valAt(key);
    }

    public int count() {
        return this.impl.count();
    }

    public ISeq seq() {
        return RT.keys(this.impl);
    }

    public Object invoke(Object arg1) throws Exception {
        return this.get(arg1);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Set)) {
            return false;
        }
        Set m = (Set)obj;
        if (m.size() != this.count() || ((Object)m).hashCode() != this.hashCode()) {
            return false;
        }
        for (Object aM : m) {
            if (this.contains(aM)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this._hash == -1) {
            int hash = 0;
            for (ISeq s = this.seq(); s != null; s = s.rest()) {
                Object e = s.first();
                hash += Util.hash(e);
            }
            this._hash = hash;
        }
        return this._hash;
    }

    public Object[] toArray() {
        return RT.seqToArray(this.seq());
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public Object[] toArray(Object[] a) {
        if (a.length >= this.count()) {
            int i = 0;
            for (ISeq s = this.seq(); s != null; s = s.rest()) {
                a[i] = s.first();
                ++i;
            }
            if (a.length > this.count()) {
                a[this.count()] = null;
            }
            return a;
        }
        return this.toArray();
    }

    public int size() {
        return this.count();
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public Iterator iterator() {
        return new SeqIterator(this.seq());
    }
}

