/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.IFn;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentStack;
import clojure.lang.IPersistentVector;
import clojure.lang.IRef;
import clojure.lang.ISeq;
import clojure.lang.LockingTransaction;
import clojure.lang.PersistentHashMap;
import clojure.lang.PersistentQueue;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import clojure.lang.Var;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;

public class Agent
implements IRef {
    volatile Object state;
    volatile IFn validator = null;
    AtomicReference<IPersistentStack> q = new AtomicReference<PersistentQueue>(PersistentQueue.EMPTY);
    AtomicReference<IPersistentMap> watchers = new AtomicReference<PersistentHashMap>(PersistentHashMap.EMPTY);
    volatile ISeq errors = null;
    public static final ExecutorService pooledExecutor = Executors.newFixedThreadPool(2 + Runtime.getRuntime().availableProcessors());
    static final ExecutorService soloExecutor = Executors.newCachedThreadPool();
    static final ThreadLocal<IPersistentVector> nested = new ThreadLocal();

    public static void shutdown() {
        soloExecutor.shutdown();
        pooledExecutor.shutdown();
    }

    public Agent(Object state) throws Exception {
        this(state, null);
    }

    public Agent(Object state, IFn validator) throws Exception {
        this.validator = validator;
        this.setState(state);
    }

    boolean setState(Object newState) throws Exception {
        this.validate(this.getValidator(), newState);
        boolean ret = this.state != newState;
        this.state = newState;
        return ret;
    }

    void validate(IFn vf, Object val) {
        try {
            if (vf != null) {
                vf.invoke(val);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid agent state", e);
        }
    }

    public Object get() throws Exception {
        if (this.errors != null) {
            throw new Exception("Agent has errors", (Exception)RT.first(this.errors));
        }
        return this.state;
    }

    public void setValidator(IFn vf) {
        this.validate(vf, this.state);
        this.validator = vf;
    }

    public IFn getValidator() {
        return this.validator;
    }

    public ISeq getErrors() {
        return this.errors;
    }

    public void clearErrors() {
        this.errors = null;
    }

    public Object dispatch(IFn fn, ISeq args, boolean solo) throws Exception {
        if (this.errors != null) {
            throw new Exception("Agent has errors", (Exception)RT.first(this.errors));
        }
        Action action = new Action(this, fn, args, solo);
        Agent.dispatchAction(action);
        return this;
    }

    static void dispatchAction(Action action) {
        LockingTransaction trans = LockingTransaction.getRunning();
        if (trans != null) {
            trans.enqueue(action);
        } else if (nested.get() != null) {
            nested.set(nested.get().cons(action));
        } else {
            action.agent.enqueue(action);
        }
    }

    void enqueue(Action action) {
        boolean queued = false;
        IPersistentCollection prior = null;
        while (!queued) {
            prior = this.q.get();
            queued = this.q.compareAndSet((IPersistentStack)prior, (IPersistentStack)prior.cons(action));
        }
        if (prior.count() == 0) {
            action.execute();
        }
    }

    public int getQueueCount() {
        return this.q.get().count();
    }

    public Agent addWatch(Object watcher, IFn callback) {
        boolean added = false;
        IPersistentMap prior = null;
        while (!added) {
            prior = this.watchers.get();
            added = this.watchers.compareAndSet(prior, prior.assoc(watcher, callback));
        }
        return this;
    }

    public Agent removeWatch(Object watcher) throws Exception {
        boolean removed = false;
        IPersistentMap prior = null;
        while (!removed) {
            prior = this.watchers.get();
            removed = this.watchers.compareAndSet(prior, prior.without(watcher));
        }
        return this;
    }

    static class Action
    implements Runnable {
        final Agent agent;
        final IFn fn;
        final ISeq args;
        final boolean solo;

        public Action(Agent agent, IFn fn, ISeq args, boolean solo) {
            this.agent = agent;
            this.args = args;
            this.fn = fn;
            this.solo = solo;
        }

        void execute() {
            if (this.solo) {
                soloExecutor.execute(this);
            } else {
                pooledExecutor.execute(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void doRun(Action action) {
            try {
                Var.pushThreadBindings(RT.map(RT.AGENT, action.agent));
                nested.set(PersistentVector.EMPTY);
                boolean hadError = false;
                boolean changed = false;
                try {
                    changed = action.agent.setState(action.fn.applyTo(RT.cons(action.agent.state, action.args)));
                    for (Object o : action.agent.watchers.get()) {
                        Map.Entry e = (Map.Entry)o;
                        ((IFn)e.getValue()).invoke(e.getKey(), action.agent, RT.box(changed));
                    }
                }
                catch (Exception e) {
                    action.agent.errors = RT.cons(e, action.agent.errors);
                    hadError = true;
                }
                if (!hadError) {
                    for (ISeq s = nested.get().seq(); s != null; s = s.rest()) {
                        Action a = (Action)s.first();
                        a.agent.enqueue(a);
                    }
                }
                boolean popped = false;
                IPersistentCollection next = null;
                while (!popped) {
                    IPersistentStack prior = action.agent.q.get();
                    next = prior.pop();
                    popped = action.agent.q.compareAndSet(prior, (IPersistentStack)next);
                }
                if (next.count() > 0) {
                    ((Action)next.peek()).execute();
                }
            }
            finally {
                nested.set(null);
                Var.popThreadBindings();
            }
        }

        public void run() {
            Action.doRun(this);
        }
    }
}

