/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.IStream;
import clojure.lang.RT;
import java.util.concurrent.atomic.AtomicInteger;

public class ArrayStream
implements IStream {
    final AtomicInteger ai = new AtomicInteger(0);
    final Object[] array;

    public ArrayStream(Object[] array) {
        this.array = array;
    }

    public Object next() throws Exception {
        int i = this.ai.getAndIncrement();
        if (i < this.array.length) {
            return this.array[i];
        }
        return RT.eos();
    }

    static IStream createFromObject(Object array) {
        Class<?> aclass = array.getClass().getComponentType();
        if (!aclass.isPrimitive()) {
            return new ArrayStream((Object[])array);
        }
        if (aclass == Integer.TYPE) {
            return new ArrayStream_int((int[])array);
        }
        if (aclass == Long.TYPE) {
            return new ArrayStream_long((long[])array);
        }
        if (aclass == Float.TYPE) {
            return new ArrayStream_float((float[])array);
        }
        if (aclass == Double.TYPE) {
            return new ArrayStream_double((double[])array);
        }
        if (aclass == Character.TYPE) {
            return new ArrayStream_char((char[])array);
        }
        if (aclass == Byte.TYPE) {
            return new ArrayStream_byte((byte[])array);
        }
        if (aclass == Short.TYPE) {
            return new ArrayStream_short((short[])array);
        }
        if (aclass == Boolean.TYPE) {
            return new ArrayStream_boolean((boolean[])array);
        }
        throw new IllegalArgumentException(String.format("Unsupported array type %s", array));
    }

    public static class ArrayStream_boolean
    implements IStream {
        final AtomicInteger ai = new AtomicInteger(0);
        final boolean[] array;

        public ArrayStream_boolean(boolean[] array) {
            this.array = array;
        }

        public Object next() throws Exception {
            int i = this.ai.getAndIncrement();
            if (i < this.array.length) {
                return this.array[i];
            }
            return RT.eos();
        }
    }

    public static class ArrayStream_short
    implements IStream {
        final AtomicInteger ai = new AtomicInteger(0);
        final short[] array;

        public ArrayStream_short(short[] array) {
            this.array = array;
        }

        public Object next() throws Exception {
            int i = this.ai.getAndIncrement();
            if (i < this.array.length) {
                return this.array[i];
            }
            return RT.eos();
        }
    }

    public static class ArrayStream_byte
    implements IStream {
        final AtomicInteger ai = new AtomicInteger(0);
        final byte[] array;

        public ArrayStream_byte(byte[] array) {
            this.array = array;
        }

        public Object next() throws Exception {
            int i = this.ai.getAndIncrement();
            if (i < this.array.length) {
                return this.array[i];
            }
            return RT.eos();
        }
    }

    public static class ArrayStream_char
    implements IStream {
        final AtomicInteger ai = new AtomicInteger(0);
        final char[] array;

        public ArrayStream_char(char[] array) {
            this.array = array;
        }

        public Object next() throws Exception {
            int i = this.ai.getAndIncrement();
            if (i < this.array.length) {
                return Character.valueOf(this.array[i]);
            }
            return RT.eos();
        }
    }

    public static class ArrayStream_double
    implements IStream {
        final AtomicInteger ai = new AtomicInteger(0);
        final double[] array;

        public ArrayStream_double(double[] array) {
            this.array = array;
        }

        public Object next() throws Exception {
            int i = this.ai.getAndIncrement();
            if (i < this.array.length) {
                return this.array[i];
            }
            return RT.eos();
        }
    }

    public static class ArrayStream_float
    implements IStream {
        final AtomicInteger ai = new AtomicInteger(0);
        final float[] array;

        public ArrayStream_float(float[] array) {
            this.array = array;
        }

        public Object next() throws Exception {
            int i = this.ai.getAndIncrement();
            if (i < this.array.length) {
                return Float.valueOf(this.array[i]);
            }
            return RT.eos();
        }
    }

    public static class ArrayStream_long
    implements IStream {
        final AtomicInteger ai = new AtomicInteger(0);
        final long[] array;

        public ArrayStream_long(long[] array) {
            this.array = array;
        }

        public Object next() throws Exception {
            int i = this.ai.getAndIncrement();
            if (i < this.array.length) {
                return this.array[i];
            }
            return RT.eos();
        }
    }

    public static class ArrayStream_int
    implements IStream {
        final AtomicInteger ai = new AtomicInteger(0);
        final int[] array;

        public ArrayStream_int(int[] array) {
            this.array = array;
        }

        public Object next() throws Exception {
            int i = this.ai.getAndIncrement();
            if (i < this.array.length) {
                return this.array[i];
            }
            return RT.eos();
        }
    }
}

