/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.IFn;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.ISeq;
import clojure.lang.PersistentHashMap;
import clojure.lang.PersistentHashSet;
import clojure.lang.RT;
import clojure.lang.Var;
import java.util.Map;

public class MultiFn
extends AFn {
    public final IFn dispatchFn;
    public final Object defaultDispatchVal;
    IPersistentMap methodTable;
    IPersistentMap preferTable;
    IPersistentMap methodCache;
    Object cachedHierarchy;
    static final Var assoc = RT.var("clojure.core", "assoc");
    static final Var dissoc = RT.var("clojure.core", "dissoc");
    static final Var isa = RT.var("clojure.core", "isa?");
    static final Var parents = RT.var("clojure.core", "parents");
    static final Var hierarchy = RT.var("clojure.core", "global-hierarchy");

    public MultiFn(IFn dispatchFn, Object defaultDispatchVal) throws Exception {
        this.dispatchFn = dispatchFn;
        this.defaultDispatchVal = defaultDispatchVal;
        this.methodCache = this.methodTable = PersistentHashMap.EMPTY;
        this.preferTable = PersistentHashMap.EMPTY;
        this.cachedHierarchy = null;
    }

    public synchronized MultiFn addMethod(Object dispatchVal, IFn method) throws Exception {
        this.methodTable = this.methodTable.assoc(dispatchVal, method);
        this.resetCache();
        return this;
    }

    public synchronized MultiFn removeMethod(Object dispatchVal) throws Exception {
        this.methodTable = this.methodTable.without(dispatchVal);
        this.resetCache();
        return this;
    }

    public synchronized MultiFn preferMethod(Object dispatchValX, Object dispatchValY) throws Exception {
        if (this.prefers(dispatchValY, dispatchValX)) {
            throw new IllegalStateException(String.format("Preference conflict: %s is already preferred to %s", dispatchValY, dispatchValX));
        }
        this.preferTable = this.preferTable.assoc(dispatchValX, RT.conj((IPersistentCollection)RT.get(this.preferTable, dispatchValX, PersistentHashSet.EMPTY), dispatchValY));
        this.resetCache();
        return this;
    }

    private boolean prefers(Object x, Object y) throws Exception {
        ISeq ps;
        IPersistentSet xprefs = (IPersistentSet)this.preferTable.valAt(x);
        if (xprefs != null && xprefs.contains(y)) {
            return true;
        }
        for (ps = RT.seq(parents.invoke(y)); ps != null; ps = ps.rest()) {
            if (!this.prefers(x, ps.first())) continue;
            return true;
        }
        for (ps = RT.seq(parents.invoke(x)); ps != null; ps = ps.rest()) {
            if (!this.prefers(ps.first(), y)) continue;
            return true;
        }
        return false;
    }

    private boolean isA(Object x, Object y) throws Exception {
        return RT.booleanCast(isa.invoke(x, y));
    }

    private boolean dominates(Object x, Object y) throws Exception {
        return this.prefers(x, y) || this.isA(x, y);
    }

    private IPersistentMap resetCache() {
        this.methodCache = this.methodTable;
        this.cachedHierarchy = hierarchy.get();
        return this.methodCache;
    }

    private synchronized IFn getFn(Object dispatchVal) throws Exception {
        IFn targetFn;
        if (this.cachedHierarchy != hierarchy.get()) {
            this.resetCache();
        }
        if ((targetFn = (IFn)this.methodCache.valAt(dispatchVal)) != null) {
            return targetFn;
        }
        targetFn = this.findAndCacheBestMethod(dispatchVal);
        if (targetFn != null) {
            return targetFn;
        }
        targetFn = (IFn)this.methodTable.valAt(this.defaultDispatchVal);
        if (targetFn == null) {
            throw new IllegalArgumentException(String.format("No method for dispatch value: %s", dispatchVal));
        }
        return targetFn;
    }

    private IFn findAndCacheBestMethod(Object dispatchVal) throws Exception {
        Map.Entry bestEntry = null;
        for (Object o : this.methodTable) {
            Map.Entry e = (Map.Entry)o;
            if (!this.isA(dispatchVal, e.getKey())) continue;
            if (bestEntry == null || this.dominates(e.getKey(), bestEntry.getKey())) {
                bestEntry = e;
            }
            if (this.dominates(bestEntry.getKey(), e.getKey())) continue;
            throw new IllegalArgumentException(String.format("Multiple methods match dispatch value: %s -> %s and %s, and neither is preferred", dispatchVal, e.getKey(), bestEntry.getKey()));
        }
        if (bestEntry == null) {
            return null;
        }
        if (this.cachedHierarchy == hierarchy.get()) {
            this.methodCache = this.methodCache.assoc(dispatchVal, bestEntry.getValue());
            return (IFn)bestEntry.getValue();
        }
        this.resetCache();
        return this.findAndCacheBestMethod(dispatchVal);
    }

    public Object invoke() throws Exception {
        return this.getFn(this.dispatchFn.invoke()).invoke();
    }

    public Object invoke(Object arg1) throws Exception {
        return this.getFn(this.dispatchFn.invoke(arg1)).invoke(arg1);
    }

    public Object invoke(Object arg1, Object arg2) throws Exception {
        return this.getFn(this.dispatchFn.invoke(arg1, arg2)).invoke(arg1, arg2);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3) throws Exception {
        return this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3)).invoke(arg1, arg2, arg3);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4) throws Exception {
        return this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4)).invoke(arg1, arg2, arg3, arg4);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) throws Exception {
        return this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5)).invoke(arg1, arg2, arg3, arg4, arg5);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) throws Exception {
        return this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6)).invoke(arg1, arg2, arg3, arg4, arg5, arg6);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) throws Exception {
        return this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7)).invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8) throws Exception {
        return this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8)).invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9) throws Exception {
        return this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9)).invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10) throws Exception {
        return this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10)).invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11) throws Exception {
        return this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11)).invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12) throws Exception {
        return this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12)).invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13) throws Exception {
        return this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13)).invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14) throws Exception {
        return this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14)).invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15) throws Exception {
        return this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15)).invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16) throws Exception {
        return this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16)).invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17) throws Exception {
        return this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17)).invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18) throws Exception {
        return this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18)).invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19) throws Exception {
        return this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19)).invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19, Object arg20) throws Exception {
        return this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20)).invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19, Object arg20, Object ... args) throws Exception {
        return this.getFn(this.dispatchFn.invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, args)).invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, args);
    }
}

