/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AMapEntry;
import clojure.lang.APersistentMap;
import clojure.lang.ASeq;
import clojure.lang.ArraySeq;
import clojure.lang.Box;
import clojure.lang.IMapEntry;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.RT;
import clojure.lang.SeqIterator;
import clojure.lang.Util;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PersistentHashMap
extends APersistentMap {
    final int count;
    final INode root;
    public static final PersistentHashMap EMPTY = new PersistentHashMap(0, new EmptyNode());

    public static IPersistentMap create(Map other) {
        IPersistentMap ret = EMPTY;
        Iterator i$ = other.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry e = o = i$.next();
            ret = ret.assoc(e.getKey(), e.getValue());
        }
        return ret;
    }

    public static PersistentHashMap create(Object ... init) {
        IPersistentMap ret = EMPTY;
        for (int i = 0; i < init.length; i += 2) {
            ret = ret.assoc(init[i], init[i + 1]);
        }
        return ret;
    }

    public static PersistentHashMap create(List init) {
        IPersistentMap ret = EMPTY;
        Iterator i = init.iterator();
        while (i.hasNext()) {
            Object key = i.next();
            if (!i.hasNext()) {
                throw new IllegalArgumentException(String.format("No value supplied for key: %s", key));
            }
            Object val = i.next();
            ret = ret.assoc(key, val);
        }
        return ret;
    }

    public static PersistentHashMap create(ISeq items) {
        IPersistentMap ret = EMPTY;
        while (items != null) {
            if (items.rest() == null) {
                throw new IllegalArgumentException(String.format("No value supplied for key: %s", items.first()));
            }
            ret = ret.assoc(items.first(), RT.second(items));
            items = items.rest().rest();
        }
        return ret;
    }

    public static PersistentHashMap create(IPersistentMap meta, Object ... init) {
        IPersistentMap ret = EMPTY.withMeta(meta);
        for (int i = 0; i < init.length; i += 2) {
            ret = ret.assoc(init[i], init[i + 1]);
        }
        return ret;
    }

    PersistentHashMap(int count, INode root) {
        this.count = count;
        this.root = root;
    }

    public PersistentHashMap(IPersistentMap meta, int count, INode root) {
        super(meta);
        this.count = count;
        this.root = root;
    }

    public boolean containsKey(Object key) {
        return this.entryAt(key) != null;
    }

    public IMapEntry entryAt(Object key) {
        return this.root.find(Util.hash(key), key);
    }

    public IPersistentMap assoc(Object key, Object val) {
        Box addedLeaf = new Box(null);
        INode newroot = this.root.assoc(0, Util.hash(key), key, val, addedLeaf);
        if (newroot == this.root) {
            return this;
        }
        return new PersistentHashMap(this.meta(), addedLeaf.val == null ? this.count : this.count + 1, newroot);
    }

    public Object valAt(Object key, Object notFound) {
        IMapEntry e = this.entryAt(key);
        if (e != null) {
            return e.val();
        }
        return notFound;
    }

    public Object valAt(Object key) {
        return this.valAt(key, null);
    }

    public IPersistentMap assocEx(Object key, Object val) throws Exception {
        if (this.containsKey(key)) {
            throw new Exception("Key already present");
        }
        return this.assoc(key, val);
    }

    public IPersistentMap without(Object key) {
        INode newroot = this.root.without(Util.hash(key), key);
        if (newroot == this.root) {
            return this;
        }
        if (newroot == null) {
            return EMPTY.withMeta(this.meta());
        }
        return new PersistentHashMap(this.meta(), this.count - 1, newroot);
    }

    public Iterator iterator() {
        return new SeqIterator(this.seq());
    }

    public int count() {
        return this.count;
    }

    public ISeq seq() {
        return this.root.nodeSeq();
    }

    public IPersistentCollection empty() {
        return EMPTY.withMeta(this.meta());
    }

    static int mask(int hash, int shift) {
        return hash >>> shift & 0x1F;
    }

    public PersistentHashMap withMeta(IPersistentMap meta) {
        return new PersistentHashMap(meta, this.count, this.root);
    }

    static final class HashCollisionNode
    implements INode {
        final int hash;
        final LeafNode[] leaves;

        public HashCollisionNode(int hash, LeafNode ... leaves) {
            this.hash = hash;
            this.leaves = leaves;
        }

        public INode assoc(int shift, int hash, Object key, Object val, Box addedLeaf) {
            if (hash == this.hash) {
                int idx = this.findIndex(hash, key);
                if (idx != -1) {
                    if (this.leaves[idx].val == val) {
                        return this;
                    }
                    LeafNode[] newLeaves = (LeafNode[])this.leaves.clone();
                    newLeaves[idx] = new LeafNode(hash, key, val);
                    return new HashCollisionNode(hash, newLeaves);
                }
                LeafNode[] newLeaves = new LeafNode[this.leaves.length + 1];
                System.arraycopy(this.leaves, 0, newLeaves, 0, this.leaves.length);
                LeafNode leafNode = new LeafNode(hash, key, val);
                newLeaves[this.leaves.length] = leafNode;
                addedLeaf.val = leafNode;
                return new HashCollisionNode(hash, newLeaves);
            }
            return BitmapIndexedNode.create(shift, this, hash, key, val, addedLeaf);
        }

        public INode without(int hash, Object key) {
            int idx = this.findIndex(hash, key);
            if (idx == -1) {
                return this;
            }
            if (this.leaves.length == 2) {
                return idx == 0 ? this.leaves[1] : this.leaves[0];
            }
            LeafNode[] newLeaves = new LeafNode[this.leaves.length - 1];
            System.arraycopy(this.leaves, 0, newLeaves, 0, idx);
            System.arraycopy(this.leaves, idx + 1, newLeaves, idx, this.leaves.length - (idx + 1));
            return new HashCollisionNode(hash, newLeaves);
        }

        public LeafNode find(int hash, Object key) {
            int idx = this.findIndex(hash, key);
            if (idx != -1) {
                return this.leaves[idx];
            }
            return null;
        }

        public ISeq nodeSeq() {
            return ArraySeq.create(this.leaves);
        }

        int findIndex(int hash, Object key) {
            for (int i = 0; i < this.leaves.length; ++i) {
                if (this.leaves[i].find(hash, key) == null) continue;
                return i;
            }
            return -1;
        }

        public int getHash() {
            return this.hash;
        }
    }

    static final class LeafNode
    extends AMapEntry
    implements INode {
        final int hash;
        final Object key;
        final Object val;

        public LeafNode(int hash, Object key, Object val) {
            this.hash = hash;
            this.key = key;
            this.val = val;
        }

        public INode assoc(int shift, int hash, Object key, Object val, Box addedLeaf) {
            if (hash == this.hash) {
                if (Util.equal(key, this.key)) {
                    if (val == this.val) {
                        return this;
                    }
                    return new LeafNode(hash, key, val);
                }
                LeafNode newLeaf = new LeafNode(hash, key, val);
                addedLeaf.val = newLeaf;
                return new HashCollisionNode(hash, this, newLeaf);
            }
            return BitmapIndexedNode.create(shift, this, hash, key, val, addedLeaf);
        }

        public INode without(int hash, Object key) {
            if (hash == this.hash && Util.equal(key, this.key)) {
                return null;
            }
            return this;
        }

        public LeafNode find(int hash, Object key) {
            if (hash == this.hash && Util.equal(key, this.key)) {
                return this;
            }
            return null;
        }

        public ISeq nodeSeq() {
            return RT.cons(this, null);
        }

        public int getHash() {
            return this.hash;
        }

        public Object key() {
            return this.key;
        }

        public Object val() {
            return this.val;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.val;
        }
    }

    static final class BitmapIndexedNode
    implements INode {
        final int bitmap;
        final INode[] nodes;
        final int shift;
        final int _hash;

        static int bitpos(int hash, int shift) {
            return 1 << PersistentHashMap.mask(hash, shift);
        }

        final int index(int bit) {
            return Integer.bitCount(this.bitmap & bit - 1);
        }

        BitmapIndexedNode(int bitmap, INode[] nodes, int shift) {
            this.bitmap = bitmap;
            this.nodes = nodes;
            this.shift = shift;
            this._hash = nodes[0].getHash();
        }

        static INode create(int bitmap, INode[] nodes, int shift) {
            if (bitmap == -1) {
                return new FullNode(nodes, shift);
            }
            return new BitmapIndexedNode(bitmap, nodes, shift);
        }

        static INode create(int shift, INode branch, int hash, Object key, Object val, Box addedLeaf) {
            return new BitmapIndexedNode(BitmapIndexedNode.bitpos(branch.getHash(), shift), new INode[]{branch}, shift).assoc(shift, hash, key, val, addedLeaf);
        }

        public INode assoc(int levelShift, int hash, Object key, Object val, Box addedLeaf) {
            int bit = BitmapIndexedNode.bitpos(hash, this.shift);
            int idx = this.index(bit);
            if ((this.bitmap & bit) != 0) {
                INode n = this.nodes[idx].assoc(this.shift + 5, hash, key, val, addedLeaf);
                if (n == this.nodes[idx]) {
                    return this;
                }
                INode[] newnodes = (INode[])this.nodes.clone();
                newnodes[idx] = n;
                return new BitmapIndexedNode(this.bitmap, newnodes, this.shift);
            }
            INode[] newnodes = new INode[this.nodes.length + 1];
            System.arraycopy(this.nodes, 0, newnodes, 0, idx);
            newnodes[idx] = new LeafNode(hash, key, val);
            addedLeaf.val = newnodes[idx];
            System.arraycopy(this.nodes, idx, newnodes, idx + 1, this.nodes.length - idx);
            return BitmapIndexedNode.create(this.bitmap | bit, newnodes, this.shift);
        }

        public INode without(int hash, Object key) {
            int idx;
            INode n;
            int bit = BitmapIndexedNode.bitpos(hash, this.shift);
            if ((this.bitmap & bit) != 0 && (n = this.nodes[idx = this.index(bit)].without(hash, key)) != this.nodes[idx]) {
                if (n == null) {
                    if (this.bitmap == bit) {
                        return null;
                    }
                    INode[] newnodes = new INode[this.nodes.length - 1];
                    System.arraycopy(this.nodes, 0, newnodes, 0, idx);
                    System.arraycopy(this.nodes, idx + 1, newnodes, idx, this.nodes.length - (idx + 1));
                    return new BitmapIndexedNode(this.bitmap & ~bit, newnodes, this.shift);
                }
                INode[] newnodes = (INode[])this.nodes.clone();
                newnodes[idx] = n;
                return new BitmapIndexedNode(this.bitmap, newnodes, this.shift);
            }
            return this;
        }

        public LeafNode find(int hash, Object key) {
            int bit = BitmapIndexedNode.bitpos(hash, this.shift);
            if ((this.bitmap & bit) != 0) {
                return this.nodes[this.index(bit)].find(hash, key);
            }
            return null;
        }

        public int getHash() {
            return this._hash;
        }

        public ISeq nodeSeq() {
            return Seq.create(this, 0);
        }

        static class Seq
        extends ASeq {
            final ISeq s;
            final int i;
            final BitmapIndexedNode node;

            Seq(ISeq s, int i, BitmapIndexedNode node) {
                this.s = s;
                this.i = i;
                this.node = node;
            }

            Seq(IPersistentMap meta, ISeq s, int i, BitmapIndexedNode node) {
                super(meta);
                this.s = s;
                this.i = i;
                this.node = node;
            }

            static ISeq create(BitmapIndexedNode node, int i) {
                if (i >= node.nodes.length) {
                    return null;
                }
                return new Seq(node.nodes[i].nodeSeq(), i, node);
            }

            public Object first() {
                return this.s.first();
            }

            public ISeq rest() {
                ISeq nexts = this.s.rest();
                if (nexts != null) {
                    return new Seq(nexts, this.i, this.node);
                }
                return Seq.create(this.node, this.i + 1);
            }

            public Seq withMeta(IPersistentMap meta) {
                return new Seq(meta, this.s, this.i, this.node);
            }
        }
    }

    static final class FullNode
    implements INode {
        final INode[] nodes;
        final int shift;
        final int _hash;

        static int bitpos(int hash, int shift) {
            return 1 << PersistentHashMap.mask(hash, shift);
        }

        FullNode(INode[] nodes, int shift) {
            this.nodes = nodes;
            this.shift = shift;
            this._hash = nodes[0].getHash();
        }

        public INode assoc(int levelShift, int hash, Object key, Object val, Box addedLeaf) {
            int idx = PersistentHashMap.mask(hash, this.shift);
            INode n = this.nodes[idx].assoc(this.shift + 5, hash, key, val, addedLeaf);
            if (n == this.nodes[idx]) {
                return this;
            }
            INode[] newnodes = (INode[])this.nodes.clone();
            newnodes[idx] = n;
            return new FullNode(newnodes, this.shift);
        }

        public INode without(int hash, Object key) {
            int idx = PersistentHashMap.mask(hash, this.shift);
            INode n = this.nodes[idx].without(hash, key);
            if (n != this.nodes[idx]) {
                if (n == null) {
                    INode[] newnodes = new INode[this.nodes.length - 1];
                    System.arraycopy(this.nodes, 0, newnodes, 0, idx);
                    System.arraycopy(this.nodes, idx + 1, newnodes, idx, this.nodes.length - (idx + 1));
                    return new BitmapIndexedNode(~FullNode.bitpos(hash, this.shift), newnodes, this.shift);
                }
                INode[] newnodes = (INode[])this.nodes.clone();
                newnodes[idx] = n;
                return new FullNode(newnodes, this.shift);
            }
            return this;
        }

        public LeafNode find(int hash, Object key) {
            return this.nodes[PersistentHashMap.mask(hash, this.shift)].find(hash, key);
        }

        public ISeq nodeSeq() {
            return Seq.create(this, 0);
        }

        public int getHash() {
            return this._hash;
        }

        static class Seq
        extends ASeq {
            final ISeq s;
            final int i;
            final FullNode node;

            Seq(ISeq s, int i, FullNode node) {
                this.s = s;
                this.i = i;
                this.node = node;
            }

            Seq(IPersistentMap meta, ISeq s, int i, FullNode node) {
                super(meta);
                this.s = s;
                this.i = i;
                this.node = node;
            }

            static ISeq create(FullNode node, int i) {
                if (i >= node.nodes.length) {
                    return null;
                }
                return new Seq(node.nodes[i].nodeSeq(), i, node);
            }

            public Object first() {
                return this.s.first();
            }

            public ISeq rest() {
                ISeq nexts = this.s.rest();
                if (nexts != null) {
                    return new Seq(nexts, this.i, this.node);
                }
                return Seq.create(this.node, this.i + 1);
            }

            public Seq withMeta(IPersistentMap meta) {
                return new Seq(meta, this.s, this.i, this.node);
            }
        }
    }

    static final class EmptyNode
    implements INode {
        EmptyNode() {
        }

        public INode assoc(int shift, int hash, Object key, Object val, Box addedLeaf) {
            LeafNode ret = new LeafNode(hash, key, val);
            addedLeaf.val = ret;
            return ret;
        }

        public INode without(int hash, Object key) {
            return this;
        }

        public LeafNode find(int hash, Object key) {
            return null;
        }

        public ISeq nodeSeq() {
            return null;
        }

        public int getHash() {
            return 0;
        }
    }

    static interface INode {
        public INode assoc(int var1, int var2, Object var3, Object var4, Box var5);

        public INode without(int var1, Object var2);

        public LeafNode find(int var1, Object var2);

        public ISeq nodeSeq();

        public int getHash();
    }
}

