/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.APersistentSet;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.ISeq;
import clojure.lang.PersistentHashMap;
import java.util.List;

public class PersistentHashSet
extends APersistentSet {
    public static final PersistentHashSet EMPTY = new PersistentHashSet(null, PersistentHashMap.EMPTY);

    public static PersistentHashSet create(Object ... init) {
        PersistentHashSet ret = EMPTY;
        for (int i = 0; i < init.length; ++i) {
            ret = (PersistentHashSet)ret.cons(init[i]);
        }
        return ret;
    }

    public static PersistentHashSet create(List init) {
        PersistentHashSet ret = EMPTY;
        for (Object key : init) {
            ret = (PersistentHashSet)ret.cons(key);
        }
        return ret;
    }

    public static PersistentHashSet create(ISeq items) {
        PersistentHashSet ret = EMPTY;
        while (items != null) {
            ret = (PersistentHashSet)ret.cons(items.first());
            items = items.rest();
        }
        return ret;
    }

    PersistentHashSet(IPersistentMap meta, IPersistentMap impl) {
        super(meta, impl);
    }

    public IPersistentSet disjoin(Object key) throws Exception {
        if (this.contains(key)) {
            return new PersistentHashSet(this.meta(), this.impl.without(key));
        }
        return this;
    }

    public IPersistentSet cons(Object o) {
        if (this.contains(o)) {
            return this;
        }
        return new PersistentHashSet(this.meta(), this.impl.assoc(o, o));
    }

    public IPersistentCollection empty() {
        return EMPTY.withMeta(this.meta());
    }

    public PersistentHashSet withMeta(IPersistentMap meta) {
        return new PersistentHashSet(meta, this.impl);
    }
}

