/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.Associative;
import clojure.lang.Box;
import clojure.lang.IFn;
import clojure.lang.IMapEntry;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import clojure.lang.IRef;
import clojure.lang.ISeq;
import clojure.lang.Keyword;
import clojure.lang.Namespace;
import clojure.lang.PersistentArrayMap;
import clojure.lang.PersistentHashMap;
import clojure.lang.RT;
import clojure.lang.Symbol;
import java.util.concurrent.atomic.AtomicInteger;

public final class Var
implements IFn,
IRef,
IObj {
    static ThreadLocal<Frame> dvals = new ThreadLocal<Frame>(){

        @Override
        protected Frame initialValue() {
            return new Frame();
        }
    };
    static Keyword privateKey = Keyword.intern(null, "private");
    static IPersistentMap privateMeta = new PersistentArrayMap(new Object[]{privateKey, Boolean.TRUE});
    static Keyword macroKey = Keyword.intern(null, "macro");
    static Keyword nameKey = Keyword.intern(null, "name");
    static Keyword nsKey = Keyword.intern(null, "ns");
    volatile Object root;
    final transient AtomicInteger count;
    public final Symbol sym;
    public final Namespace ns;
    volatile IFn validator = null;
    IPersistentMap _meta;

    public static Var intern(Namespace ns, Symbol sym, Object root) {
        return Var.intern(ns, sym, root, true);
    }

    public static Var intern(Namespace ns, Symbol sym, Object root, boolean replaceRoot) {
        Var dvout = ns.intern(sym);
        if (!dvout.hasRoot() || replaceRoot) {
            dvout.bindRoot(root);
        }
        return dvout;
    }

    public String toString() {
        if (this.ns != null) {
            return "#'" + this.ns.name + "/" + this.sym;
        }
        return "#<Var: " + (this.sym != null ? this.sym.toString() : "--unnamed--") + ">";
    }

    public static Var find(Symbol nsQualifiedSym) {
        if (nsQualifiedSym.ns == null) {
            throw new IllegalArgumentException("Symbol must be namespace-qualified");
        }
        Namespace ns = Namespace.find(Symbol.create(nsQualifiedSym.ns));
        if (ns == null) {
            throw new IllegalArgumentException("No such namespace: " + nsQualifiedSym.ns);
        }
        return ns.findInternedVar(Symbol.create(nsQualifiedSym.name));
    }

    public static Var intern(Symbol nsName, Symbol sym) {
        Namespace ns = Namespace.findOrCreate(nsName);
        return Var.intern(ns, sym);
    }

    public static Var internPrivate(String nsName, String sym) {
        Namespace ns = Namespace.findOrCreate(Symbol.intern(nsName));
        Var ret = Var.intern(ns, Symbol.intern(sym));
        ret.setMeta(privateMeta);
        return ret;
    }

    public static Var intern(Namespace ns, Symbol sym) {
        return ns.intern(sym);
    }

    public static Var create() {
        return new Var(null, null);
    }

    public static Var create(Object root) {
        return new Var(null, null, root);
    }

    Var(Namespace ns, Symbol sym) {
        this.ns = ns;
        this.sym = sym;
        this.count = new AtomicInteger();
        this.root = dvals;
        this.setMeta(PersistentHashMap.EMPTY);
    }

    Var(Namespace ns, Symbol sym, Object root) {
        this(ns, sym);
        this.root = root;
    }

    public boolean isBound() {
        return this.hasRoot() || this.count.get() > 0 && Var.dvals.get().bindings.containsKey(this);
    }

    public final Object get() {
        Box b = this.getThreadBinding();
        if (b != null) {
            return b.val;
        }
        if (this.hasRoot()) {
            return this.root;
        }
        throw new IllegalStateException(String.format("Var %s/%s is unbound.", this.ns, this.sym));
    }

    public void setValidator(IFn vf) {
        if (this.isBound()) {
            this.validate(vf, this.getRoot());
        }
        this.validator = vf;
    }

    public IFn getValidator() {
        return this.validator;
    }

    public Object alter(IFn fn, ISeq args) throws Exception {
        this.set(fn.applyTo(RT.cons(this.get(), args)));
        return this;
    }

    void validate(IFn vf, Object val) {
        try {
            if (vf != null) {
                vf.invoke(val);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid var state", e);
        }
    }

    public Object set(Object val) {
        this.validate(this.getValidator(), val);
        Box b = this.getThreadBinding();
        if (b != null) {
            b.val = val;
            return b.val;
        }
        throw new IllegalStateException(String.format("Can't change/establish root binding of: %s with set", this.sym));
    }

    public void setMeta(IPersistentMap m) {
        this._meta = m.assoc(nameKey, this.sym).assoc(nsKey, this.ns);
    }

    public IPersistentMap meta() {
        return this._meta;
    }

    public IObj withMeta(IPersistentMap meta) {
        throw new UnsupportedOperationException("Vars are not values");
    }

    public void setMacro() {
        this._meta = this._meta.assoc(macroKey, RT.T);
    }

    public boolean isMacro() {
        return RT.booleanCast(this._meta.valAt(macroKey));
    }

    public boolean isPublic() {
        return !RT.booleanCast(this._meta.valAt(privateKey));
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getTag() {
        return this._meta.valAt(RT.TAG_KEY);
    }

    public void setTag(Symbol tag) {
        this._meta = this._meta.assoc(RT.TAG_KEY, tag);
    }

    public final boolean hasRoot() {
        return this.root != dvals;
    }

    public synchronized void bindRoot(Object root) {
        this.validate(this.getValidator(), root);
        this.root = root;
        this._meta = this._meta.assoc(macroKey, RT.F);
    }

    synchronized void swapRoot(Object root) {
        this.validate(this.getValidator(), root);
        this.root = root;
    }

    public synchronized void unbindRoot() {
        this.root = dvals;
    }

    public synchronized void commuteRoot(IFn fn) throws Exception {
        Object newRoot = fn.invoke(this.root);
        this.validate(this.getValidator(), newRoot);
        this.root = newRoot;
    }

    public synchronized Object alterRoot(IFn fn, ISeq args) throws Exception {
        Object newRoot = fn.applyTo(RT.cons(this.root, args));
        this.validate(this.getValidator(), newRoot);
        this.root = newRoot;
        return newRoot;
    }

    public static void pushThreadBindings(Associative bindings) {
        Frame f = dvals.get();
        Associative bmap = f.bindings;
        for (ISeq bs = bindings.seq(); bs != null; bs = bs.rest()) {
            IMapEntry e = (IMapEntry)bs.first();
            Var v = (Var)e.key();
            v.validate(v.getValidator(), e.val());
            v.count.incrementAndGet();
            bmap = bmap.assoc(v, new Box(e.val()));
        }
        dvals.set(new Frame(bindings, bmap, f));
    }

    public static void popThreadBindings() {
        Frame f = dvals.get();
        if (f.prev == null) {
            throw new IllegalStateException("Pop without matching push");
        }
        for (ISeq bs = RT.keys(f.frameBindings); bs != null; bs = bs.rest()) {
            Var v = (Var)bs.first();
            v.count.decrementAndGet();
        }
        dvals.set(f.prev);
    }

    public static void releaseThreadBindings() {
        Frame f = dvals.get();
        if (f.prev == null) {
            throw new IllegalStateException("Release without full unwind");
        }
        for (ISeq bs = RT.keys(f.bindings); bs != null; bs = bs.rest()) {
            Var v = (Var)bs.first();
            v.count.decrementAndGet();
        }
        dvals.set(null);
    }

    final Box getThreadBinding() {
        IMapEntry e;
        if (this.count.get() > 0 && (e = Var.dvals.get().bindings.entryAt(this)) != null) {
            return (Box)e.val();
        }
        return null;
    }

    public final IFn fn() {
        return (IFn)this.get();
    }

    public Object call() throws Exception {
        return this.invoke();
    }

    public void run() {
        try {
            this.invoke();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object invoke() throws Exception {
        return this.fn().invoke();
    }

    public Object invoke(Object arg1) throws Exception {
        return this.fn().invoke(arg1);
    }

    public Object invoke(Object arg1, Object arg2) throws Exception {
        return this.fn().invoke(arg1, arg2);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19, Object arg20) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19, Object arg20, Object ... args) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, args);
    }

    public Object applyTo(ISeq arglist) throws Exception {
        return AFn.applyToHelper(this, arglist);
    }

    static class Frame {
        Associative bindings;
        Associative frameBindings;
        Frame prev;

        public Frame() {
            this(PersistentHashMap.EMPTY, PersistentHashMap.EMPTY, null);
        }

        public Frame(Associative frameBindings, Associative bindings, Frame prev) {
            this.frameBindings = frameBindings;
            this.bindings = bindings;
            this.prev = prev;
        }
    }
}

