/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.IFn;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.Obj;
import clojure.lang.PersistentList;
import clojure.lang.RT;
import clojure.lang.SeqIterator;
import clojure.lang.Sequential;
import clojure.lang.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class LazySeq
extends Obj
implements ISeq,
List {
    private IFn fn;
    private ISeq s;

    public LazySeq(IFn fn) {
        this.fn = fn;
    }

    private LazySeq(IPersistentMap meta, ISeq s) {
        super(meta);
        this.fn = null;
        this.s = s;
    }

    public Obj withMeta(IPersistentMap meta) {
        return new LazySeq(meta, this.seq());
    }

    public final synchronized ISeq seq() {
        if (this.fn != null) {
            try {
                this.s = RT.seq(this.fn.invoke());
                this.fn = null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.s;
    }

    public int count() {
        int c = 0;
        for (ISeq s = this.seq(); s != null; s = s.next()) {
            ++c;
        }
        return c;
    }

    public Object first() {
        this.seq();
        if (this.s == null) {
            return null;
        }
        return this.s.first();
    }

    public ISeq next() {
        this.seq();
        if (this.s == null) {
            return null;
        }
        return this.s.next();
    }

    public ISeq more() {
        this.seq();
        if (this.s == null) {
            return PersistentList.EMPTY;
        }
        return this.s.more();
    }

    public ISeq cons(Object o) {
        return RT.cons(o, this.seq());
    }

    public IPersistentCollection empty() {
        return PersistentList.EMPTY;
    }

    public boolean equiv(Object o) {
        return this.equals(o);
    }

    public int hashCode() {
        return Util.hash(this.seq());
    }

    public boolean equals(Object o) {
        ISeq s = this.seq();
        if (s != null) {
            return s.equiv(o);
        }
        return (o instanceof Sequential || o instanceof List) && RT.seq(o) == null;
    }

    public Object[] toArray() {
        return RT.seqToArray(this.seq());
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public Object[] toArray(Object[] a) {
        if (a.length >= this.count()) {
            int i = 0;
            for (ISeq s = this.seq(); s != null; s = s.next()) {
                a[i] = s.first();
                ++i;
            }
            if (a.length > this.count()) {
                a[this.count()] = null;
            }
            return a;
        }
        return this.toArray();
    }

    public int size() {
        return this.count();
    }

    public boolean isEmpty() {
        return this.seq() == null;
    }

    public boolean contains(Object o) {
        for (ISeq s = this.seq(); s != null; s = s.next()) {
            if (!Util.equiv(s.first(), o)) continue;
            return true;
        }
        return false;
    }

    public Iterator iterator() {
        return new SeqIterator(this.seq());
    }

    private List reify() {
        return new ArrayList(this);
    }

    public List subList(int fromIndex, int toIndex) {
        return this.reify().subList(fromIndex, toIndex);
    }

    public Object set(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    public int indexOf(Object o) {
        ISeq s = this.seq();
        int i = 0;
        while (s != null) {
            if (Util.equiv(s.first(), o)) {
                return i;
            }
            s = s.next();
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        return this.reify().lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.reify().listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.reify().listIterator(index);
    }

    public Object get(int index) {
        return RT.nth(this, index);
    }

    public void add(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException();
    }
}

