/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.APersistentVector;
import clojure.lang.Box;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.RT;
import java.util.List;

public class PersistentVector
extends APersistentVector {
    final int cnt;
    final int shift;
    final Object[] root;
    final Object[] tail;
    public static final PersistentVector EMPTY = new PersistentVector(0, 5, RT.EMPTY_ARRAY, RT.EMPTY_ARRAY);

    public static PersistentVector create(ISeq items) {
        PersistentVector ret = EMPTY;
        while (items != null) {
            ret = ret.cons(items.first());
            items = items.next();
        }
        return ret;
    }

    public static PersistentVector create(List items) {
        PersistentVector ret = EMPTY;
        for (Object item : items) {
            ret = ret.cons(item);
        }
        return ret;
    }

    public static PersistentVector create(Object ... items) {
        PersistentVector ret = EMPTY;
        for (Object item : items) {
            ret = ret.cons(item);
        }
        return ret;
    }

    PersistentVector(int cnt, int shift, Object[] root, Object[] tail) {
        super(null);
        this.cnt = cnt;
        this.shift = shift;
        this.root = root;
        this.tail = tail;
    }

    PersistentVector(IPersistentMap meta, int cnt, int shift, Object[] root, Object[] tail) {
        super(meta);
        this.cnt = cnt;
        this.shift = shift;
        this.root = root;
        this.tail = tail;
    }

    final int tailoff() {
        return this.cnt - this.tail.length;
    }

    public Object nth(int i) {
        if (i >= 0 && i < this.cnt) {
            if (i >= this.tailoff()) {
                return this.tail[i & 0x1F];
            }
            Object[] arr = this.root;
            for (int level = this.shift; level > 0; level -= 5) {
                arr = (Object[])arr[i >>> level & 0x1F];
            }
            return arr[i & 0x1F];
        }
        throw new IndexOutOfBoundsException();
    }

    public PersistentVector assocN(int i, Object val) {
        if (i >= 0 && i < this.cnt) {
            if (i >= this.tailoff()) {
                Object[] newTail = new Object[this.tail.length];
                System.arraycopy(this.tail, 0, newTail, 0, this.tail.length);
                newTail[i & 0x1F] = val;
                return new PersistentVector(this.meta(), this.cnt, this.shift, this.root, newTail);
            }
            return new PersistentVector(this.meta(), this.cnt, this.shift, PersistentVector.doAssoc(this.shift, this.root, i, val), this.tail);
        }
        if (i == this.cnt) {
            return this.cons(val);
        }
        throw new IndexOutOfBoundsException();
    }

    private static Object[] doAssoc(int level, Object[] arr, int i, Object val) {
        Object[] ret = (Object[])arr.clone();
        if (level == 0) {
            ret[i & 0x1F] = val;
        } else {
            int subidx = i >>> level & 0x1F;
            ret[subidx] = PersistentVector.doAssoc(level - 5, (Object[])arr[subidx], i, val);
        }
        return ret;
    }

    public int count() {
        return this.cnt;
    }

    public PersistentVector withMeta(IPersistentMap meta) {
        return new PersistentVector(meta, this.cnt, this.shift, this.root, this.tail);
    }

    public PersistentVector cons(Object val) {
        if (this.tail.length < 32) {
            Object[] newTail = new Object[this.tail.length + 1];
            System.arraycopy(this.tail, 0, newTail, 0, this.tail.length);
            newTail[this.tail.length] = val;
            return new PersistentVector(this.meta(), this.cnt + 1, this.shift, this.root, newTail);
        }
        Box expansion = new Box(null);
        Object[] newroot = this.pushTail(this.shift - 5, this.root, this.tail, expansion);
        int newshift = this.shift;
        if (expansion.val != null) {
            newroot = new Object[]{newroot, expansion.val};
            newshift += 5;
        }
        return new PersistentVector(this.meta(), this.cnt + 1, newshift, newroot, new Object[]{val});
    }

    public IPersistentCollection empty() {
        return EMPTY.withMeta(this.meta());
    }

    private Object[] pushTail(int level, Object[] arr, Object[] tailNode, Box expansion) {
        Object newchild;
        if (level == 0) {
            newchild = tailNode;
        } else {
            newchild = this.pushTail(level - 5, (Object[])arr[arr.length - 1], tailNode, expansion);
            if (expansion.val == null) {
                Object[] ret = (Object[])arr.clone();
                ret[arr.length - 1] = newchild;
                return ret;
            }
            newchild = expansion.val;
        }
        if (arr.length == 32) {
            expansion.val = new Object[]{newchild};
            return arr;
        }
        Object[] ret = new Object[arr.length + 1];
        System.arraycopy(arr, 0, ret, 0, arr.length);
        ret[arr.length] = newchild;
        expansion.val = null;
        return ret;
    }

    public PersistentVector pop() {
        if (this.cnt == 0) {
            throw new IllegalStateException("Can't pop empty vector");
        }
        if (this.cnt == 1) {
            return EMPTY.withMeta(this.meta());
        }
        if (this.tail.length > 1) {
            Object[] newTail = new Object[this.tail.length - 1];
            System.arraycopy(this.tail, 0, newTail, 0, newTail.length);
            return new PersistentVector(this.meta(), this.cnt - 1, this.shift, this.root, newTail);
        }
        Box ptail = new Box(null);
        Object[] newroot = this.popTail(this.shift - 5, this.root, ptail);
        int newshift = this.shift;
        if (newroot == null) {
            newroot = RT.EMPTY_ARRAY;
        }
        if (this.shift > 5 && newroot.length == 1) {
            newroot = (Object[])newroot[0];
            newshift -= 5;
        }
        return new PersistentVector(this.meta(), this.cnt - 1, newshift, newroot, (Object[])ptail.val);
    }

    private Object[] popTail(int shift, Object[] arr, Box ptail) {
        Object[] newchild;
        if (shift > 0 && (newchild = this.popTail(shift - 5, (Object[])arr[arr.length - 1], ptail)) != null) {
            Object[] ret = (Object[])arr.clone();
            ret[arr.length - 1] = newchild;
            return ret;
        }
        if (shift == 0) {
            ptail.val = arr[arr.length - 1];
        }
        if (arr.length == 1) {
            return null;
        }
        Object[] ret = new Object[arr.length - 1];
        System.arraycopy(arr, 0, ret, 0, ret.length);
        return ret;
    }
}

