/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui;

import com.aptana.ide.core.ClassUtils;
import com.aptana.ide.core.Identifiable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImageAssociations {
    private static final String EXTENSION_POINT_ID = "com.aptana.ide.ui.imageAssociations";
    protected static final String TAG_OBJECT_IMAGE = "objectImage";
    protected static final String TAG_IMAGE = "image";
    protected static final String ATT_ID = "id";
    protected static final String ATT_OBJECT_CLASS = "objectClass";
    protected static final String ATT_ICON = "icon";
    private static ImageAssociations instance;
    private Map<String, ImageDescriptor> idToImageMap = new HashMap<String, ImageDescriptor>();
    private Map<String, ImageDescriptor> classNameToImageMap = new HashMap<String, ImageDescriptor>();
    private Map<Class<?>, ImageDescriptor> classToImageMap = new HashMap();

    private ImageAssociations() {
        this.readExtensionRegistry();
    }

    public static ImageAssociations getInstance() {
        if (instance == null) {
            instance = new ImageAssociations();
        }
        return instance;
    }

    private void readExtensionRegistry() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int i = 0;
        while (i < elements.length) {
            this.readElement(elements[i]);
            ++i;
        }
    }

    private void readElement(IConfigurationElement element) {
        if (TAG_IMAGE.equals(element.getName())) {
            String id = element.getAttribute(ATT_ID);
            if (id == null || id.length() == 0) {
                return;
            }
            String icon = element.getAttribute(ATT_ICON);
            if (icon == null || icon.length() == 0) {
                return;
            }
            ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)element.getContributor().getName(), (String)icon);
            if (imageDescriptor == null) {
                return;
            }
            this.idToImageMap.put(id, imageDescriptor);
        } else if (TAG_OBJECT_IMAGE.equals(element.getName())) {
            String clazz = element.getAttribute(ATT_OBJECT_CLASS);
            if (clazz == null || clazz.length() == 0) {
                return;
            }
            String icon = element.getAttribute(ATT_ICON);
            if (icon == null || icon.length() == 0) {
                return;
            }
            ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)element.getContributor().getName(), (String)icon);
            if (imageDescriptor == null) {
                return;
            }
            this.classNameToImageMap.put(clazz, imageDescriptor);
        }
    }

    public ImageDescriptor getImageDescriptor(String id) {
        return this.idToImageMap.get(id);
    }

    public ImageDescriptor getImageDescriptor(Class<?> clazz) {
        ImageDescriptor imageDescriptor = this.classToImageMap.get(clazz);
        if (imageDescriptor == null && !this.classToImageMap.containsKey(clazz)) {
            for (Class i : ClassUtils.getClassesTree(clazz)) {
                imageDescriptor = this.classToImageMap.get(i);
                if (imageDescriptor == null) {
                    imageDescriptor = this.classNameToImageMap.get(i.getName());
                }
                if (imageDescriptor != null) break;
            }
            this.classToImageMap.put(clazz, imageDescriptor);
        }
        return imageDescriptor;
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        ImageDescriptor imageDescriptor;
        if (element == null) {
            return null;
        }
        if (element instanceof Identifiable && (imageDescriptor = this.getImageDescriptor(((Identifiable)element).getId())) != null) {
            return imageDescriptor;
        }
        return this.getImageDescriptor(element.getClass());
    }
}

