/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public final class UIUtils {
    private UIUtils() {
    }

    public static void showErrorMessage(String title, String message) {
        UIUtils.showErrorMessage(title != null ? title : "Error", message, null);
    }

    public static void showErrorMessage(String message, Throwable exception) {
        UIUtils.showErrorMessage("Error", message, exception);
    }

    private static void showErrorMessage(final String title, final String message, final Throwable exception) {
        if (Display.getCurrent() == null || exception != null) {
            UIJob job = new UIJob(title){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (exception == null) {
                        UIUtils.showErrorDialog(title, message);
                        return Status.OK_STATUS;
                    }
                    return new Status(4, "com.aptana.ide.ui", message, exception);
                }
            };
            job.setPriority(10);
            job.setUser(true);
            job.schedule();
        } else {
            UIUtils.showErrorDialog(title, message);
        }
    }

    private static void showErrorDialog(String title, String message) {
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message);
    }
}

