/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.update.portal.clients;

import com.aptana.ide.server.jetty.comet.CometResponderClient;
import com.aptana.ide.update.Activator;
import com.aptana.ide.update.manager.IPlugin;
import com.aptana.ide.update.manager.IPluginManager;
import com.aptana.ide.update.manager.Plugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListPluginsClient
extends CometResponderClient {
    public static final String LIST_PLUGINS = "/portal/plugins/list";

    protected Object getResponse(String toChannel, Object request) {
        if (LIST_PLUGINS.equals(toChannel)) {
            if (this.getPluginManager() == null) {
                return Collections.emptyMap();
            }
            List remotes = this.getPluginManager().getRemotePlugins();
            List installed = this.getPluginManager().getInstalledPlugins();
            HashMap<String, Object> returnMap = new HashMap<String, Object>();
            List<Map<String, Object>> pluginListing = this.createPluginListing(remotes, installed);
            for (Map<String, Object> map : pluginListing) {
                String category = (String)map.get("category");
                LinkedList<Map<String, Object>> listOfCategoryPlugins = (LinkedList<Map<String, Object>>)returnMap.get(category);
                if (listOfCategoryPlugins == null) {
                    listOfCategoryPlugins = new LinkedList<Map<String, Object>>();
                    returnMap.put(category, listOfCategoryPlugins);
                }
                listOfCategoryPlugins.add(map);
            }
            returnMap.put("response", "listPlugins");
            return returnMap;
        }
        return null;
    }

    protected IPluginManager getPluginManager() {
        return Activator.getDefault().getPluginManager();
    }

    private List<Map<String, Object>> createPluginListing(List<Plugin> remotes, List<IPlugin> installed) {
        ArrayList<Map<String, Object>> pluginListing = new ArrayList<Map<String, Object>>();
        for (Plugin plugin : remotes) {
            try {
                Map<String, Object> map = this.createMap(plugin, installed);
                pluginListing.add(map);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        Collections.sort(pluginListing, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                Integer value = (Integer)o1.get("sortweight");
                Integer value2 = (Integer)o2.get("sortweight");
                if (value.intValue() == value2.intValue()) {
                    String name = (String)o1.get("name");
                    String name2 = (String)o2.get("name");
                    return name.compareTo(name2);
                }
                return value.compareTo(value2);
            }
        });
        return pluginListing;
    }

    private Map<String, Object> createMap(Plugin plugin, List<IPlugin> installed) throws CoreException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String id = plugin.getId();
        map.put("id", id);
        map.put("more", plugin.getMore());
        map.put("name", plugin.getName());
        map.put("description", plugin.getDescription());
        map.put("link", plugin.getURL().toString());
        String category = plugin.getCategory();
        if (category == null) {
            category = "utilities";
        }
        if (category.equalsIgnoreCase("Platforms")) {
            category = "platform";
        }
        map.put("category", category);
        int sortweight = plugin.getSortweight();
        if (sortweight == Integer.MAX_VALUE) {
            sortweight = 9;
        }
        map.put("sortweight", sortweight);
        Boolean isInstalled = this.isInstalled(id, installed);
        map.put("installed", isInstalled);
        if (isInstalled.booleanValue()) {
            IPlugin installedFeature = this.getInstalled(id, installed);
            Boolean updateAvailable = new Version(plugin.getVersion()).compareTo((Object)new Version(installedFeature.getVersion())) > 0;
            map.put("update", updateAvailable);
        } else {
            map.put("update", Boolean.FALSE);
        }
        return map;
    }

    private IPlugin getInstalled(String id, List<IPlugin> installed) {
        for (IPlugin ref : installed) {
            String refId = ref.getId();
            if (!refId.equals(id)) continue;
            return ref;
        }
        return null;
    }

    private Boolean isInstalled(String id, List<IPlugin> installed) {
        if (this.getInstalled(id, installed) != null) {
            return true;
        }
        return false;
    }

    protected String[] getSubscriptionIDs() {
        return new String[]{LIST_PLUGINS};
    }
}

