/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.search.epl;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.search.epl.Activator;
import com.aptana.ide.search.epl.AptanaTextSearchQueryProvider;
import com.aptana.ide.search.epl.FileSystemSearchResult;
import com.aptana.ide.search.epl.Messages;
import com.aptana.ide.search.epl.filesystem.ui.text.FileSystemReplaceAction;
import com.aptana.ide.search.epl.filesystem.ui.text.FileSystemSearchPage;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.text.FileSearchPage;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.internal.ui.text.ReplaceAction;
import org.eclipse.search.internal.ui.text.TextSearchPage;
import org.eclipse.search.internal.ui.util.SWTUtil;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AptanaTextSearchPage
extends TextSearchPage {
    public static final String EXTENSION_POINT_ID = "com.aptana.ide.search.epl.internal.ui.text.TextSearchPage";
    private static final int DIRECTORY_SCOPE = 12;
    private static final int OPEN_FILES_SCOPE = 13;
    private ScopeSelectionListener scopeSelectionListener = new ScopeSelectionListener();
    private static final String PAGE_NAME = "TextSearchPage";
    private static final String STORE_SEARCH_DIRECTORY = "SEARCH_DIRECTORY";
    private static final String SEARCH_SCOPE = "SEARCH_SCOPE";
    private ISearchPageContainer fContainer;
    private Text fDirectory;
    private Button fSearchInDirectory;
    private Button fSearchInOpenFiles;
    private String fSearchDirectory;
    private int scope;
    private boolean firstOpen;

    private ISearchQuery newTextQuery() throws CoreException {
        try {
            Method method = TextSearchPage.class.getDeclaredMethod("newQuery", null);
            method.setAccessible(true);
            FileSearchQuery query = (FileSearchQuery)method.invoke((Object)this, null);
            TextSearchPageInput input = new TextSearchPageInput(query.getSearchString(), query.isCaseSensitive(), query.isRegexSearch(), query.getSearchScope(), this.isSearchingInDirectory(), this.getDirectoryText(), this.isSearchingInOpenFiles(), false);
            return new AptanaTextSearchQueryProvider().createQuery(input);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean performAction() {
        try {
            NewSearchUI.runQueryInBackground((ISearchQuery)this.newTextQuery());
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)SearchMessages.TextSearchPage_replace_searchproblems_title, (String)SearchMessages.TextSearchPage_replace_searchproblems_message, (IStatus)e.getStatus());
            return false;
        }
        return true;
    }

    public boolean performReplace() {
        IStatus status;
        block4: {
            try {
                status = NewSearchUI.runQueryInForeground((IRunnableContext)this.getContainer().getRunnableContext(), (ISearchQuery)this.newTextQuery());
                if (!status.matches(8)) break block4;
                return false;
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)SearchMessages.TextSearchPage_replace_searchproblems_title, (String)SearchMessages.TextSearchPage_replace_querycreationproblem_message, (IStatus)e.getStatus());
                return false;
            }
        }
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)SearchMessages.TextSearchPage_replace_searchproblems_title, (String)SearchMessages.TextSearchPage_replace_runproblem_message, (IStatus)status);
        }
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                ISearchResultViewPart view = NewSearchUI.activateSearchResultView();
                if (view != null) {
                    ISearchResultPage page = view.getActivePage();
                    if (page instanceof FileSearchPage) {
                        FileSearchPage filePage = (FileSearchPage)page;
                        new ReplaceAction(filePage.getSite().getShell(), (FileSearchResult)filePage.getInput(), null, true).run();
                    } else if (page instanceof FileSystemSearchPage) {
                        FileSystemSearchPage filePage = (FileSystemSearchPage)page;
                        new FileSystemReplaceAction(filePage.getSite().getShell(), (FileSystemSearchResult)filePage.getInput(), null, true).run();
                    }
                }
            }
        });
        return true;
    }

    private boolean isSearchingInOpenFiles() {
        if (this.fSearchInOpenFiles == null) {
            IdeLog.logError((Plugin)Activator.getDefault(), (String)"Search in open files is null");
            return false;
        }
        return this.fSearchInOpenFiles.getSelection();
    }

    private String getDirectoryText() {
        return this.fDirectory.getText();
    }

    private boolean isSearchingInDirectory() {
        if (this.fSearchInDirectory == null) {
            IdeLog.logError((Plugin)Activator.getDefault(), (String)"Search in directory is null");
            return false;
        }
        return this.fSearchInDirectory.getSelection();
    }

    public void createControl(final Composite parent) {
        super.createControl(parent);
        this.readConfiguration();
        final Composite result = (Composite)parent.getChildren()[0];
        result.setLayoutData((Object)new GridData(1808));
        parent.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                AptanaTextSearchPage.this.modifyScope(parent, result);
            }
        });
        Point computeSize = parent.getShell().computeSize(-1, -1);
        Point size = parent.getShell().getSize();
        parent.getShell().setMinimumSize(computeSize);
        if (size.x < computeSize.x || size.y < computeSize.y) {
            parent.getShell().setSize(computeSize.x, computeSize.y);
        }
        parent.getDisplay().asyncExec(new Runnable(){

            public void run() {
                AptanaTextSearchPage.this.modifyScope(parent, result);
                parent.getShell().layout(true, true);
            }
        });
    }

    public void setContainer(ISearchPageContainer container) {
        this.fContainer = container;
        super.setContainer(container);
    }

    private ISearchPageContainer getContainer() {
        return this.fContainer;
    }

    public void dispose() {
        this.writeConfiguration();
        super.dispose();
    }

    private IDialogSettings getDialogSettings() {
        return SearchPlugin.getDefault().getDialogSettingsSection(PAGE_NAME);
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        try {
            this.scope = s.getInt(SEARCH_SCOPE);
        }
        catch (Exception exception) {
            this.scope = 0;
        }
        this.fSearchDirectory = s.get(STORE_SEARCH_DIRECTORY);
        if (this.fSearchDirectory == null) {
            this.fSearchDirectory = "";
        }
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        s.put(STORE_SEARCH_DIRECTORY, this.fSearchDirectory);
        s.put(SEARCH_SCOPE, this.scope);
    }

    private void modifyScope(Composite parent, Composite result) {
        try {
            IdeLog.logInfo((Plugin)Activator.getDefault(), (String)StringUtils.format((String)"Accessing children of ", (Object[])new Object[]{parent.toString()}));
            Control[] children = parent.getChildren();
            IdeLog.logInfo((Plugin)Activator.getDefault(), (String)StringUtils.format((String)"children taken ", (Object[])new Object[]{parent.toString()}));
            try {
                int a = 0;
                while (a < children.length) {
                    if (children[a] != result && !this.firstOpen) {
                        Control[] children2;
                        IdeLog.logInfo((Plugin)Activator.getDefault(), (String)"Search in directory UI is creating");
                        this.firstOpen = true;
                        children = ((Composite)children[a]).getChildren();
                        final Group scopeGroup = (Group)children[0];
                        Control[] controlArray = children2 = scopeGroup.getChildren();
                        int n = children2.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Control control2 = controlArray[n2];
                            if (control2 instanceof Button) {
                                Button m = (Button)control2;
                                if ((m.getStyle() & 0x10) != 0) {
                                    m.addSelectionListener((SelectionListener)this.scopeSelectionListener);
                                }
                                if ((m.getStyle() & 8) != 0) {
                                    GridData gridData = new GridData();
                                    m.setLayoutData((Object)gridData);
                                    gridData.widthHint = SWTUtil.getButtonWidthHint((Button)m);
                                    m.setLayoutData((Object)gridData);
                                }
                            }
                            ++n2;
                        }
                        this.fSearchInDirectory = new Button((Composite)scopeGroup, 16);
                        this.fSearchInDirectory.setText(Messages.DIRECTORY);
                        this.fSearchInDirectory.addSelectionListener((SelectionListener)this.scopeSelectionListener);
                        this.fSearchInDirectory.setData((Object)new Integer(12));
                        IdeLog.logInfo((Plugin)Activator.getDefault(), (String)"Search in directory UI is nearly created");
                        this.fDirectory = new Text((Composite)scopeGroup, 2056);
                        GridData gridData = new GridData(768);
                        gridData.horizontalIndent = 8;
                        gridData.horizontalSpan = 2;
                        this.fDirectory.setLayoutData((Object)gridData);
                        this.fDirectory.setText(this.fSearchDirectory);
                        IdeLog.logInfo((Plugin)Activator.getDefault(), (String)"Search in directory was created");
                        Button choose = new Button((Composite)scopeGroup, 8);
                        choose.setText(Messages.CHOOSE);
                        choose.addSelectionListener(new SelectionListener(){

                            public void widgetDefaultSelected(SelectionEvent e) {
                            }

                            public void widgetSelected(SelectionEvent e) {
                                DirectoryDialog ddialog = new DirectoryDialog(AptanaTextSearchPage.this.fSearchInDirectory.getShell(), 0);
                                String open = ddialog.open();
                                if (open != null) {
                                    AptanaTextSearchPage.this.fSearchDirectory = open;
                                    AptanaTextSearchPage.this.writeConfiguration();
                                    AptanaTextSearchPage.this.fDirectory.setText(open);
                                    if (AptanaTextSearchPage.this.fSearchInDirectory.getSelection()) {
                                        AptanaTextSearchPage.this.getContainer().setPerformActionEnabled(AptanaTextSearchPage.this.fDirectory.getText().length() > 0);
                                    }
                                }
                            }
                        });
                        this.fSearchInOpenFiles = new Button((Composite)scopeGroup, 16);
                        this.fSearchInOpenFiles.addSelectionListener((SelectionListener)this.scopeSelectionListener);
                        this.fSearchInOpenFiles.setText(Messages.OPEN_EDITORS);
                        this.fSearchInOpenFiles.setData((Object)new Integer(13));
                        this.fSearchInOpenFiles.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
                        GridData gridData2 = new GridData();
                        gridData2.widthHint = SWTUtil.getButtonWidthHint((Button)choose);
                        choose.setLayoutData((Object)gridData2);
                        this.fSearchInDirectory.addSelectionListener(new SelectionListener(){

                            public void widgetDefaultSelected(SelectionEvent e) {
                            }

                            public void widgetSelected(SelectionEvent e) {
                                Control[] c;
                                boolean selection = AptanaTextSearchPage.this.fSearchInDirectory.getSelection();
                                if (!selection) {
                                    AptanaTextSearchPage.this.getContainer().setPerformActionEnabled(true);
                                    return;
                                }
                                AptanaTextSearchPage.this.getContainer().setSelectedScope(1);
                                Control[] controlArray = c = scopeGroup.getChildren();
                                int n = c.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Button b;
                                    Control cm = controlArray[n2];
                                    if (cm instanceof Button && (b = (Button)cm) != AptanaTextSearchPage.this.fSearchInDirectory && b.getSelection()) {
                                        b.setSelection(false);
                                    }
                                    ++n2;
                                }
                                AptanaTextSearchPage.this.getContainer().setPerformActionEnabled(AptanaTextSearchPage.this.fDirectory.getText().length() > 0);
                            }
                        });
                        scopeGroup.layout(true, true);
                        this.selectCurrentScope();
                        break;
                    }
                    ++a;
                }
                if (this.fSearchInDirectory == null) {
                    IdeLog.logError((Plugin)Activator.getDefault(), (String)"Search in directory UI was not created");
                }
            }
            catch (Throwable e) {
                IdeLog.logError((Plugin)Activator.getDefault(), (String)"Exception while modifing scope", (Throwable)e);
            }
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)Activator.getDefault(), (String)"Exception on top of  modifing scope", (Throwable)e);
        }
    }

    private void selectCurrentScope() {
        if (this.fSearchInDirectory != null) {
            Control[] children;
            Composite parent = this.fSearchInDirectory.getParent();
            Control[] controlArray = children = parent.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object data;
                Button btn;
                Control child = controlArray[n2];
                if (child instanceof Button && ((btn = (Button)child).getStyle() & 0x10) != 0 && (data = btn.getData()) != null && data instanceof Integer) {
                    if ((Integer)data == this.scope) {
                        Display.getCurrent().asyncExec(new Runnable(){

                            public void run() {
                                btn.setSelection(true);
                            }
                        });
                        break;
                    }
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            btn.setSelection(false);
                        }
                    });
                }
                ++n2;
            }
        }
    }

    private class ScopeSelectionListener
    implements SelectionListener {
        private ScopeSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Object data;
            if (!AptanaTextSearchPage.this.firstOpen) {
                return;
            }
            Widget widget = e.widget;
            if (widget != null && (data = widget.getData()) != null && data instanceof Integer) {
                AptanaTextSearchPage.this.scope = (Integer)data;
            }
        }
    }

    public static class TextSearchPageInput
    extends TextSearchQueryProvider.TextSearchInput {
        private final String fSearchText;
        private final boolean fIsCaseSensitive;
        private final boolean fIsRegEx;
        private final FileTextSearchScope fScope;
        private final boolean isDirectory;
        private final String directory;
        private final boolean isOpenFiles;
        private boolean fIsIgnoreLineEndings;
        public boolean doRefresh;

        public boolean isDirectory() {
            return this.isDirectory;
        }

        public String getDirectory() {
            return this.directory;
        }

        public boolean isIgnoreLineEndings() {
            return this.fIsIgnoreLineEndings;
        }

        public boolean isOpenFiles() {
            return this.isOpenFiles;
        }

        public TextSearchPageInput(String searchText, boolean isCaseSensitive, boolean isRegEx, FileTextSearchScope scope, boolean isDir, String directory, boolean openFiles, boolean isIgnoreLineEndings) {
            this.fSearchText = searchText;
            this.isDirectory = isDir;
            this.directory = directory;
            this.isOpenFiles = openFiles;
            this.fIsCaseSensitive = isCaseSensitive;
            this.fIsRegEx = isRegEx;
            this.fScope = scope;
            this.fIsIgnoreLineEndings = isIgnoreLineEndings;
        }

        public String getSearchText() {
            return this.fSearchText;
        }

        public boolean isCaseSensitiveSearch() {
            return this.fIsCaseSensitive;
        }

        public boolean isRegExSearch() {
            return this.fIsRegEx;
        }

        public FileTextSearchScope getScope() {
            return this.fScope;
        }

        public boolean isRefresh() {
            return this.doRefresh;
        }
    }
}

