/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.search.epl.filesystem.ui.text;

import java.io.File;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.internal.core.refactoring.Changes;

public class FileSystemContentStamps {
    public static final ContentStamp NULL_CONTENT_STAMP = new NullContentStamp();

    public static ContentStamp get(File file, IDocument document) {
        if (document instanceof IDocumentExtension4) {
            long stamp = ((IDocumentExtension4)document).getModificationStamp();
            if (stamp == -1L) {
                return NULL_CONTENT_STAMP;
            }
            return ContentStampImpl.createDocumentStamp(stamp, file.lastModified());
        }
        long stamp = file.lastModified();
        if (stamp == 0L) {
            return NULL_CONTENT_STAMP;
        }
        return ContentStampImpl.createFileStamp(stamp);
    }

    public static void set(File file, ContentStamp s) throws CoreException {
        if (!(s instanceof ContentStampImpl)) {
            return;
        }
        ContentStampImpl stamp = (ContentStampImpl)s;
        long value = stamp.getFileValue();
        Assert.isTrue((value != 0L ? 1 : 0) != 0);
        file.setLastModified(0L);
    }

    public static boolean set(IDocument document, ContentStamp s) throws CoreException {
        if (!(s instanceof ContentStampImpl)) {
            return false;
        }
        ContentStampImpl stamp = (ContentStampImpl)s;
        if (document instanceof IDocumentExtension4 && stamp.isDocumentStamp()) {
            try {
                ((IDocumentExtension4)document).replace(0, 0, "", stamp.getValue());
                return true;
            }
            catch (BadLocationException e) {
                throw Changes.asCoreException((BadLocationException)e);
            }
        }
        return false;
    }

    private static class ContentStampImpl
    extends ContentStamp {
        private int fKind;
        private long fValue;
        private long fFileStamp;
        public static final int FILE = 1;
        public static final int DOCUMENT = 2;

        private static ContentStamp createFileStamp(long value) {
            return new ContentStampImpl(1, value, value);
        }

        private static ContentStamp createDocumentStamp(long value, long fileValue) {
            return new ContentStampImpl(2, value, fileValue);
        }

        private ContentStampImpl(int kind, long value, long filestamp) {
            this.fKind = kind;
            this.fValue = value;
            this.fFileStamp = filestamp;
        }

        public boolean isDocumentStamp() {
            return this.fKind == 2;
        }

        public long getValue() {
            return this.fValue;
        }

        public long getFileValue() {
            return this.fFileStamp;
        }

        public boolean isNullStamp() {
            return false;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ContentStampImpl)) {
                return false;
            }
            return ((ContentStampImpl)((Object)obj)).fValue == this.fValue;
        }

        public int hashCode() {
            return (int)this.fValue;
        }

        public String toString() {
            return "Stamp: " + this.fValue;
        }
    }

    private static class NullContentStamp
    extends ContentStamp {
        private NullContentStamp() {
        }

        public boolean isNullStamp() {
            return true;
        }

        public String toString() {
            return "Null Stamp";
        }
    }
}

