/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.search.epl.filesystem.ui.text;

import com.aptana.ide.search.epl.FileSystemSearchResult;
import com.aptana.ide.search.epl.filesystem.ui.text.FileSystemReplaceConfigurationPage;
import com.aptana.ide.search.epl.filesystem.ui.text.FileSystemReplaceRefactoring;
import com.aptana.ide.search.epl.filesystem.ui.text.SearchMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Shell;

public class FileSystemReplaceAction
extends Action {
    private final FileSystemSearchResult fResult;
    private final Object[] fSelection;
    private final boolean fSkipFiltered;
    private final Shell fShell;

    public FileSystemReplaceAction(Shell shell, FileSystemSearchResult result, Object[] selection, boolean skipFiltered) {
        this.fShell = shell;
        this.fResult = result;
        this.fSelection = selection;
        this.fSkipFiltered = skipFiltered;
    }

    public void run() {
        try {
            FileSystemReplaceRefactoring refactoring = new FileSystemReplaceRefactoring(this.fResult, this.fSelection, this.fSkipFiltered);
            ReplaceWizard refactoringWizard = new ReplaceWizard(refactoring);
            if (this.fSelection == null) {
                refactoringWizard.setDefaultPageTitle(SearchMessages.ReplaceAction_title_all);
            } else {
                refactoringWizard.setDefaultPageTitle(SearchMessages.ReplaceAction_title_selected);
            }
            RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)refactoringWizard);
            op.run(this.fShell, SearchMessages.ReplaceAction_description_operation);
        }
        catch (InterruptedException interruptedException) {}
    }

    public static class ReplaceWizard
    extends RefactoringWizard {
        public ReplaceWizard(Refactoring refactoring) {
            super(refactoring, 4);
        }

        protected void addUserInputPages() {
            this.addPage((IWizardPage)new FileSystemReplaceConfigurationPage((FileSystemReplaceRefactoring)this.getRefactoring()));
        }
    }
}

