/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.search.epl.filesystem.ui.text;

import com.aptana.ide.search.epl.FileSearchQuery;
import com.aptana.ide.search.epl.FileSystemMatch;
import com.aptana.ide.search.epl.FileSystemSearchResult;
import com.aptana.ide.search.epl.filesystem.ui.text.FileSystemTextFileChange;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.search.internal.core.text.PatternConstructor;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.text.PositionTracker;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemReplaceRefactoring
extends Refactoring {
    private final FileSystemSearchResult fResult;
    private final Object[] fSelection;
    private final boolean fSkipFiltered;
    private Map<File, Collection<Match>> fMatches;
    private String fReplaceString;
    private Change fChange;

    public FileSystemReplaceRefactoring(FileSystemSearchResult result, Object[] selection, boolean skipFiltered) {
        Assert.isNotNull((Object)((Object)result));
        this.fResult = result;
        this.fSelection = selection;
        this.fSkipFiltered = skipFiltered;
        this.fMatches = new HashMap<File, Collection<Match>>();
        this.fReplaceString = null;
    }

    public String getName() {
        return SearchMessages.ReplaceRefactoring_refactoring_name;
    }

    public void setReplaceString(String string) {
        this.fReplaceString = string;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        String searchString = this.getQuery().getSearchString();
        if (searchString.length() == 0) {
            return RefactoringStatus.createFatalErrorStatus((String)SearchMessages.ReplaceRefactoring_error_illegal_search_string);
        }
        this.fMatches.clear();
        if (this.fSelection != null) {
            int i = 0;
            while (i < this.fSelection.length) {
                this.collectMatches(this.fSelection[i]);
                ++i;
            }
        } else {
            Object[] elements = this.fResult.getElements();
            int i = 0;
            while (i < elements.length) {
                this.collectMatches(elements[i]);
                ++i;
            }
        }
        if (!this.hasMatches()) {
            return RefactoringStatus.createFatalErrorStatus((String)SearchMessages.ReplaceRefactoring_error_no_matches);
        }
        return new RefactoringStatus();
    }

    private void collectMatches(Object object) throws CoreException {
        if (object instanceof File) {
            Match[] matches = this.fResult.getMatches(object);
            Collection<Match> bucket = null;
            Match[] matchArray = matches;
            int n = matches.length;
            int n2 = 0;
            while (n2 < n) {
                Match match = matchArray[n2];
                FileSystemMatch fileMatch = (FileSystemMatch)match;
                if (!this.isSkipped(fileMatch)) {
                    if (bucket == null) {
                        bucket = this.getBucket((File)object);
                    }
                    bucket.add(fileMatch);
                }
                ++n2;
            }
        }
    }

    public int getNumberOfFiles() {
        return this.fMatches.keySet().size();
    }

    public int getNumberOfMatches() {
        int count = 0;
        Collection<Collection<Match>> buckets = this.fMatches.values();
        for (Collection<Match> bucket : buckets) {
            count += bucket.size();
        }
        return count;
    }

    public boolean hasMatches() {
        return !this.fMatches.isEmpty();
    }

    private boolean isSkipped(FileSystemMatch match) {
        return !this.fSkipFiltered && match.isFiltered();
    }

    private Collection<Match> getBucket(File file) {
        Collection<Match> col = this.fMatches.get(file);
        if (col == null) {
            col = new HashSet<Match>();
            this.fMatches.put(file, col);
        }
        return col;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.fReplaceString == null) {
            return RefactoringStatus.createFatalErrorStatus((String)SearchMessages.ReplaceRefactoring_error_no_replace_string);
        }
        Pattern pattern = null;
        FileSearchQuery query = this.getQuery();
        if (query.isRegexSearch()) {
            pattern = this.createSearchPattern(query);
        }
        RefactoringStatus resultingStatus = new RefactoringStatus();
        Set<File> allFiles = this.fMatches.keySet();
        CompositeChange compositeChange = new CompositeChange(SearchMessages.ReplaceRefactoring_composite_change_name);
        compositeChange.markAsSynthetic();
        ArrayList<MatchGroup> matchGroups = new ArrayList<MatchGroup>();
        boolean hasChanges = false;
        try {
            for (File file : allFiles) {
                Collection<Match> bucket = this.fMatches.get(file);
                if (bucket.isEmpty()) continue;
                try {
                    TextChange change = this.createFileChange(file, pattern, bucket, resultingStatus, matchGroups);
                    if (change == null) continue;
                    compositeChange.add((Change)change);
                    hasChanges = true;
                }
                catch (CoreException e) {
                    String message = Messages.format((String)SearchMessages.ReplaceRefactoring_error_access_file, (Object[])new Object[]{file.getName(), e.getLocalizedMessage()});
                    return RefactoringStatus.createFatalErrorStatus((String)message);
                }
            }
        }
        catch (PatternSyntaxException e) {
            String message = Messages.format((String)SearchMessages.ReplaceRefactoring_error_replacement_expression, (Object)e.getLocalizedMessage());
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        if (!hasChanges && resultingStatus.isOK()) {
            return RefactoringStatus.createFatalErrorStatus((String)SearchMessages.ReplaceRefactoring_error_no_changes);
        }
        compositeChange.add((Change)new SearchResultUpdateChange(this.fResult, matchGroups.toArray(new MatchGroup[matchGroups.size()]), true));
        this.fChange = compositeChange;
        return resultingStatus;
    }

    private TextChange createFileChange(File file, Pattern pattern, Collection<Match> matches, RefactoringStatus resultingStatus, Collection<MatchGroup> matchGroups) throws PatternSyntaxException, CoreException {
        PositionTracker tracker = InternalSearchUI.getInstance().getPositionTracker();
        FileSystemTextFileChange change = new FileSystemTextFileChange(Messages.format((String)SearchMessages.ReplaceRefactoring_group_label_change_for_file, (Object)file.getName()), file);
        change.setEdit((TextEdit)new MultiTextEdit());
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        Path path = new Path(file.getAbsolutePath());
        manager.connect((IPath)path, LocationKind.LOCATION, null);
        try {
            ITextFileBuffer textFileBuffer = manager.getTextFileBuffer((IPath)path, LocationKind.LOCATION);
            if (textFileBuffer == null) {
                resultingStatus.addError(Messages.format((String)SearchMessages.ReplaceRefactoring_error_accessing_file_buffer, (Object)file.getName()));
                return null;
            }
            IDocument document = textFileBuffer.getDocument();
            String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
            for (Match fileMatch : matches) {
                String originalText;
                FileSystemMatch match = (FileSystemMatch)fileMatch;
                int offset = match.getOffset();
                int length = match.getLength();
                Position currentPosition = tracker.getCurrentPosition((Match)match);
                if (currentPosition != null) {
                    offset = currentPosition.offset;
                    if (length != currentPosition.length) {
                        resultingStatus.addError(Messages.format((String)SearchMessages.ReplaceRefactoring_error_match_content_changed, (Object)file.getName()));
                        continue;
                    }
                }
                if ((originalText = FileSystemReplaceRefactoring.getOriginalText(document, offset, length)) == null) {
                    resultingStatus.addError(Messages.format((String)SearchMessages.ReplaceRefactoring_error_match_content_changed, (Object)file.getName()));
                    continue;
                }
                String replacementString = this.computeReplacementString(pattern, originalText, this.fReplaceString, lineDelimiter);
                if (replacementString == null) {
                    resultingStatus.addError(Messages.format((String)SearchMessages.ReplaceRefactoring_error_match_content_changed, (Object)file.getName()));
                    continue;
                }
                ReplaceEdit replaceEdit = new ReplaceEdit(offset, length, replacementString);
                change.addEdit((TextEdit)replaceEdit);
                TextEditChangeGroup textEditChangeGroup = new TextEditChangeGroup((TextChange)change, new TextEditGroup(SearchMessages.ReplaceRefactoring_group_label_match_replace, (TextEdit)replaceEdit));
                change.addTextEditChangeGroup(textEditChangeGroup);
                matchGroups.add(new MatchGroup(textEditChangeGroup, match));
            }
        }
        finally {
            manager.disconnect((IPath)path, LocationKind.LOCATION, null);
        }
        return change;
    }

    private static String getOriginalText(IDocument doc, int offset, int length) {
        try {
            return doc.get(offset, length);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private Pattern createSearchPattern(FileSearchQuery query) {
        return PatternConstructor.createPattern((String)query.getSearchString(), (boolean)true, (boolean)true, (boolean)query.isCaseSensitive(), (boolean)false);
    }

    private String computeReplacementString(Pattern pattern, String originalText, String replacementText, String lineDelimiter) throws PatternSyntaxException {
        if (pattern != null) {
            StringBuffer sb;
            Matcher matcher;
            try {
                replacementText = PatternConstructor.interpretReplaceEscapes((String)replacementText, (String)originalText, (String)lineDelimiter);
                matcher = pattern.matcher(originalText);
                sb = new StringBuffer();
                matcher.reset();
                if (!matcher.find()) {
                    return null;
                }
                matcher.appendReplacement(sb, replacementText);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new PatternSyntaxException(ex.getLocalizedMessage(), replacementText, -1);
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
        return replacementText;
    }

    public FileSearchQuery getQuery() {
        return (FileSearchQuery)this.fResult.getQuery();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.fChange;
    }

    private static class MatchGroup {
        public TextEditChangeGroup group;
        public FileSystemMatch match;

        public MatchGroup(TextEditChangeGroup group, FileSystemMatch match) {
            this.group = group;
            this.match = match;
        }
    }

    public static class SearchResultUpdateChange
    extends Change {
        private MatchGroup[] fMatchGroups;
        private Match[] fMatches;
        private final FileSystemSearchResult fResult;
        private final boolean fIsRemove;

        public SearchResultUpdateChange(FileSystemSearchResult result, MatchGroup[] matchGroups, boolean isRemove) {
            this.fResult = result;
            this.fMatchGroups = matchGroups;
            this.fMatches = null;
            this.fIsRemove = isRemove;
        }

        public SearchResultUpdateChange(FileSystemSearchResult result, Match[] matches, boolean isRemove) {
            this.fResult = result;
            this.fMatches = matches;
            this.fMatchGroups = null;
            this.fIsRemove = isRemove;
        }

        public Object getModifiedElement() {
            return null;
        }

        public String getName() {
            return SearchMessages.ReplaceRefactoring_result_update_name;
        }

        public void initializeValidationData(IProgressMonitor pm) {
        }

        public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            return new RefactoringStatus();
        }

        private Match[] getMatches() {
            if (this.fMatches == null) {
                ArrayList<FileSystemMatch> matches = new ArrayList<FileSystemMatch>();
                MatchGroup[] matchGroupArray = this.fMatchGroups;
                int n = this.fMatchGroups.length;
                int n2 = 0;
                while (n2 < n) {
                    MatchGroup curr = matchGroupArray[n2];
                    if (curr.group.isEnabled()) {
                        matches.add(curr.match);
                    }
                    ++n2;
                }
                this.fMatches = matches.toArray(new Match[matches.size()]);
                this.fMatchGroups = null;
            }
            return this.fMatches;
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            Match[] matches = this.getMatches();
            if (this.fIsRemove) {
                this.fResult.removeMatches(matches);
            } else {
                this.fResult.addMatches(matches);
            }
            return new SearchResultUpdateChange(this.fResult, matches, !this.fIsRemove);
        }
    }
}

