/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.search.epl.filesystem.ui.text;

import com.aptana.ide.search.epl.AptanaFileSystemMatch;
import com.aptana.ide.search.epl.Compatibility;
import com.aptana.ide.search.epl.ResourceTransferDragAdapter;
import com.aptana.ide.search.epl.filesystem.ui.text.EditorOpener;
import com.aptana.ide.search.epl.filesystem.ui.text.FileLabelProvider;
import com.aptana.ide.search.epl.filesystem.ui.text.FileTableContentProvider;
import com.aptana.ide.search.epl.filesystem.ui.text.FileTreeContentProvider;
import com.aptana.ide.search.epl.filesystem.ui.text.SearchMessages;
import com.aptana.ide.search.epl.filesystem.ui.text.SortAction;
import java.io.File;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.DelegatingDragAdapter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.text.IFileSearchContentProvider;
import org.eclipse.search.internal.ui.text.NewTextSearchActionGroup;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search2.internal.ui.OpenSearchPreferencesAction;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.texteditor.ITextEditor;

public class FileSystemSearchPage
extends AbstractTextSearchViewPage
implements IAdaptable {
    private static final String KEY_SORTING = "org.eclipse.search.resultpage.sorting";
    private ActionGroup fActionGroup;
    private IFileSearchContentProvider fContentProvider;
    private int fCurrentSortOrder;
    private SortAction fSortByNameAction;
    private SortAction fSortByPathAction;
    private EditorOpener fEditorOpener = new EditorOpener();
    private static final String[] SHOW_IN_TARGETS = new String[]{"org.eclipse.ui.views.ResourceNavigator"};
    private static final IShowInTargetList SHOW_IN_TARGET_LIST = new IShowInTargetList(){

        public String[] getShowInTargetIds() {
            return SHOW_IN_TARGETS;
        }
    };
    private IPropertyChangeListener fPropertyChangeListener;

    public Integer getElementLimit1() {
        if (Compatibility.isTableLimited()) {
            return new Integer(Compatibility.getTableLimit());
        }
        return new Integer(-1);
    }

    public FileSystemSearchPage() {
        this.fSortByNameAction = new SortAction(SearchMessages.FileSearchPage_sort_name_label, this, 2);
        this.fSortByPathAction = new SortAction(SearchMessages.FileSearchPage_sort_path_label, this, 3);
        this.fPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (("org.eclipse.search.limitTable".equals(event.getProperty()) || "org.eclipse.search.limitTableTo".equals(event.getProperty())) && FileSystemSearchPage.this.getViewer() instanceof TableViewer) {
                    FileSystemSearchPage.this.getViewPart().updateLabel();
                    FileSystemSearchPage.this.getViewer().refresh();
                }
            }
        };
        SearchPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fPropertyChangeListener);
    }

    private void addDragAdapters(StructuredViewer viewer) {
        Transfer[] transfers = new Transfer[]{ResourceTransfer.getInstance()};
        int ops = 5;
        DelegatingDragAdapter adapter = new DelegatingDragAdapter();
        adapter.addDragSourceListener((TransferDragSourceListener)new ResourceTransferDragAdapter((ISelectionProvider)viewer));
        viewer.addDragSupport(ops, transfers, (DragSourceListener)adapter);
    }

    public StructuredViewer getViewer() {
        return super.getViewer();
    }

    protected void configureTableViewer(TableViewer viewer) {
        viewer.setUseHashlookup(true);
        FileLabelProvider innerLabelProvider = new FileLabelProvider(this, this.fCurrentSortOrder);
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)innerLabelProvider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        viewer.setContentProvider((IContentProvider)new FileTableContentProvider(this));
        viewer.setComparator((ViewerComparator)new DecoratorIgnoringViewerSorter((ILabelProvider)innerLabelProvider));
        this.fContentProvider = (IFileSearchContentProvider)viewer.getContentProvider();
        this.addDragAdapters((StructuredViewer)viewer);
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        viewer.setUseHashlookup(true);
        FileLabelProvider innerLabelProvider = new FileLabelProvider(this, 1);
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)innerLabelProvider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        viewer.setContentProvider((IContentProvider)new FileTreeContentProvider(this, (AbstractTreeViewer)viewer));
        viewer.setComparator((ViewerComparator)new DecoratorIgnoringViewerSorter((ILabelProvider)innerLabelProvider));
        this.fContentProvider = (IFileSearchContentProvider)viewer.getContentProvider();
        this.addDragAdapters((StructuredViewer)viewer);
    }

    protected void showMatch(Match match, int offset, int length, boolean activate) throws PartInitException {
        File file = (File)match.getElement();
        IEditorPart editor = this.fEditorOpener.open(file, activate);
        if (offset != 0 || length != 0) {
            if (editor instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)editor;
                textEditor.selectAndReveal(offset, length);
            } else if (editor != null) {
                this.showWithMarker(editor, file, offset, length);
            }
        }
    }

    protected boolean canRemoveMatchesWith(ISelection selection) {
        if (selection.isEmpty()) {
            TableViewer tv;
            StructuredViewer viewer = this.getViewer();
            if (viewer != null && viewer instanceof TableViewer) {
                tv = (TableViewer)viewer;
                tv.getTable().getParent().setFocus();
                tv.getTable().deselectAll();
            }
            if (viewer != null && viewer instanceof TreeViewer) {
                tv = (TreeViewer)viewer;
                tv.getTree().deselectAll();
            }
        }
        return !selection.isEmpty();
    }

    private void showWithMarker(IEditorPart editor, File file, int offset, int length) throws PartInitException {
        Object marker = null;
        try {
            HashMap<String, Integer> attributes = new HashMap<String, Integer>(4);
            attributes.put("charStart", new Integer(offset));
            attributes.put("charEnd", new Integer(offset + length));
        }
        catch (Throwable throwable) {
            if (marker != null) {
                try {
                    marker.delete();
                }
                catch (CoreException coreException) {}
            }
            throw throwable;
        }
        if (marker != null) {
            try {
                marker.delete();
            }
            catch (CoreException coreException) {}
        }
    }

    protected void fillContextMenu(IMenuManager mgr) {
        super.fillContextMenu(mgr);
        this.addSortActions(mgr);
        this.fActionGroup.setContext(new ActionContext(this.getSite().getSelectionProvider().getSelection()));
        this.fActionGroup.fillContextMenu(mgr);
    }

    private void addSortActions(IMenuManager mgr) {
        if (this.getLayout() != 1) {
            return;
        }
        MenuManager sortMenu = new MenuManager(SearchMessages.FileSearchPage_sort_by_label);
        sortMenu.add((IAction)this.fSortByNameAction);
        sortMenu.add((IAction)this.fSortByPathAction);
        this.fSortByNameAction.setChecked(this.fCurrentSortOrder == this.fSortByNameAction.getSortOrder());
        this.fSortByPathAction.setChecked(this.fCurrentSortOrder == this.fSortByPathAction.getSortOrder());
        mgr.appendToGroup("group.viewerSetup", (IContributionItem)sortMenu);
    }

    public void setInput(ISearchResult newSearch, Object viewState) {
        super.setInput(newSearch, viewState);
        this.getViewer().setSelection((ISelection)new StructuredSelection());
    }

    public void setViewPart(ISearchResultViewPart part) {
        super.setViewPart(part);
        this.fActionGroup = new NewTextSearchActionGroup((IViewPart)part);
    }

    public void init(IPageSite site) {
        super.init(site);
        IMenuManager menuManager = site.getActionBars().getMenuManager();
        menuManager.appendToGroup("group.properties", (IAction)new OpenSearchPreferencesAction());
    }

    public void dispose() {
        this.fActionGroup.dispose();
        SearchPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
        super.dispose();
    }

    protected void elementsChanged(Object[] objects) {
        if (this.fContentProvider != null) {
            this.fContentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this.fContentProvider != null) {
            this.fContentProvider.clear();
        }
    }

    public void setSortOrder(int sortOrder) {
        this.fCurrentSortOrder = sortOrder;
        DecoratingLabelProvider lpWrapper = (DecoratingLabelProvider)this.getViewer().getLabelProvider();
        ((FileLabelProvider)lpWrapper.getLabelProvider()).setOrder(sortOrder);
        this.getViewer().refresh();
        this.getSettings().put(KEY_SORTING, this.fCurrentSortOrder);
    }

    public void restoreState(IMemento memento) {
        Integer value;
        super.restoreState(memento);
        try {
            this.fCurrentSortOrder = this.getSettings().getInt(KEY_SORTING);
        }
        catch (NumberFormatException numberFormatException) {
            this.fCurrentSortOrder = this.fSortByNameAction.getSortOrder();
        }
        if (memento != null && (value = memento.getInteger(KEY_SORTING)) != null) {
            this.fCurrentSortOrder = value;
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putInteger(KEY_SORTING, this.fCurrentSortOrder);
    }

    public Object getAdapter(Class adapter) {
        if (IShowInTargetList.class.equals((Object)adapter)) {
            return SHOW_IN_TARGET_LIST;
        }
        return null;
    }

    public String getLabel() {
        String label = super.getLabel();
        StructuredViewer viewer = this.getViewer();
        if (viewer instanceof TableViewer) {
            int fileCount;
            int itemCount;
            TableViewer tv = (TableViewer)viewer;
            AbstractTextSearchResult result = this.getInput();
            if (result != null && (itemCount = ((IStructuredContentProvider)tv.getContentProvider()).getElements((Object)this.getInput()).length) < (fileCount = this.getInput().getElements().length)) {
                return Messages.format((String)SearchMessages.AptanaFileSearchPage_NOT_ALL_MATCHES, (Object[])new Object[]{label, new Integer(itemCount), new Integer(fileCount)});
            }
        }
        return label;
    }

    public static class DecoratorIgnoringViewerSorter
    extends ViewerComparator {
        private final ILabelProvider fLabelProvider;

        public DecoratorIgnoringViewerSorter(ILabelProvider labelProvider) {
            this.fLabelProvider = labelProvider;
        }

        public int category(Object element) {
            File fl = null;
            fl = element instanceof File ? (File)element : ((AptanaFileSystemMatch)((Object)element)).getFile();
            if (fl.isDirectory()) {
                return 1;
            }
            return 2;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            String name1 = this.fLabelProvider.getText(e1);
            String name2 = this.fLabelProvider.getText(e2);
            if (name1 == null) {
                name1 = "";
            }
            if (name2 == null) {
                name2 = "";
            }
            return this.getComparator().compare(name1, name2);
        }
    }
}

