/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.search.epl.filesystem.ui.text;

import com.aptana.ide.search.epl.filesystem.ui.text.FileSystemContentStamps;
import com.aptana.ide.search.epl.filesystem.ui.text.FileSystemFile;
import com.aptana.ide.search.epl.filesystem.ui.text.UndoFileSystemTextFileChange;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditProcessor;
import org.eclipse.text.edits.UndoEdit;

public class FileSystemTextFileChange
extends TextFileChange {
    private File fFile;
    private int fAcquireCount;
    private ITextFileBuffer fBuffer;
    private ContentStamp fContentStamp;

    public FileSystemTextFileChange(String name, File file) {
        super(name, (IFile)new FileSystemFile(file));
        Assert.isNotNull((Object)file);
        this.fFile = file;
    }

    public File getFileSystemFile() {
        return this.fFile;
    }

    protected Change createUndoChange(UndoEdit edit, ContentStamp stampToRestore) {
        return new UndoFileSystemTextFileChange(this.getName(), this.fFile, edit, this.fContentStamp, this.getSaveMode());
    }

    public Object getModifiedElement() {
        return this.fFile;
    }

    public void initializeValidationData(IProgressMonitor monitor) {
    }

    public RefactoringStatus isValid(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            RefactoringStatus result;
            monitor.beginTask("", 1);
            RefactoringStatus refactoringStatus = result = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            monitor.done();
        }
    }

    protected IDocument acquireDocument(IProgressMonitor pm) throws CoreException {
        ++this.fAcquireCount;
        if (this.fAcquireCount > 1) {
            return this.fBuffer.getDocument();
        }
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        Path path = new Path(this.fFile.getAbsolutePath());
        manager.connect((IPath)path, LocationKind.LOCATION, pm);
        this.fBuffer = manager.getTextFileBuffer((IPath)path, LocationKind.LOCATION);
        IDocument result = this.fBuffer.getDocument();
        this.fContentStamp = FileSystemContentStamps.get(this.fFile, result);
        return result;
    }

    protected void commit(IDocument document, IProgressMonitor pm) throws CoreException {
        if (this.needsSaving()) {
            this.fBuffer.commit(pm, false);
        }
    }

    protected void releaseDocument(IDocument document, IProgressMonitor pm) throws CoreException {
        Assert.isTrue((this.fAcquireCount > 0 ? 1 : 0) != 0);
        if (this.fAcquireCount == 1) {
            ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
            manager.disconnect((IPath)new Path(this.fFile.getAbsolutePath()), LocationKind.LOCATION, pm);
        }
        --this.fAcquireCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UndoEdit performEdits(final IDocument document) throws BadLocationException, MalformedTreeException {
        if (!this.fBuffer.isSynchronizationContextRequested()) {
            return this.performEdits2(document);
        }
        ITextFileBufferManager fileBufferManager = FileBuffers.getTextFileBufferManager();
        final Lock completionLock = new Lock();
        final UndoEdit[] result = new UndoEdit[1];
        final BadLocationException[] exception = new BadLocationException[1];
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Lock lock = completionLock;
                synchronized (lock) {
                    block8: {
                        try {
                            try {
                                result[0] = FileSystemTextFileChange.this.performEdits2(document);
                            }
                            catch (BadLocationException e) {
                                exception[0] = e;
                                completionLock.fDone = true;
                                completionLock.notifyAll();
                                break block8;
                            }
                        }
                        catch (Throwable throwable) {
                            completionLock.fDone = true;
                            completionLock.notifyAll();
                            throw throwable;
                        }
                        completionLock.fDone = true;
                        completionLock.notifyAll();
                    }
                }
            }
        };
        Lock lock = completionLock;
        synchronized (lock) {
            fileBufferManager.execute(runnable);
            while (!completionLock.fDone) {
                try {
                    completionLock.wait(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (exception[0] != null) {
            throw exception[0];
        }
        return result[0];
    }

    protected boolean isDocumentAcquired() {
        return this.fAcquireCount > 0;
    }

    protected boolean isDocumentModified() {
        if (this.fAcquireCount > 0) {
            ContentStamp currentStamp = FileSystemContentStamps.get(this.fFile, this.fBuffer.getDocument());
            return !currentStamp.equals(this.fContentStamp);
        }
        return false;
    }

    private UndoEdit performEdits2(IDocument document) throws BadLocationException {
        DocumentRewriteSession session = null;
        try {
            if (document instanceof IDocumentExtension4) {
                session = ((IDocumentExtension4)document).startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
            }
            LinkedModeModel.closeAllModels((IDocument)document);
            TextEditProcessor processor = this.createTextEditProcessor(document, 1);
            UndoEdit undoEdit = processor.performEdits();
            return undoEdit;
        }
        finally {
            if (session != null) {
                ((IDocumentExtension4)document).stopRewriteSession(session);
            }
        }
    }

    private TextEditProcessor createTextEditProcessor(IDocument document, int flags) {
        if (this.getEdit() == null) {
            return new TextEditProcessor(document, (TextEdit)new MultiTextEdit(0, 0), flags);
        }
        ArrayList<TextEdit> excludes = new ArrayList<TextEdit>(0);
        TextEditBasedChangeGroup[] groups = this.getChangeGroups();
        int index = 0;
        while (index < groups.length) {
            TextEditBasedChangeGroup edit = groups[index];
            if (!edit.isEnabled()) {
                excludes.addAll(Arrays.asList(edit.getTextEditGroup().getTextEdits()));
            }
            ++index;
        }
        LocalTextEditProcessor result = new LocalTextEditProcessor(document, this.getEdit(), flags | 2);
        result.setExcludes(excludes.toArray(new TextEdit[excludes.size()]));
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LocalTextEditProcessor
    extends TextEditProcessor {
        private TextEdit[] fExcludes;
        private TextEdit[] fIncludes;

        protected LocalTextEditProcessor(IDocument document, TextEdit root, int flags) {
            super(document, root, flags);
        }

        public void setExcludes(TextEdit[] excludes) {
            Assert.isNotNull((Object)excludes);
            Assert.isTrue((this.fIncludes == null ? 1 : 0) != 0);
            this.fExcludes = this.flatten(excludes);
        }

        protected boolean considerEdit(TextEdit edit) {
            if (this.fExcludes != null) {
                int i = 0;
                while (i < this.fExcludes.length) {
                    if (edit.equals((Object)this.fExcludes[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            if (this.fIncludes != null) {
                int i = 0;
                while (i < this.fIncludes.length) {
                    if (edit.equals((Object)this.fIncludes[i])) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            return true;
        }

        private TextEdit[] flatten(TextEdit[] edits) {
            ArrayList<TextEdit> result = new ArrayList<TextEdit>(5);
            int i = 0;
            while (i < edits.length) {
                this.flatten(result, edits[i]);
                ++i;
            }
            return result.toArray(new TextEdit[result.size()]);
        }

        private void flatten(List<TextEdit> result, TextEdit edit) {
            result.add(edit);
            TextEdit[] children = edit.getChildren();
            int i = 0;
            while (i < children.length) {
                this.flatten(result, children[i]);
                ++i;
            }
        }
    }

    private static class Lock {
        public boolean fDone;

        private Lock() {
        }
    }
}

