/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.search.epl.internal.filesystem.text;

import com.aptana.ide.search.epl.filesystem.text.FileSystemTextSearchScope;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class FilesOfScopeCalculator {
    private final FileSystemTextSearchScope fScope;
    private ArrayList fFiles;

    public FilesOfScopeCalculator(FileSystemTextSearchScope scope, MultiStatus status) {
        this.fScope = scope;
    }

    public boolean visit(File proxy) {
        File[] listFiles;
        boolean inScope = this.fScope.contains(proxy);
        if (inScope && proxy.isFile() && proxy.canRead()) {
            this.fFiles.add(proxy);
        }
        if (proxy.isDirectory() && (listFiles = proxy.listFiles()) != null) {
            int a = 0;
            while (a < listFiles.length) {
                this.visit(listFiles[a]);
                ++a;
            }
        }
        return inScope;
    }

    public File[] process() {
        this.fFiles = new ArrayList();
        if (this.fScope.isOpenEditors()) {
            try {
                this.fFiles = new ArrayList();
                IWorkbench workbench = SearchPlugin.getDefault().getWorkbench();
                IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
                int i = 0;
                while (i < windows.length) {
                    IWorkbenchPage[] pages = windows[i].getPages();
                    int x = 0;
                    while (x < pages.length) {
                        IEditorReference[] editorRefs = pages[x].getEditorReferences();
                        int z = 0;
                        while (z < editorRefs.length) {
                            IEditorPart ep = editorRefs[z].getEditor(false);
                            if (ep instanceof ITextEditor) {
                                IEditorInput input = ep.getEditorInput();
                                if (input instanceof IPathEditorInput) {
                                    File file = new File(((IPathEditorInput)input).getPath().toOSString());
                                    this.fFiles.add(file);
                                } else if (input instanceof IURIEditorInput) {
                                    URI uri = ((IURIEditorInput)input).getURI();
                                    if ("file".equals(uri.getScheme())) {
                                        this.fFiles.add(new File(uri));
                                    }
                                } else if (input instanceof IFileEditorInput) {
                                    IFileEditorInput fi = (IFileEditorInput)input;
                                    this.fFiles.add(fi.getFile().getLocation().toFile());
                                }
                            }
                            ++z;
                        }
                        ++x;
                    }
                    ++i;
                }
                File[] fileArray = this.fFiles.toArray(new File[this.fFiles.size()]);
                return fileArray;
            }
            finally {
                this.fFiles = null;
            }
        }
        try {
            File[] roots = this.fScope.getRoots();
            int i = 0;
            while (i < roots.length) {
                File resource = roots[i];
                this.visit(resource);
                ++i;
            }
            File[] fileArray = this.fFiles.toArray(new File[this.fFiles.size()]);
            return fileArray;
        }
        finally {
            this.fFiles = null;
        }
    }
}

