/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.json;

import com.aptana.ide.editor.json.Activator;
import com.aptana.ide.editors.unified.AbstractPairFinder;
import com.aptana.ide.editors.unified.PairMatch;
import com.aptana.ide.editors.unified.UnifiedColorManager;
import com.aptana.ide.editors.unified.UnifiedEditor;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.parsing.IParseState;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;

public class JSONPairFinder
extends AbstractPairFinder {
    public PairMatch findPairMatch(int offset, IParseState parseState, Lexeme cursorLexeme, int loopCount) {
        LexemeList lexemes = parseState.getLexemeList();
        PairMatch result = null;
        while (loopCount > 0 && cursorLexeme != null) {
            int index = lexemes.getLexemeIndex(cursorLexeme);
            Lexeme matchingLexeme = null;
            switch (cursorLexeme.typeIndex) {
                case 11: {
                    matchingLexeme = UnifiedEditor.findBalancingLexeme((LexemeList)lexemes, (int)index, (String)"application/json", (int)cursorLexeme.typeIndex, (int)12, (int)1);
                    break;
                }
                case 12: {
                    matchingLexeme = UnifiedEditor.findBalancingLexeme((LexemeList)lexemes, (int)index, (String)"application/json", (int)cursorLexeme.typeIndex, (int)11, (int)-1);
                    break;
                }
                case 9: {
                    matchingLexeme = UnifiedEditor.findBalancingLexeme((LexemeList)lexemes, (int)index, (String)"application/json", (int)cursorLexeme.typeIndex, (int)10, (int)1);
                    break;
                }
                case 10: {
                    matchingLexeme = UnifiedEditor.findBalancingLexeme((LexemeList)lexemes, (int)index, (String)"application/json", (int)cursorLexeme.typeIndex, (int)9, (int)-1);
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    if (cursorLexeme.getCategoryIndex() == 0) break;
                    int start = cursorLexeme.getStartingOffset();
                    int end = cursorLexeme.getEndingOffset();
                    if ((offset - 1 > start || start > offset) && (offset - 1 > end || end > offset)) break;
                    result = new PairMatch();
                    result.beginStart = start;
                    result.beginEnd = result.beginStart + 1;
                    result.endStart = end - 1;
                    result.endEnd = result.endStart + 1;
                    loopCount = 0;
                    break;
                }
            }
            if (matchingLexeme != null) {
                result = new PairMatch();
                result.beginStart = cursorLexeme.getStartingOffset();
                result.beginEnd = cursorLexeme.getEndingOffset();
                result.endStart = matchingLexeme.getStartingOffset();
                result.endEnd = matchingLexeme.getEndingOffset();
                if (result.beginEnd == result.endStart || result.endEnd == result.beginStart) {
                    if (--loopCount > 0 && offset > 0) {
                        cursorLexeme = lexemes.getLexemeFromOffset(offset - 1);
                        continue;
                    }
                    loopCount = 0;
                    continue;
                }
                loopCount = 0;
                continue;
            }
            if (--loopCount > 0 && offset > 0) {
                cursorLexeme = lexemes.getLexemeFromOffset(offset - 1);
                continue;
            }
            loopCount = 0;
        }
        return result;
    }

    public Color getPairFinderColor() {
        return UnifiedColorManager.getInstance().getColor(PreferenceConverter.getColor((IPreferenceStore)Activator.getDefault().getPreferenceStore(), (String)"com.aptana.ide.editors.PAIR_MATCHING_COLOR"));
    }

    private String getDisplayPreference() {
        return Activator.getDefault().getPreferenceStore().getString("com.aptana.ide.editors.SHOW_PAIR_MATCHES");
    }

    public boolean displayOnlyMatch() {
        return this.getDisplayPreference().equals("MATCHING");
    }

    public boolean doNotDisplay() {
        return this.getDisplayPreference().equals("NONE");
    }
}

