/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.json.lexing;

import java.lang.reflect.Field;

public class JSONTokenTypes {
    public static final int ERROR = 0;
    public static final int WHITESPACE = 1;
    public static final int COMMENT = 2;
    public static final int FALSE = 3;
    public static final int TRUE = 4;
    public static final int NUMBER = 5;
    public static final int REFERENCE = 6;
    public static final int STRING = 7;
    public static final int PROPERTY = 8;
    public static final int LBRACKET = 9;
    public static final int RBRACKET = 10;
    public static final int LCURLY = 11;
    public static final int RCURLY = 12;
    public static final int COLON = 13;
    public static final int COMMA = 14;
    public static final int NULL = 15;
    public static final int MAX_VALUE = 15;

    protected JSONTokenTypes() {
    }

    public static String[] getNames() {
        String[] result = new String[16];
        int i = 0;
        while (i <= 15) {
            result[i] = JSONTokenTypes.getName(i);
            ++i;
        }
        return result;
    }

    public static String getName(int type) {
        switch (type) {
            case 0: {
                return "ERROR";
            }
            case 1: {
                return "WHITESPACE";
            }
            case 2: {
                return "COMMENT";
            }
            case 3: {
                return "FALSE";
            }
            case 4: {
                return "TRUE";
            }
            case 5: {
                return "NUMBER";
            }
            case 6: {
                return "REFERENCE";
            }
            case 7: {
                return "STRING";
            }
            case 8: {
                return "PROPERTY";
            }
            case 9: {
                return "LBRACKET";
            }
            case 10: {
                return "RBRACKET";
            }
            case 11: {
                return "LCURLY";
            }
            case 12: {
                return "RCURLY";
            }
            case 13: {
                return "COLON";
            }
            case 14: {
                return "COMMA";
            }
            case 15: {
                return "NULL";
            }
        }
        return "<unknown>";
    }

    public static int getIntValue(String name) {
        Class<JSONTokenTypes> c = JSONTokenTypes.class;
        int result = -1;
        try {
            Field f = c.getField(name);
            result = f.getInt(c);
        }
        catch (Exception exception) {}
        return result;
    }
}

