/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.json.outline;

import com.aptana.ide.editor.json.Activator;
import com.aptana.ide.editor.json.parsing.nodes.JSONParseNode;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.parsing.nodes.IParseNode;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class JSONLabelProvider
extends LabelProvider {
    private static final Image ARRAY_ICON = Activator.getImage("json/icons/array-literal.png");
    private static final Image BOOLEAN_ICON = Activator.getImage("json/icons/boolean.png");
    private static final Image NULL_ICON = Activator.getImage("json/icons/null.png");
    private static final Image NUMBER_ICON = Activator.getImage("json/icons/number.png");
    private static final Image OBJECT_ICON = Activator.getImage("json/icons/object-literal.png");
    private static final Image STRING_ICON = Activator.getImage("json/icons/string.png");

    public Image getImage(Object element) {
        Image result = null;
        if (element instanceof JSONParseNode) {
            IParseNode node = (IParseNode)element;
            block0 : switch (node.getTypeIndex()) {
                case 0: {
                    result = ARRAY_ICON;
                    break;
                }
                case 1: {
                    result = OBJECT_ICON;
                    break;
                }
                case 3: {
                    IParseNode child = node.getChild(1);
                    result = this.getImage(child);
                    break;
                }
                case 2: {
                    Lexeme lexeme = node.getStartingLexeme();
                    switch (lexeme.typeIndex) {
                        case 3: 
                        case 4: {
                            result = BOOLEAN_ICON;
                            break block0;
                        }
                        case 15: {
                            result = NULL_ICON;
                            break block0;
                        }
                        case 5: {
                            result = NUMBER_ICON;
                            break block0;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            result = STRING_ICON;
                        }
                    }
                }
            }
        }
        if (result == null) {
            result = super.getImage(element);
        }
        return result;
    }

    public String getText(Object element) {
        String result = null;
        if (element instanceof JSONParseNode) {
            IParseNode node = (IParseNode)element;
            block0 : switch (node.getTypeIndex()) {
                case 0: {
                    result = "Array";
                    break;
                }
                case 1: {
                    result = "Object";
                    break;
                }
                case 3: {
                    String label = this.trimQuotes(node.getChild(0).getStartingLexeme().getText());
                    IParseNode child = node.getChild(1);
                    int type = child.getTypeIndex();
                    if (type == 0 || type == 1) {
                        result = label;
                        break;
                    }
                    result = String.valueOf(label) + " : " + this.getText(child);
                    break;
                }
                case 2: {
                    Lexeme lexeme = node.getStartingLexeme();
                    String text = lexeme.getText();
                    switch (lexeme.typeIndex) {
                        case 3: 
                        case 4: 
                        case 5: 
                        case 15: {
                            result = text;
                            break block0;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            result = this.trimQuotes(text);
                        }
                    }
                }
            }
        }
        if (result == null) {
            result = super.getText(element);
        }
        return result;
    }

    private String trimQuotes(String text) {
        if (text.startsWith("\"") || text.startsWith("'")) {
            text = text.substring(1);
        }
        if (text.endsWith("\"") || text.endsWith("'")) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }
}

