/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.json.parsing;

import com.aptana.ide.editor.json.parsing.JSONParseState;
import com.aptana.ide.editor.json.parsing.Messages;
import com.aptana.ide.editor.json.parsing.nodes.JSONParseNode;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.folding.FoldingExtensionPointLoader;
import com.aptana.ide.editors.unified.parsing.UnifiedParser;
import com.aptana.ide.lexer.ILexer;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.ParserInitializationException;
import com.aptana.ide.parsing.nodes.IParseNode;
import com.aptana.ide.parsing.nodes.IParseNodeFactory;
import java.text.ParseException;
import org.eclipse.jface.preference.IPreferenceStore;

public class JSONParser
extends UnifiedParser {
    public JSONParser() throws ParserInitializationException {
        this("application/json");
    }

    public JSONParser(String mimeType) throws ParserInitializationException {
        super(mimeType);
        IPreferenceStore unifiedStore = UnifiedEditorsPlugin.getDefault().getPreferenceStore();
        unifiedStore.setDefault(FoldingExtensionPointLoader.createEnablePreferenceId((String)"application/json"), true);
    }

    protected void advance() throws LexerException {
        super.advance();
        while (!this.isEOS() && this.currentLexeme.getCategoryIndex() == 1) {
            super.advance();
        }
    }

    private JSONParseNode createNode(int type, Lexeme startingLexeme) {
        IParseNodeFactory factory = this.getParseNodeFactory();
        JSONParseNode result = null;
        result = factory != null ? (JSONParseNode)factory.createParseNode(type, startingLexeme) : new JSONParseNode(type, startingLexeme);
        return result;
    }

    public IParseState createParseState(IParseState parent) {
        JSONParseState result = parent == null ? new JSONParseState() : new JSONParseState(parent);
        return result;
    }

    public void initializeLexer() throws LexerException {
        ILexer lexer = this.getLexer();
        String language = this.getLanguage();
        lexer.setIgnoreSet(language, new int[]{1});
        lexer.setLanguageAndGroup(language, "default");
    }

    public void parseAll(IParseNode parentNode) throws ParseException, LexerException {
        IParseNode rootNode;
        if (parentNode == null) {
            IParseNodeFactory nodeFactory = this.getParseNodeFactory();
            if (nodeFactory != null) {
                rootNode = nodeFactory.createRootNode();
                if (parentNode != null) {
                    parentNode.appendChild(rootNode);
                }
            } else {
                rootNode = null;
            }
        } else {
            rootNode = parentNode;
        }
        ILexer lexer = this.getLexer();
        lexer.setLanguageAndGroup(this.getLanguage(), "default");
        this.advance();
        while (!this.isEOS()) {
            IParseNode result = this.parseStatement();
            if (rootNode == null || result == null) continue;
            rootNode.appendChild(result);
        }
    }

    private IParseNode parseStatement() throws LexerException {
        Object result = null;
        switch (this.currentLexeme.typeIndex) {
            case 9: {
                result = this.parseArray();
                break;
            }
            case 11: {
                result = this.parseObject();
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 15: {
                result = this.createNode(2, this.currentLexeme);
                this.advance();
                break;
            }
            default: {
                this.advance();
            }
        }
        return result;
    }

    private IParseNode parseArray() throws LexerException {
        JSONParseNode result = this.createNode(0, this.currentLexeme);
        this.advance();
        while (!this.isEOS() && this.currentLexeme.typeIndex != 10) {
            IParseNode child = this.parseStatement();
            if (child != null) {
                result.appendChild(child);
            } else {
                this.recover(10);
            }
            if (this.currentLexeme.typeIndex != 14) continue;
            this.advance();
        }
        if (this.currentLexeme.typeIndex == 10) {
            result.setEndingLexeme(this.currentLexeme);
            this.advance();
        }
        return result;
    }

    private IParseNode parseObject() throws LexerException {
        JSONParseNode result = this.createNode(1, this.currentLexeme);
        this.advance();
        while (!this.isEOS() && this.currentLexeme.typeIndex != 12) {
            IParseNode child = null;
            try {
                child = this.parseNameValuePair();
            }
            catch (ParseException parseException) {}
            if (child != null) {
                result.appendChild(child);
            } else {
                this.recover(12);
            }
            if (this.currentLexeme.typeIndex != 14) continue;
            this.advance();
        }
        if (this.currentLexeme.typeIndex == 12) {
            result.setEndingLexeme(this.currentLexeme);
            this.advance();
        }
        return result;
    }

    private IParseNode parseNameValuePair() throws LexerException, ParseException {
        JSONParseNode result = this.createNode(3, this.currentLexeme);
        switch (this.currentLexeme.typeIndex) {
            case 7: 
            case 8: {
                JSONParseNode name = this.createNode(2, this.currentLexeme);
                result.appendChild((IParseNode)name);
                this.advance();
                this.assertAndAdvance(13, Messages.getString("JSONParser.Missing_Colon"));
                IParseNode value = this.parseStatement();
                if (value != null) {
                    result.appendChild(value);
                    break;
                }
                result = null;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    private void recover(int closeType) throws LexerException {
        Lexeme startLexeme = this.currentLexeme;
        while (!this.isEOS()) {
            int typeIndex = this.currentLexeme.typeIndex;
            if (typeIndex == closeType) break;
            if (typeIndex == 9 || typeIndex == 11 || typeIndex == 14) {
                if (this.currentLexeme != startLexeme) break;
                this.advance();
                continue;
            }
            this.advance();
        }
    }
}

