/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.json.parsing.nodes;

import com.aptana.ide.io.SourceWriter;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.parsing.nodes.ParseNodeBase;

public class JSONParseNode
extends ParseNodeBase {
    public JSONParseNode(int typeIndex, Lexeme startLexeme) {
        super(typeIndex, "application/json", startLexeme);
    }

    public String getName() {
        String result = null;
        switch (this.getTypeIndex()) {
            case 0: {
                result = "ARRAY";
                break;
            }
            case 1: {
                result = "OBJECT";
                break;
            }
            case 2: {
                result = "SCALAR";
                break;
            }
            case 3: {
                result = "NAME_VALUE_PAIR";
            }
        }
        if (result == null) {
            result = super.getName();
        }
        return result;
    }

    public void getSource(SourceWriter writer) {
        writer.printIndent();
        switch (this.getTypeIndex()) {
            case 0: {
                writer.println("[").increaseIndent();
                if (this.getChildCount() > 0) {
                    this.getChild(0).getSource(writer);
                    int i = 1;
                    while (i < this.getChildCount()) {
                        writer.println(",");
                        this.getChild(i).getSource(writer);
                        ++i;
                    }
                }
                writer.decreaseIndent().println();
                writer.printWithIndent("]");
                break;
            }
            case 1: {
                writer.println("{").increaseIndent();
                if (this.getChildCount() > 0) {
                    this.getChild(0).getSource(writer);
                    int i = 1;
                    while (i < this.getChildCount()) {
                        writer.println(",");
                        this.getChild(i).getSource(writer);
                        ++i;
                    }
                }
                writer.decreaseIndent().println();
                writer.printWithIndent("}");
                break;
            }
            case 2: {
                writer.print(this.getText());
                break;
            }
            case 3: {
                writer.print(this.getChild(0).getText());
                writer.print(" : ");
                writer.print(this.getChild(1).getText());
            }
        }
    }

    public String getText() {
        String result = null;
        switch (this.getTypeIndex()) {
            case 2: {
                result = this.getStartingLexeme().getText();
                break;
            }
            default: {
                result = super.getText();
            }
        }
        return result;
    }
}

