/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui;

import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.io.events.ConnectionPointEvent;
import com.aptana.ide.core.io.events.IConnectionPointListener;
import com.aptana.ide.syncing.core.ISiteConnection;
import com.aptana.ide.syncing.core.SiteConnection;
import com.aptana.ide.syncing.core.SyncingPlugin;
import com.aptana.ide.syncing.core.events.ISiteConnectionListener;
import com.aptana.ide.syncing.core.events.SiteConnectionEvent;
import com.aptana.ide.syncing.ui.editors.EditorUtils;
import com.aptana.ide.syncing.ui.navigator.ProjectSitesManager;
import com.aptana.ide.syncing.ui.navigator.SiteConnections;
import com.aptana.ide.ui.io.IOUIPlugin;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class SyncingUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.aptana.ide.syncing.ui";
    private static SyncingUIPlugin plugin;
    private static Map<String, Image> images;
    private ISiteConnectionListener connectionListener = new ISiteConnectionListener(){

        public void siteConnectionChanged(SiteConnectionEvent event) {
            ISiteConnection siteConnection = event.getSiteConnection();
            switch (event.getKind()) {
                case 1: {
                    break;
                }
                case 2: {
                    EditorUtils.closeConnectionEditor(siteConnection);
                }
            }
            IOUIPlugin.refreshNavigatorView((Object)((Object)SiteConnections.getInstance()));
            SyncingUIPlugin.refreshProjectSiteConnection(siteConnection);
        }
    };
    private IConnectionPointListener connectionPointListener = new IConnectionPointListener(){

        public void connectionPointChanged(ConnectionPointEvent event) {
            IConnectionPoint connectionPoint = event.getConnectionPoint();
            switch (event.getKind()) {
                case 2: {
                    ISiteConnection[] siteConnections;
                    boolean affected = false;
                    ISiteConnection[] iSiteConnectionArray = siteConnections = SyncingPlugin.getSiteConnectionManager().getSiteConnections();
                    int n = siteConnections.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ISiteConnection siteConnection = iSiteConnectionArray[n2];
                        if (siteConnection.getSource() == connectionPoint) {
                            ((SiteConnection)siteConnection).setSource(null);
                            affected = true;
                        }
                        if (siteConnection.getDestination() == connectionPoint) {
                            ((SiteConnection)siteConnection).setDestination(null);
                            affected = true;
                            SyncingUIPlugin.refreshProjectSiteConnection(siteConnection);
                        }
                        ++n2;
                    }
                    if (!affected) break;
                    IOUIPlugin.refreshNavigatorView((Object)((Object)SiteConnections.getInstance()));
                }
            }
        }
    };

    static {
        images = new HashMap<String, Image>();
    }

    private static void refreshProjectSiteConnection(ISiteConnection siteConnection) {
        IContainer container;
        IConnectionPoint source = siteConnection.getSource();
        if (source != null && (container = (IContainer)source.getAdapter(IContainer.class)) != null) {
            IOUIPlugin.refreshNavigatorView((Object)((Object)ProjectSitesManager.getInstance().getProjectSites(container.getProject())));
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        SyncingPlugin.getSiteConnectionManager().addListener(this.connectionListener);
        CoreIOPlugin.getConnectionPointManager().addConnectionPointListener(this.connectionPointListener);
    }

    public void stop(BundleContext context) throws Exception {
        SyncingPlugin.getSiteConnectionManager().removeListener(this.connectionListener);
        CoreIOPlugin.getConnectionPointManager().removeConnectionPointListener(this.connectionPointListener);
        plugin = null;
        super.stop(context);
    }

    public static SyncingUIPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static Image getImage(String path) {
        if (images.get(path) == null) {
            ImageDescriptor id = SyncingUIPlugin.getImageDescriptor(path);
            if (id == null) {
                return null;
            }
            Image i = id.createImage();
            images.put(path, i);
            return i;
        }
        return images.get(path);
    }

    public static void log(String msg, Throwable e) {
        SyncingUIPlugin.log((IStatus)new Status(1, PLUGIN_ID, 0, msg, e));
    }

    private static void log(IStatus status) {
        SyncingUIPlugin.getDefault().getLog().log(status);
    }
}

