/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.actions;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.ui.DialogUtils;
import com.aptana.ide.syncing.core.ISiteConnection;
import com.aptana.ide.syncing.ui.SyncingUIPlugin;
import com.aptana.ide.syncing.ui.actions.BaseSyncAction;
import com.aptana.ide.syncing.ui.actions.Messages;
import com.aptana.ide.syncing.ui.internal.SyncUtils;
import com.aptana.ide.ui.io.actions.CopyFilesOperation;
import java.text.MessageFormat;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;

public class DownloadAction
extends BaseSyncAction {
    private static String MESSAGE_TITLE = StringUtils.ellipsify((String)Messages.DownloadAction_MessageTitle);

    protected void performAction(final IAdaptable[] files, final ISiteConnection site) throws CoreException {
        Job job = new Job(MESSAGE_TITLE){

            protected IStatus run(IProgressMonitor monitor) {
                IFileStore targetRoot;
                IFileStore sourceRoot;
                IConnectionPoint source = site.getSource();
                IConnectionPoint target = site.getDestination();
                try {
                    sourceRoot = source.getRoot();
                    if (!target.isConnected()) {
                        target.connect(monitor);
                    }
                    targetRoot = target.getRoot();
                }
                catch (CoreException e) {
                    return new Status(4, "com.aptana.ide.syncing.ui", e.getLocalizedMessage(), (Throwable)e);
                }
                IFileStore[] fileStores = new IFileStore[files.length];
                int i = 0;
                while (i < fileStores.length) {
                    IFileStore fileStore = SyncUtils.getFileStore(files[i]);
                    String sourceRootPath = sourceRoot.toString();
                    String sourcePath = fileStore.toString();
                    int index = sourcePath.indexOf(sourceRootPath);
                    if (index > -1) {
                        sourcePath = sourcePath.substring(index + sourceRootPath.length());
                        fileStore = targetRoot.getFileStore((IPath)new Path(sourcePath));
                    }
                    fileStores[i] = fileStore;
                    ++i;
                }
                CopyFilesOperation operation = new CopyFilesOperation(DownloadAction.this.getShell());
                IStatus status = operation.copyFiles(fileStores, targetRoot, sourceRoot, monitor);
                if (status != Status.CANCEL_STATUS) {
                    DownloadAction.this.postAction(status);
                }
                IAdaptable[] iAdaptableArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    IAdaptable file = iAdaptableArray[n2];
                    if (file instanceof IResource) {
                        try {
                            ((IResource)file).refreshLocal(2, monitor);
                        }
                        catch (CoreException coreException) {}
                    }
                    ++n2;
                }
                return status;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    protected String getMessageTitle() {
        return MESSAGE_TITLE;
    }

    private void postAction(final IStatus status) {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                DialogUtils.openIgnoreMessageDialogInformation((Shell)DownloadAction.this.getShell(), (String)MESSAGE_TITLE, (String)MessageFormat.format(Messages.DownloadAction_PostMessage, status.getCode()), (IPreferenceStore)SyncingUIPlugin.getDefault().getPreferenceStore(), (String)"IGNORE_DIALOG_FILE_DOWNLOAD");
            }
        });
    }
}

