/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.actions;

import com.aptana.ide.core.io.preferences.CloakingUtils;
import com.aptana.ide.syncing.ui.decorators.DecoratorUtils;
import com.aptana.ide.syncing.ui.internal.SyncUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class UncloakAction
implements IObjectActionDelegate {
    private List<IFileStore> fSelectedFiles = new ArrayList<IFileStore>();

    public void run(IAction action) {
        for (IFileStore fileStore : this.fSelectedFiles) {
            String expression = UncloakAction.getFileType(fileStore);
            CloakingUtils.removeCloakFileType((String)expression);
        }
        DecoratorUtils.updateCloakDecorator();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object[] elements;
        action.setEnabled(false);
        this.fSelectedFiles.clear();
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return;
        }
        Object[] objectArray = elements = ((IStructuredSelection)selection).toArray();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IFileStore fileStore;
            Object element = objectArray[n2];
            if (element instanceof IAdaptable && (fileStore = SyncUtils.getFileStore((IAdaptable)element)) != null && CloakingUtils.isFileCloaked((IFileStore)fileStore)) {
                this.fSelectedFiles.add(fileStore);
            }
            ++n2;
        }
        action.setEnabled(this.fSelectedFiles.size() > 0);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    private static String getFileType(IFileStore fileStore) {
        String name = fileStore.getName();
        int index = name.lastIndexOf(".");
        if (index < 0) {
            return name;
        }
        return "*." + name.substring(index + 1);
    }
}

