/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.decorators;

import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.syncing.core.ISiteConnection;
import com.aptana.ide.syncing.core.ResourceSynchronizationUtils;
import com.aptana.ide.syncing.core.SiteConnectionUtils;
import com.aptana.ide.syncing.ui.SyncingUIPlugin;
import com.aptana.ide.ui.io.navigator.INavigatorDecorator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class SiteConnectionDecorator
implements INavigatorDecorator {
    private static final Image DECORATOR = SyncingUIPlugin.getImage("icons/full/obj16/sync_connection.gif");
    private static final int PADDING = CoreUIUtils.onMacOSX ? 5 : 2;

    public void addDecorator(final Tree tree) {
        if (SiteConnectionDecorator.isDisposed(tree)) {
            return;
        }
        tree.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                int startWidth = event.width;
                try {
                    String lastConnection;
                    Object data;
                    if (!SiteConnectionDecorator.isDisposed(tree) && event.item instanceof TreeItem && (data = ((TreeItem)event.item).getData()) instanceof IContainer && (lastConnection = SiteConnectionDecorator.getLastSyncConnection((IContainer)data)) != null) {
                        Point stringExtent = event.gc.stringExtent(lastConnection);
                        event.width += DECORATOR.getBounds().width + PADDING + stringExtent.x + PADDING;
                    }
                }
                catch (Exception exception) {
                    event.width = startWidth;
                }
                catch (Error error) {
                    event.width = startWidth;
                }
            }
        });
        tree.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                try {
                    String lastConnection;
                    Object data;
                    if (!SiteConnectionDecorator.isDisposed(tree) && event.item instanceof TreeItem && (data = ((TreeItem)event.item).getData()) instanceof IContainer && (lastConnection = SiteConnectionDecorator.getLastSyncConnection((IContainer)data)) != null) {
                        int x = event.x + event.width + PADDING;
                        int itemHeight = tree.getItemHeight();
                        int imageHeight = DECORATOR.getBounds().height;
                        int y = event.y + (itemHeight - imageHeight) / 2;
                        event.gc.drawImage(DECORATOR, x, y);
                        event.x = x + DECORATOR.getBounds().width;
                        x = event.x + PADDING;
                        Point stringExtent = event.gc.stringExtent(lastConnection);
                        y = event.y + (itemHeight - stringExtent.y) / 2;
                        event.gc.drawString(lastConnection, x, y, true);
                        event.x += stringExtent.x;
                    }
                }
                catch (Exception exception) {
                }
                catch (Error error) {}
            }
        });
    }

    private static String getLastSyncConnection(IContainer container) {
        ISiteConnection[] sites;
        if (container == null) {
            return null;
        }
        boolean remember = ResourceSynchronizationUtils.isRememberDecision((IContainer)container);
        if (!remember) {
            return null;
        }
        String lastConnection = ResourceSynchronizationUtils.getLastSyncConnection((IContainer)container);
        if (lastConnection == null) {
            return null;
        }
        ISiteConnection[] iSiteConnectionArray = sites = SiteConnectionUtils.findSitesForSource((IAdaptable)container, (boolean)true);
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteConnection site = iSiteConnectionArray[n2];
            String target = site.getDestination().getName();
            if (target.equals(lastConnection)) {
                return target;
            }
            ++n2;
        }
        return null;
    }

    private static boolean isDisposed(Tree tree) {
        return tree == null || tree.isDisposed();
    }
}

