/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.navigator;

import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.syncing.core.ISiteConnection;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;

public final class ProjectSiteConnection
extends PlatformObject {
    private final IProject project;
    private final ISiteConnection siteConnection;
    private int hashCode;

    public ProjectSiteConnection(IProject project, ISiteConnection siteConnection) {
        this.project = project;
        this.siteConnection = siteConnection;
    }

    public IProject getProject() {
        return this.project;
    }

    public ISiteConnection getSiteConnection() {
        return this.siteConnection;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IProject.class) {
            return this.project;
        }
        if (adapter == ISiteConnection.class) {
            return this.siteConnection;
        }
        if (adapter == IConnectionPoint.class) {
            return this.siteConnection.getDestination();
        }
        if (adapter == IFileStore.class) {
            IConnectionPoint destination = this.siteConnection.getDestination();
            try {
                return destination == null ? null : destination.getRoot();
            }
            catch (CoreException coreException) {}
        }
        return super.getAdapter(adapter);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 7;
            this.hashCode = 31 * this.hashCode + this.project.hashCode();
            this.hashCode = 31 * this.hashCode + this.siteConnection.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ProjectSiteConnection)) {
            return false;
        }
        ProjectSiteConnection connection = (ProjectSiteConnection)((Object)o);
        return this.project == connection.project && this.siteConnection == connection.siteConnection;
    }

    public String toString() {
        return this.getSiteConnection().toString();
    }
}

