/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.navigator.actions;

import com.aptana.ide.syncing.core.ISiteConnection;
import com.aptana.ide.syncing.ui.dialogs.SiteConnectionsEditorDialog;
import com.aptana.ide.syncing.ui.editors.EditorUtils;
import com.aptana.ide.syncing.ui.navigator.ProjectSiteConnection;
import com.aptana.ide.syncing.ui.navigator.actions.Messages;
import com.aptana.ide.ui.io.navigator.actions.BaseDoubleClickAction;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;

public class DoubleClickAction
extends BaseDoubleClickAction {
    private Shell fShell;
    private TreeViewer fTreeViewer;

    public DoubleClickAction(Shell shell, TreeViewer treeViewer) {
        super(treeViewer);
        this.fShell = shell;
        this.fTreeViewer = treeViewer;
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof ISiteConnection) {
            EditorUtils.openConnectionEditor((ISiteConnection)element);
        } else if (element instanceof ProjectSiteConnection) {
            super.run();
            EditorUtils.openConnectionEditor(((ProjectSiteConnection)((Object)element)).getSiteConnection());
        } else if (this.selectionHasChildren()) {
            super.run();
        } else {
            IAdaptable source = null;
            if (element instanceof IAdaptable) {
                source = (IAdaptable)element;
            }
            this.openNewSiteConnectionDialog(source);
        }
    }

    private void openNewSiteConnectionDialog(IAdaptable source) {
        SiteConnectionsEditorDialog dlg = new SiteConnectionsEditorDialog(this.fShell);
        dlg.setCreateNew(Messages.DoubleClickAction_NewConnection, source, null);
        dlg.open();
    }
}

