/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.views;

import com.aptana.ide.core.io.efs.EFSUtils;
import com.aptana.ide.core.io.syncing.VirtualFileSyncPair;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.editors.FileCompareEditorInput;
import com.aptana.ide.syncing.ui.SyncingUIPlugin;
import com.aptana.ide.syncing.ui.views.ISyncResource;
import com.aptana.ide.syncing.ui.views.Messages;
import com.aptana.ide.syncing.ui.views.SmartSyncContentProvider;
import com.aptana.ide.syncing.ui.views.SmartSyncLabelProvider;
import com.aptana.ide.syncing.ui.views.SyncFile;
import com.aptana.ide.syncing.ui.views.SyncFolder;
import java.io.File;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class SmartSyncViewer {
    private TreeViewer fViewer;
    private SmartSyncContentProvider fContentProvider;
    private SmartSyncLabelProvider fLabelProvider;
    private MenuItem fShowDiffs;
    private TreeColumn fColumnEnd1;
    private TreeColumn fColumnEnd2;
    private TreeColumn fLocalTimeColumn;
    private TreeColumn fRemoteTimeColumn;
    private Color fInitBackground;
    private Color fProgressBackground;
    private SyncFolder fRoot;

    public SmartSyncViewer(Composite parent, String endpoint1, String endpoint2) {
        this.fViewer = this.createContents(parent);
        this.setEndpoints(endpoint1, endpoint2);
    }

    public Tree getTree() {
        return this.fViewer.getTree();
    }

    public ISyncResource[] getCurrentResources() {
        return this.fContentProvider.getCurrentResources();
    }

    public void setInput(SyncFolder root) {
        this.fRoot = root;
        this.fViewer.setInput((Object)root);
    }

    public void setCellModifier(ICellModifier modifier) {
        this.fViewer.setCellModifier(modifier);
    }

    public void setEndpoints(String end1, String end2) {
        this.fColumnEnd1.setText(end1);
        this.fColumnEnd1.setToolTipText(end1);
        this.fColumnEnd2.setText(end2);
        this.fColumnEnd2.setToolTipText(end2);
    }

    public void setSyncDirection(int direction) {
        this.fContentProvider.setSyncDirection(direction);
        this.fLabelProvider.setSyncDirection(direction);
    }

    public void setPresentationType(int type) {
        this.fContentProvider.setPresentationType(type);
        this.fLabelProvider.setPresentationType(type);
        this.refreshAndExpandTo(2);
    }

    public void setDeleteRemoteFiles(boolean delete) {
        this.fContentProvider.setDeleteRemoteFiles(delete);
        this.fLabelProvider.setDeleteRemoteFiles(delete);
        this.refresh();
    }

    public void setDeleteLocalFiles(boolean delete) {
        this.fContentProvider.setDeleteLocalFiles(delete);
        this.fLabelProvider.setDeleteLocalFiles(delete);
        this.refresh();
    }

    public void setShowDatesSelected(boolean show) {
        if (show) {
            this.fLocalTimeColumn = new TreeColumn(this.getTree(), 16384);
            this.fLocalTimeColumn.setText(Messages.SmartSyncDialog_LocalTime);
            this.fLocalTimeColumn.setToolTipText(Messages.SmartSyncViewer_LocalTimeTooltip);
            this.fLocalTimeColumn.setWidth(150);
            this.fRemoteTimeColumn = new TreeColumn(this.getTree(), 16384);
            this.fRemoteTimeColumn.setText(Messages.SmartSyncDialog_RemoteTime);
            this.fRemoteTimeColumn.setToolTipText(Messages.SmartSyncViewer_RemoteTimeTooltip);
            this.fRemoteTimeColumn.setWidth(150);
        } else if (this.fLocalTimeColumn != null && !this.fLocalTimeColumn.isDisposed()) {
            this.fLocalTimeColumn.dispose();
            this.fRemoteTimeColumn.dispose();
        }
        this.refresh();
    }

    public void setVisible(boolean visible) {
        this.getTree().setVisible(visible);
        if (visible) {
            this.setWidth(this.getTree().getParent().getSize().x);
        }
    }

    public void showProgress(VirtualFileSyncPair item) {
        final ISyncResource resource = this.fRoot.find(item);
        if (resource == null || resource.getSyncState() == 9 || resource.getSyncState() == 10) {
            return;
        }
        final TreeItem treeItem = (TreeItem)this.fViewer.testFindItem((Object)resource);
        if (treeItem == null) {
            return;
        }
        this.getTree().addListener(40, new Listener(){

            public void handleEvent(Event event) {
                if (event.item == treeItem && event.index == 0) {
                    int width;
                    int state = resource.getTransferState();
                    if (state != 2) {
                        return;
                    }
                    Rectangle bounds = treeItem.getImageBounds(0);
                    int height = width = Math.min(bounds.width, bounds.height);
                    GC gc = event.gc;
                    gc.setBackground(treeItem.getDisplay().getSystemColor(1));
                    gc.fillRectangle(bounds.x, bounds.y, bounds.width, bounds.height);
                    gc.setBackground(SmartSyncViewer.this.fInitBackground);
                    gc.drawOval(bounds.x + 1, bounds.y + 1, width - 4, height - 4);
                    double ratio = Math.min(1.0, (double)resource.getTransferredBytes() / (double)SmartSyncViewer.getTransferSize(resource));
                    gc.setBackground(SmartSyncViewer.this.fProgressBackground);
                    gc.fillArc(bounds.x + 1, bounds.y + 1, width - 3, height - 3, 90, (int)(-ratio * 360.0));
                }
            }
        });
        CoreUIUtils.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (SmartSyncViewer.this.getTree().isDisposed()) {
                    return;
                }
                Rectangle bounds = treeItem.getBounds(0);
                SmartSyncViewer.this.getTree().redraw(bounds.x, bounds.y, bounds.width, bounds.height, true);
            }
        });
    }

    public void refresh() {
        this.fViewer.refresh();
    }

    public void refreshAndExpandTo(int level) {
        this.refresh();
        this.fViewer.expandToLevel(level);
        this.setWidth(this.getTree().getParent().getSize().x);
    }

    public void addFilter(ViewerFilter filter) {
        this.fViewer.addFilter(filter);
    }

    public void reveal(Object elementOrTreePath) {
        this.fViewer.reveal(elementOrTreePath);
    }

    public void update(Object element, String[] properties) {
        this.fViewer.update(element, properties);
    }

    private TreeViewer createContents(final Composite parent) {
        final TreeViewer viewer = new TreeViewer(parent, 67588);
        this.fContentProvider = new SmartSyncContentProvider();
        viewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fLabelProvider = new SmartSyncLabelProvider(parent.getDisplay());
        viewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        Tree tree = viewer.getTree();
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        viewer.setAutoExpandLevel(2);
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fInitBackground = new Color((Device)tree.getDisplay(), 175, 238, 238);
        this.fProgressBackground = new Color((Device)tree.getDisplay(), 72, 209, 204);
        tree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SmartSyncViewer.this.fInitBackground.dispose();
                SmartSyncViewer.this.fProgressBackground.dispose();
            }
        });
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                SmartSyncViewer.this.setWidth(parent.getSize().x);
            }
        });
        TreeColumn file = new TreeColumn(tree, 16384);
        file.setWidth(250);
        file.setText(Messages.SmartSyncDialog_ColumnResources);
        file.setToolTipText(Messages.SmartSyncViewer_ColumnResourcesTooltip);
        TreeColumn skip = new TreeColumn(tree, 0x1000000);
        skip.setWidth(40);
        skip.setText(Messages.SmartSyncDialog_ColumnSkip);
        skip.setToolTipText(Messages.SmartSyncViewer_ColumnSkipTooltip);
        this.fColumnEnd1 = new TreeColumn(tree, 0x1000000);
        this.fColumnEnd1.setWidth(125);
        this.fColumnEnd2 = new TreeColumn(tree, 0x1000000);
        this.fColumnEnd2.setWidth(125);
        Menu menu = new Menu((Control)tree);
        this.fShowDiffs = new MenuItem(menu, 8);
        this.fShowDiffs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SyncFile file;
                Object selection;
                if (!viewer.getSelection().isEmpty() && viewer.getSelection() instanceof IStructuredSelection && (selection = ((IStructuredSelection)viewer.getSelection()).getFirstElement()) instanceof SyncFile && ((file = (SyncFile)selection).getSyncState() == 4 || file.getSyncState() == 5)) {
                    final VirtualFileSyncPair pair = file.getPair();
                    File local = new File(EFSUtils.getAbsolutePath((IFileStore)pair.getSourceFile()));
                    FileCompareEditorInput input = new FileCompareEditorInput(new CompareConfiguration()){

                        protected void prepareFiles() {
                            pair.getDestinationFile();
                            File temp = null;
                            try {
                                temp = pair.getDestinationFile().toLocalFile(4096, null);
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                            this.setRightResource(temp);
                        }
                    };
                    input.setLeftResource(local);
                    CompareUI.openCompareDialog((CompareEditorInput)input);
                }
            }
        });
        this.fShowDiffs.setImage(SyncingUIPlugin.getImage("icons/full/obj16/compare_view.gif"));
        this.fShowDiffs.setText(Messages.SmartSyncDialog_ShowDiffs);
        this.fShowDiffs.setEnabled(true);
        tree.setMenu(menu);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SyncFile file;
                Object selection;
                if (!viewer.getSelection().isEmpty() && viewer.getSelection() instanceof IStructuredSelection && (selection = ((IStructuredSelection)viewer.getSelection()).getFirstElement()) instanceof SyncFile && ((file = (SyncFile)selection).getSyncState() == 4 || file.getSyncState() == 5)) {
                    SmartSyncViewer.this.fShowDiffs.setEnabled(true);
                    return;
                }
                SmartSyncViewer.this.fShowDiffs.setEnabled(false);
            }
        });
        CellEditor[] cellEditorArray = new CellEditor[4];
        cellEditorArray[1] = new CheckboxCellEditor();
        viewer.setCellEditors(cellEditorArray);
        viewer.setColumnProperties(new String[]{Messages.SmartSyncDialog_ColumnName, Messages.SmartSyncDialog_ColumnSkip, Messages.SmartSyncDialog_ColumnLocal, Messages.SmartSyncDialog_ColumnRemote});
        return viewer;
    }

    private void setWidth(int totalWidth) {
        Tree tree = this.getTree();
        TreeColumn[] columns = tree.getColumns();
        int width = 0;
        int i = columns.length - 1;
        while (i > 0) {
            width += columns[i].getWidth();
            --i;
        }
        ScrollBar verticalBar = tree.getVerticalBar();
        if (verticalBar.isVisible()) {
            width += verticalBar.getSize().x;
        }
        columns[0].setWidth(totalWidth - width - (verticalBar.getSize().x + 1));
    }

    private static long getTransferSize(ISyncResource resource) {
        if (resource.getPair() == null) {
            return 0L;
        }
        IFileStore file = null;
        int state = resource.getSyncState();
        if (state == 4 || state == 6) {
            file = resource.getPair().getSourceFile();
        } else if (state == 5 || state == 7) {
            file = resource.getPair().getDestinationFile();
        }
        if (file == null) {
            return 0L;
        }
        return file.fetchInfo().getLength();
    }
}

