/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.views;

import com.aptana.ide.core.io.syncing.VirtualFileSyncPair;
import com.aptana.ide.syncing.ui.views.ISyncResource;
import com.aptana.ide.syncing.ui.views.SyncFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncFolder
implements ISyncResource {
    public static final int MIXED = -2;
    private Set<ISyncResource> children = new TreeSet<ISyncResource>(new Comparator<ISyncResource>(){

        @Override
        public int compare(ISyncResource o1, ISyncResource o2) {
            return o1.getPath().lastSegment().compareTo(o2.getPath().lastSegment());
        }
    });
    private SyncFolder parent;
    private VirtualFileSyncPair pair;
    private IPath path;
    private boolean skipped = false;
    private int syncState = -1;
    private int transferState = -1;
    private long transferredBytes;

    public SyncFolder(IPath path, SyncFolder parent, VirtualFileSyncPair pair) {
        this.parent = parent;
        this.path = path;
        this.pair = pair;
    }

    public ISyncResource find(VirtualFileSyncPair pair) {
        if (this.pair == pair) {
            return this;
        }
        for (ISyncResource resource : this.children) {
            if (resource instanceof SyncFolder) {
                ISyncResource pairResource = ((SyncFolder)resource).find(pair);
                if (pairResource == null) continue;
                return pairResource;
            }
            if (!(resource instanceof SyncFile) || pair != ((SyncFile)resource).getPair()) continue;
            return resource;
        }
        return null;
    }

    public int updateCount() {
        int number = 0;
        ISyncResource[] iSyncResourceArray = this.getNonEmptyMembers();
        int n = iSyncResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISyncResource resource = iSyncResourceArray[n2];
            if (resource instanceof SyncFile) {
                ++number;
            } else if (resource instanceof SyncFolder) {
                number += ((SyncFolder)resource).updateCount();
            }
            ++n2;
        }
        return number;
    }

    public List<VirtualFileSyncPair> getPairs() {
        ISyncResource[] members;
        ArrayList<VirtualFileSyncPair> pairs = new ArrayList<VirtualFileSyncPair>();
        ISyncResource[] iSyncResourceArray = members = this.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            ISyncResource member = iSyncResourceArray[n2];
            if (!member.isSkipped()) {
                if (member instanceof SyncFile) {
                    pairs.add(((SyncFile)member).getPair());
                } else if (member instanceof SyncFolder) {
                    SyncFolder folder = (SyncFolder)member;
                    if (folder.getPair() != null) {
                        pairs.add(folder.getPair());
                    }
                    pairs.addAll(folder.getPairs());
                }
            }
            ++n2;
        }
        return pairs;
    }

    @Override
    public String getName() {
        return this.path.lastSegment();
    }

    public void addMember(ISyncResource child) {
        this.children.add(child);
        if (child instanceof SyncFile) {
            int newState = ((SyncFile)child).getPair().getSyncState();
            this.syncState = this.syncState == -1 || this.syncState == newState ? newState : -2;
        }
    }

    public List<ISyncResource> getCompressedMembers() {
        ISyncResource[] members;
        ArrayList<ISyncResource> compressed = new ArrayList<ISyncResource>();
        ISyncResource[] iSyncResourceArray = members = this.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            ISyncResource member = iSyncResourceArray[n2];
            if (member instanceof SyncFolder) {
                SyncFolder folder = (SyncFolder)member;
                if (folder.containsFiles()) {
                    compressed.add(folder);
                } else {
                    compressed.addAll(folder.getCompressedMembers());
                }
            } else {
                compressed.add(member);
            }
            ++n2;
        }
        return compressed;
    }

    public void removeMember(ISyncResource child) {
        this.children.remove(child);
    }

    public void clearMembers() {
        this.children.clear();
    }

    public boolean containsFiles() {
        for (ISyncResource resource : this.children) {
            if (!(resource instanceof SyncFile)) continue;
            return true;
        }
        return false;
    }

    public ISyncResource getMember(String name) {
        for (ISyncResource resource : this.children) {
            if (!name.equals(resource.getName())) continue;
            return resource;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    public List<ISyncResource> getAllFiles() {
        ArrayList<ISyncResource> files = new ArrayList<ISyncResource>();
        for (ISyncResource resource : this.children) {
            if (resource instanceof SyncFile) {
                files.add(resource);
                continue;
            }
            if (!(resource instanceof SyncFolder)) continue;
            if (!((SyncFolder)resource).isEmpty()) {
                if (resource.getPair() != null && resource.getSyncState() == 6 || resource.getSyncState() == 7) {
                    files.add(resource);
                }
                files.addAll(((SyncFolder)resource).getAllFiles());
                continue;
            }
            files.add(resource);
        }
        return files;
    }

    public Collection<ISyncResource> getAllChildren() {
        HashSet<ISyncResource> members = new HashSet<ISyncResource>();
        for (ISyncResource resource : this.children) {
            members.add(resource);
            if (!(resource instanceof SyncFolder)) continue;
            members.addAll(((SyncFolder)resource).getAllChildren());
        }
        return members;
    }

    public ISyncResource[] getNonEmptyMembers() {
        HashSet<ISyncResource> members = new HashSet<ISyncResource>();
        for (ISyncResource resource : this.children) {
            if (resource instanceof SyncFile) {
                members.add(resource);
                continue;
            }
            if (!(resource instanceof SyncFolder) || ((SyncFolder)resource).isEmpty()) continue;
            members.add(resource);
        }
        return members.toArray(new ISyncResource[members.size()]);
    }

    public ISyncResource[] members() {
        return this.children.toArray(new ISyncResource[this.children.size()]);
    }

    @Override
    public SyncFolder getParent() {
        return this.parent;
    }

    @Override
    public IPath getPath() {
        return this.path;
    }

    @Override
    public boolean isSkipped() {
        return this.skipped;
    }

    @Override
    public void setSkipped(boolean skipped) {
        this.skipped = skipped;
        ISyncResource[] iSyncResourceArray = this.members();
        int n = iSyncResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISyncResource resource = iSyncResourceArray[n2];
            resource.setSkipped(this.skipped);
            ++n2;
        }
    }

    public void setSkipped(boolean skipped, boolean propogate) {
        this.skipped = skipped;
        if (propogate) {
            this.setSkipped(this.skipped);
        }
    }

    @Override
    public int getSyncState() {
        if (this.pair != null && this.syncState == -1) {
            return this.pair.getSyncState();
        }
        return this.syncState;
    }

    public void setSyncState(int state) {
        this.syncState = state;
    }

    @Override
    public VirtualFileSyncPair getPair() {
        return this.pair;
    }

    @Override
    public int getTransferState() {
        return this.transferState;
    }

    @Override
    public void setTransferState(int state) {
        this.transferState = state;
    }

    @Override
    public long getTransferredBytes() {
        return this.transferredBytes;
    }

    @Override
    public void setTransferredBytes(long bytes) {
        this.transferredBytes = bytes;
    }
}

