/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.views;

import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.io.efs.EFSUtils;
import com.aptana.ide.core.io.syncing.VirtualFileSyncPair;
import com.aptana.ide.syncing.core.Synchronizer;
import com.aptana.ide.syncing.core.events.ISyncEventHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncJob
extends Job
implements ISyncEventHandler {
    public static final int BOTH = 0;
    public static final int UPLOAD = 1;
    public static final int DOWNLOAD = 2;
    private static final String NAME = "Syncing";
    private Synchronizer fSyncer;
    private List<VirtualFileSyncPair> fPairs;
    private int fDirection;
    private boolean fDeleteRemote;
    private boolean fDeleteLocal;
    private List<VirtualFileSyncPair> fCompletedPairs;
    private int fErrorPairs;
    private IProgressMonitor progressMonitor;
    private Client fClient;

    public SyncJob(Synchronizer syncer, List<VirtualFileSyncPair> pairs, int direction, boolean deleteRemote, boolean deleteLocal, Client client) {
        super(NAME);
        this.fSyncer = syncer;
        this.fPairs = pairs;
        this.fDirection = direction;
        this.fDeleteRemote = deleteRemote;
        this.fDeleteLocal = deleteLocal;
        this.fClient = client;
        this.fCompletedPairs = new ArrayList<VirtualFileSyncPair>();
        this.sortPairs();
        this.fSyncer.setEventHandler((ISyncEventHandler)this);
    }

    public VirtualFileSyncPair[] getCompletedPairs() {
        return this.fCompletedPairs.toArray(new VirtualFileSyncPair[this.fCompletedPairs.size()]);
    }

    public long getTotalTransferBytes() {
        long bytes = 0L;
        int size = this.fPairs.size();
        int i = 0;
        while (i < size) {
            bytes += this.getTransferBytes(this.fPairs.get(i));
            ++i;
        }
        return bytes;
    }

    public long getTransferBytes(VirtualFileSyncPair pair) {
        switch (this.fDirection) {
            case 0: {
                int state = pair.getSyncState();
                if (state == 4 || state == 6 || state == 9) {
                    return pair.getSourceFile().fetchInfo().getLength();
                }
                if (state == 5 || state == 7 || state == 10) {
                    return pair.getDestinationFile().fetchInfo().getLength();
                }
                return 0L;
            }
            case 1: {
                return pair.getSourceFile().fetchInfo().getLength();
            }
            case 2: {
                return pair.getDestinationFile().fetchInfo().getLength();
            }
        }
        return 0L;
    }

    public int getErrorCount() {
        return this.fPairs.size() - this.fCompletedPairs.size();
    }

    public boolean syncContinue() {
        return !this.progressMonitor.isCanceled();
    }

    public void syncDone(VirtualFileSyncPair item) {
        if (this.progressMonitor.isCanceled()) {
            return;
        }
        this.fCompletedPairs.add(item);
        int syncState = item.getSyncState();
        if (syncState == 6 && this.fDeleteLocal && (this.fDirection == 0 || this.fDirection == 2)) {
            item.setSyncState(9);
        } else if (syncState == 7 && this.fDeleteRemote && (this.fDirection == 0 || this.fDirection == 1)) {
            item.setSyncState(10);
        }
        if (this.fClient != null) {
            this.fClient.syncDone(item, this.isDone());
        }
        this.progressMonitor.worked(1);
    }

    public boolean syncErrorEvent(VirtualFileSyncPair item, Exception e) {
        if (this.progressMonitor.isCanceled()) {
            return false;
        }
        ++this.fErrorPairs;
        if (this.fClient != null) {
            this.fClient.syncError(item, this.isDone());
        }
        return true;
    }

    public boolean syncEvent(VirtualFileSyncPair item, int index, int totalItems) {
        if (this.progressMonitor.isCanceled()) {
            return false;
        }
        if (this.fClient != null) {
            this.fClient.syncItem(item);
        }
        return true;
    }

    public void syncTransferring(VirtualFileSyncPair item, long bytes) {
        if (this.progressMonitor.isCanceled()) {
            return;
        }
        if (this.fClient != null) {
            this.fClient.syncProgress(item, bytes);
        }
    }

    public boolean getFilesEvent(IConnectionPoint manager, String path) {
        return true;
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.progressMonitor = monitor;
        if (this.fPairs.size() == 0) {
            if (this.fClient != null) {
                this.fClient.syncDone(null, true);
            }
        } else {
            monitor.beginTask("Syncing files", this.fPairs.size());
            VirtualFileSyncPair[] pairs = this.fPairs.toArray(new VirtualFileSyncPair[this.fPairs.size()]);
            switch (this.fDirection) {
                case 0: {
                    this.fullSync(pairs);
                    break;
                }
                case 1: {
                    this.upload(pairs);
                    break;
                }
                case 2: {
                    this.download(pairs);
                }
            }
        }
        return Status.OK_STATUS;
    }

    private boolean fullSync(VirtualFileSyncPair[] pairs) {
        return this.fSyncer.fullSyncAndDelete(pairs, this.fDeleteLocal, this.fDeleteRemote, this.progressMonitor);
    }

    private boolean download(VirtualFileSyncPair[] pairs) {
        try {
            this.fSyncer.downloadAndDelete(pairs, this.fDeleteLocal, this.progressMonitor);
            return true;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private boolean upload(VirtualFileSyncPair[] pairs) {
        try {
            this.fSyncer.uploadAndDelete(pairs, this.fDeleteRemote, this.progressMonitor);
            return true;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private boolean isDone() {
        return this.fCompletedPairs.size() + this.fErrorPairs == this.fPairs.size();
    }

    private void sortPairs() {
        Collections.sort(this.fPairs, new Comparator<VirtualFileSyncPair>(){

            @Override
            public int compare(VirtualFileSyncPair pair1, VirtualFileSyncPair pair2) {
                try {
                    if (pair1 != null && pair2 != null) {
                        if (SyncJob.this.fDeleteLocal && pair1.getSyncState() == 6 && pair2.getSyncState() == 6 && pair1.getSourceFile() != null && pair2.getSourceFile() != null) {
                            String s1 = EFSUtils.getAbsolutePath((IFileStore)pair1.getSourceFile());
                            String s2 = EFSUtils.getAbsolutePath((IFileStore)pair2.getSourceFile());
                            if (s1 != null) {
                                return -1 * s1.compareToIgnoreCase(s2);
                            }
                        } else if (SyncJob.this.fDeleteRemote && pair1.getSyncState() == 7 && pair2.getSyncState() == 7 && pair1.getDestinationFile() != null && pair2.getDestinationFile() != null) {
                            String s1 = EFSUtils.getAbsolutePath((IFileStore)pair1.getDestinationFile());
                            String s2 = EFSUtils.getAbsolutePath((IFileStore)pair2.getDestinationFile());
                            if (s1 != null) {
                                return -1 * s1.compareToIgnoreCase(s2);
                            }
                        }
                    }
                }
                catch (Exception exception) {}
                return 0;
            }
        });
    }

    public static interface Client {
        public void syncItem(VirtualFileSyncPair var1);

        public void syncProgress(VirtualFileSyncPair var1, long var2);

        public void syncDone(VirtualFileSyncPair var1, boolean var2);

        public void syncError(VirtualFileSyncPair var1, boolean var2);
    }
}

