/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.views;

import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.io.efs.EFSUtils;
import com.aptana.ide.core.io.syncing.VirtualFileSyncPair;
import com.aptana.ide.syncing.ui.views.ISyncResource;
import com.aptana.ide.syncing.ui.views.SyncFile;
import com.aptana.ide.syncing.ui.views.SyncFolder;
import java.util.ArrayList;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class SyncModelBuilder {
    private SyncModelBuilder() {
    }

    public static SyncFolder buildSyncFolder(IConnectionPoint sourceConnectionPoint, IConnectionPoint destConnectionPoint, VirtualFileSyncPair[] pairs) {
        SyncFolder root = new SyncFolder((IPath)new Path("/"), null, null);
        ArrayList<IFileStore> ignoredFiles = new ArrayList<IFileStore>();
        VirtualFileSyncPair[] virtualFileSyncPairArray = pairs;
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            VirtualFileSyncPair pair = virtualFileSyncPairArray[n2];
            IFileStore virtualFile = null;
            switch (pair.getSyncState()) {
                case 4: 
                case 6: {
                    virtualFile = pair.getSourceFile();
                    break;
                }
                case 5: 
                case 7: {
                    virtualFile = pair.getDestinationFile();
                    break;
                }
                case 1: 
                case 2: {
                    ignoredFiles.add(pair.getSourceFile());
                    break;
                }
                default: {
                    virtualFile = pair.getDestinationFile() == null ? pair.getSourceFile() : pair.getDestinationFile();
                }
            }
            if (virtualFile != null) {
                Path realPath = new Path(pair.getRelativePath());
                SyncFolder parent = root;
                int i = 0;
                while (i < realPath.segmentCount()) {
                    String segment = realPath.segment(i);
                    if (i < realPath.segmentCount() - 1) {
                        ISyncResource currFolder = parent.getMember(segment);
                        if (currFolder != null) {
                            if (currFolder instanceof SyncFolder) {
                                parent = (SyncFolder)currFolder;
                            } else if (currFolder instanceof SyncFile) {
                                SyncFile file = (SyncFile)currFolder;
                                SyncFolder convertedFolder = new SyncFolder(file.getPath(), parent, null);
                                parent.removeMember(file);
                                parent.addMember(convertedFolder);
                                parent = convertedFolder;
                            }
                        } else {
                            currFolder = new SyncFolder(parent.getPath().append(segment), parent, null);
                            parent.addMember(currFolder);
                            parent = (SyncFolder)currFolder;
                        }
                    } else if (!virtualFile.fetchInfo().isDirectory()) {
                        SyncFile file = new SyncFile(parent.getPath().append(segment), pair, parent);
                        parent.addMember(file);
                    } else if (virtualFile.fetchInfo().isDirectory()) {
                        SyncFolder folder = new SyncFolder(parent.getPath().append(segment), parent, pair);
                        parent.addMember(folder);
                    }
                    ++i;
                }
            }
            ++n2;
        }
        for (IFileStore file : ignoredFiles) {
            Path realPath = new Path(EFSUtils.getRelativePath((IConnectionPoint)sourceConnectionPoint, (IFileStore)file));
            SyncFolder parent = root;
            boolean found = true;
            int i = 0;
            while (i < realPath.segmentCount()) {
                String segment = realPath.segment(i);
                if (i < realPath.segmentCount() - 1) {
                    ISyncResource currFolder = parent.getMember(segment);
                    if (currFolder == null || !(currFolder instanceof SyncFolder)) {
                        found = false;
                        break;
                    }
                    parent = (SyncFolder)currFolder;
                }
                ++i;
            }
            if (!found || parent.getParent() == null) continue;
            int state = parent.getSyncState();
            switch (state) {
                case 4: 
                case 6: {
                    parent.setSyncState(4);
                    break;
                }
                case 5: 
                case 7: {
                    parent.setSyncState(5);
                }
            }
        }
        return root;
    }
}

