/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.ui;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.server.ServerCore;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.ui.Messages;
import com.aptana.ide.server.ui.ServerImagesRegistry;
import com.aptana.ide.server.ui.ServerUIPlugin;
import com.aptana.ide.server.ui.views.GenericServersView;
import java.util.Arrays;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.part.IPageBookViewPage;

public class ServerConsolePageParticipant
implements IConsolePageParticipant {
    public void activated() {
    }

    public void deactivated() {
    }

    public void dispose() {
    }

    public void init(IPageBookViewPage page, IConsole console) {
        IOConsole ioconsole = (IOConsole)console;
        IProcess attribute = (IProcess)ioconsole.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_PROCESS");
        if (attribute != null) {
            IServer[] iServerArray = ServerCore.getServerManager().getServers();
            int n = iServerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IServer srv = iServerArray[n2];
                IProcess[] processes = srv.getProcesses();
                if (processes != null && Arrays.asList(processes).contains(attribute)) {
                    page.getSite().getActionBars().getToolBarManager().add((IAction)new GoToServerAction(srv));
                }
                ++n2;
            }
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    private final class GoToServerAction
    extends Action {
        IServer srv;

        public GoToServerAction(IServer srv) {
            this.setToolTipText(Messages.ServerConsolePageParticipant_TITLE0);
            this.setImageDescriptor(ServerImagesRegistry.getInstance().getDescriptor(srv));
            this.srv = srv;
        }

        public void run() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                GenericServersView findView = (GenericServersView)activePage.showView("com.aptana.ide.server.ui.serversView");
                findView.select(this.srv);
            }
            catch (PartInitException e) {
                IdeLog.log((Plugin)ServerUIPlugin.getDefault(), (int)4, (String)"Part init exception while doing go to server action", (Throwable)e);
            }
        }
    }
}

