/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.ui;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.server.core.IServerEnvironmentConfigurator;
import com.aptana.ide.server.core.IServerPatcher;
import com.aptana.ide.server.ui.Messages;
import com.aptana.ide.server.ui.ServerUIPlugin;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerPatchingWizard
extends Wizard {
    private Map<IServerPatcher, WizardPage> patchers = new HashMap<IServerPatcher, WizardPage>();

    public ServerPatchingWizard(String serverName, List<IServerPatcher> patchers) {
        this.addPage((IWizardPage)new WelcomePage(serverName));
        for (IServerPatcher patcher : patchers) {
            IServerEnvironmentConfigurator configurator;
            if (patcher.isConfigured() || (configurator = patcher.getConfigurator()) == null || !configurator.requiresAdditionalInformation()) continue;
            WizardPage page = (WizardPage)configurator.getAdapter(WizardPage.class);
            if (page == null) {
                IdeLog.logError((Plugin)ServerUIPlugin.getDefault(), (String)Messages.ServerPatchingWizard_10);
                continue;
            }
            this.patchers.put(patcher, page);
            this.addPage((IWizardPage)page);
        }
        this.setDefaultPageImageDescriptor(ServerUIPlugin.getImageDescriptor("icons/server/wizban/xampp_wiz.png"));
    }

    public boolean performFinish() {
        for (Map.Entry<IServerPatcher, WizardPage> entry : this.patchers.entrySet()) {
            IServerPatcher patcher = entry.getKey();
            WizardPage page = entry.getValue();
            patcher.getConfigurator().configure((Object)page);
        }
        return true;
    }

    private class WelcomePage
    extends WizardPage {
        private Composite main;

        protected WelcomePage(String servername) {
            super(Messages.ServerPatchingWizard_0);
            this.setTitle(Messages.ServerPatchingWizard_1);
            ServerPatchingWizard.this.setHelpAvailable(false);
        }

        public void createControl(Composite parent) {
            this.main = new Composite(parent, 0);
            this.main.setLayout((Layout)new GridLayout());
            Label label1 = new Label(this.main, 0);
            Label label2 = new Label(this.main, 0);
            Label label3 = new Label(this.main, 0);
            label1.setLayoutData((Object)new GridData(4, 0, true, false));
            label2.setLayoutData((Object)new GridData(4, 0, true, false));
            label3.setLayoutData((Object)new GridData(4, 0, true, false));
            String buttonName = null;
            buttonName = ServerPatchingWizard.this.getPageCount() > 1 ? Messages.ServerPatchingWizard_2 : Messages.ServerPatchingWizard_3;
            String message1 = Messages.ServerPatchingWizard_4;
            String message2 = String.valueOf(Messages.ServerPatchingWizard_5) + buttonName + Messages.ServerPatchingWizard_6 + Messages.ServerPatchingWizard_7 + Messages.ServerPatchingWizard_8;
            String message3 = Messages.ServerPatchingWizard_9;
            label1.setText(message1);
            label2.setText(message2);
            label3.setText(message3);
            this.setControl((Control)this.main);
        }

        public Control getControl() {
            return this.main;
        }
    }
}

