/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.ui.generic.dialogs;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.SWTUtils;
import com.aptana.ide.server.ServerCore;
import com.aptana.ide.server.core.IAbstractConfiguration;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.core.ServerCorePlugin;
import com.aptana.ide.server.generic.GenericServer;
import com.aptana.ide.server.ui.IConfigurationDialog;
import com.aptana.ide.server.ui.generic.dialogs.Messages;
import com.aptana.ide.server.ui.views.ServerLabelProvider;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class GenericConfigurationDialog
extends TitleAreaDialog
implements IConfigurationDialog {
    private boolean isEdit;
    private IAbstractConfiguration configuration;
    private Composite displayArea;
    private Label serverNameLabel;
    private Text serverNameText;
    private Text healthURLText;
    private Text pollingIntervalText;
    private HashSet<String> serverNames = new HashSet();
    private Label hostnameLabel;
    private Text hostnameText;
    private Label portLabel;
    private Text portText;
    private Label serverDescLabel;
    private Text serverDescText;
    private Text startText;
    private Text stopText;
    private Text pauseText;
    private Text resumeText;
    private Text path;
    private Button isLocal;
    private IServer server;
    private Text log;
    private Text docRootText;
    private ModifyListener validationModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            GenericConfigurationDialog.this.validate();
        }
    };

    public GenericConfigurationDialog() {
        super(Display.getDefault().getActiveShell());
    }

    public void create() {
        super.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.aptana.ide.server.ui.servers_add_generic");
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.GenericConfigurationDialog_TITLE);
        this.getShell().setText(Messages.GenericConfigurationDialog_SHELL_TITLE);
        this.setMessage(Messages.GenericConfigurationDialog_GENERIC_);
        this.displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(3, false);
        daLayout.marginHeight = 10;
        daLayout.marginWidth = 10;
        this.displayArea.setLayout((Layout)daLayout);
        GridData daData = new GridData(4, 4, true, true);
        daData.widthHint = 550;
        this.displayArea.setLayoutData((Object)daData);
        this.serverNameLabel = new Label(this.displayArea, 16384);
        this.serverNameLabel.setText(Messages.GenericConfigurationDialog_SERVER_NAME);
        this.serverNameText = new Text(this.displayArea, 2052);
        GridData sntData = new GridData(4, 4, true, false);
        sntData.horizontalSpan = 2;
        this.serverNameText.setLayoutData((Object)sntData);
        if (this.configuration != null) {
            this.serverNameText.setText(this.configuration.getStringAttribute("name"));
        }
        this.serverNameText.addModifyListener(this.validationModifyListener);
        this.serverDescLabel = new Label(this.displayArea, 16384);
        this.serverDescLabel.setText(Messages.GenericConfigurationDialog_SERVER_DESCRIPTION);
        this.serverDescText = new Text(this.displayArea, 2052);
        if (this.configuration != null) {
            this.serverDescText.setText(this.configuration.getStringAttribute("description"));
        }
        GridData sndData = new GridData(4, 4, true, false);
        sndData.horizontalSpan = 2;
        this.serverDescText.setLayoutData((Object)sndData);
        this.hostnameLabel = new Label(this.displayArea, 16384);
        this.hostnameLabel.setText(Messages.GenericConfigurationDialog_5);
        this.hostnameText = new Text(this.displayArea, 2052);
        if (this.configuration != null) {
            String path = this.configuration.getStringAttribute("host");
            this.hostnameText.setText(path);
        }
        this.hostnameText.addModifyListener(this.validationModifyListener);
        GridData htData = new GridData(4, 4, true, false);
        htData.horizontalSpan = 2;
        this.hostnameText.setLayoutData((Object)htData);
        this.portLabel = new Label(this.displayArea, 16384);
        this.portLabel.setText(Messages.GenericConfigurationDialog_HOSTNAME);
        this.portText = new Text(this.displayArea, 2052);
        String port = this.configuration.getStringAttribute("port");
        this.portText.setText(port);
        this.portText.addModifyListener(this.validationModifyListener);
        GridData ptData = new GridData(4, 4, true, false);
        ptData.horizontalSpan = 2;
        this.portText.setLayoutData((Object)ptData);
        this.log = this.createOpenExecutable(Messages.GenericConfigurationDialog_PATH_TO_LOG_FILE, this.displayArea, "logpath");
        Composite heartbeatComp = new Composite(this.displayArea, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        heartbeatComp.setLayout((Layout)layout);
        GridData hbcData = new GridData(4, 4, true, false);
        hbcData.horizontalSpan = 3;
        heartbeatComp.setLayoutData((Object)hbcData);
        Label hbLabel = new Label(heartbeatComp, 0);
        hbLabel.setText(Messages.GenericConfigurationDialog_LBL_Heartbeat);
        this.healthURLText = new Text(heartbeatComp, 2052);
        GridData hutData = new GridData(4, 0x1000000, true, false);
        this.healthURLText.setLayoutData((Object)hutData);
        if (this.configuration != null) {
            this.healthURLText.setText(this.configuration.getStringAttribute("health_url"));
        }
        this.healthURLText.addModifyListener(this.validationModifyListener);
        Composite heartbeatComp2 = new Composite(heartbeatComp, 0);
        heartbeatComp2.setLayout((Layout)new GridLayout(2, false));
        heartbeatComp2.setLayoutData((Object)new GridData(4, 4, false, false));
        Label pollingLabel = new Label(heartbeatComp2, 16384);
        pollingLabel.setText(Messages.GenericConfigurationDialog_LBL_Polling);
        this.pollingIntervalText = new Text(heartbeatComp2, 2052);
        GridData pollData = new GridData(4, 4, false, false);
        pollData.widthHint = 30;
        this.pollingIntervalText.setLayoutData((Object)pollData);
        int interval = this.configuration.getIntAttribute("polling_interval");
        if (interval > 0) {
            this.pollingIntervalText.setText(Integer.toString(interval / 1000));
        } else {
            this.pollingIntervalText.setText("30");
        }
        this.pollingIntervalText.addModifyListener(this.validationModifyListener);
        new Label(heartbeatComp, 0);
        Label healthBanner = new Label(heartbeatComp, 0);
        GridData hbData = new GridData();
        hbData.verticalIndent = -5;
        hbData.horizontalSpan = 2;
        healthBanner.setLayoutData((Object)hbData);
        healthBanner.setText(Messages.GenericConfigurationDialog_LBL_Banner);
        Font smallFont = SWTUtils.getDefaultSmallFont();
        healthBanner.setFont(smallFont);
        this.isLocal = new Button(this.displayArea, 32);
        ptData = new GridData(4, 4, true, false);
        ptData.verticalIndent = 10;
        ptData.horizontalSpan = 3;
        this.isLocal.setText(Messages.GenericConfigurationDialog_IS_SERVER_LOCAL);
        this.isLocal.setLayoutData((Object)ptData);
        this.path = this.createOpenExecutable(Messages.GenericConfigurationDialog_PATH, this.displayArea, "path");
        this.docRootText = this.createDirecotrySelectionText(Messages.GenericConfigurationDialog_DOCUMENT_ROOT, this.displayArea, "document_root");
        this.startText = this.createText(Messages.GenericConfigurationDialog_START_SERVER, this.displayArea, "start");
        this.stopText = this.createText(Messages.GenericConfigurationDialog_STOP_SERVER, this.displayArea, "stop");
        this.pauseText = this.createText(Messages.GenericConfigurationDialog_PAUSE_SERVER, this.displayArea, "pause");
        this.resumeText = this.createText(Messages.GenericConfigurationDialog_RESUME_SERVER, this.displayArea, "pause");
        this.isLocal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenericConfigurationDialog.this.checkLocal();
                GenericConfigurationDialog.this.validate();
            }
        });
        if (this.configuration != null) {
            this.isLocal.setSelection(this.configuration.getBooleanAttribute("isLocal"));
        }
        this.checkLocal();
        return this.displayArea;
    }

    protected Text createText(String label, Composite parent, String key) {
        Label ll = new Label(parent, 0);
        ll.setText(label);
        Text t = new Text(parent, 2052);
        GridData ptData = new GridData(4, 4, true, false);
        ptData.horizontalSpan = 2;
        t.setLayoutData((Object)ptData);
        if (this.configuration != null) {
            t.setText(this.configuration.getStringAttribute(key));
        }
        t.addModifyListener(this.validationModifyListener);
        return t;
    }

    protected Text createDirecotrySelectionText(String label, Composite parent, String key) {
        String value;
        Label l = new Label(parent, 0);
        l.setText(label);
        final Text text = new Text(parent, 2048);
        if (this.configuration != null && (value = this.configuration.getStringAttribute(key)) != null) {
            text.setText(value);
        }
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(this.validationModifyListener);
        Button browseBt = new Button(parent, 8);
        browseBt.setText(Messages.GenericConfigurationDialog_BROWSE);
        browseBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(GenericConfigurationDialog.this.getShell());
                String path = dialog.open();
                if (path != null) {
                    text.setText(path);
                }
            }
        });
        text.setData("browse", (Object)browseBt);
        return text;
    }

    protected Text createOpenExecutable(String label, Composite parent, String key) {
        Label ll = new Label(parent, 0);
        ll.setText(label);
        final Text t = new Text(parent, 2052);
        GridData ptData = new GridData(4, 0x1000000, true, false);
        ptData.horizontalSpan = 1;
        t.setLayoutData((Object)ptData);
        if (this.configuration != null) {
            t.setText(this.configuration.getStringAttribute(key));
        }
        t.addModifyListener(this.validationModifyListener);
        Button browser = new Button(parent, 8);
        browser.setText(Messages.GenericConfigurationDialog_BROWSE);
        browser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String open;
                File file;
                File parentFile;
                FileDialog fdlg = new FileDialog(GenericConfigurationDialog.this.getShell(), 4096);
                String text = t.getText();
                if (text.length() > 0 && (parentFile = (file = new File(text)).getParentFile()) != null) {
                    fdlg.setFilterPath(parentFile.getPath());
                }
                if ((open = fdlg.open()) != null) {
                    t.setText(open);
                }
            }
        });
        t.setData("browse", (Object)browser);
        return t;
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        this.initDublicateNames();
        this.validate();
        return c;
    }

    private void initDublicateNames() {
        IServer[] servers;
        IServer[] iServerArray = servers = ServerCore.getServerManager().getServers();
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            IServer s = iServerArray[n2];
            if (!s.getId().equals(this.configuration.getStringAttribute("id"))) {
                this.serverNames.add(s.getName());
            }
            ++n2;
        }
    }

    private void validate() {
        Integer i;
        String name = this.serverNameText.getText();
        String hostname = this.hostnameText.getText();
        Button ok = this.getButton(0);
        String port = this.portText.getText();
        boolean error = false;
        if (name.trim().length() == 0) {
            this.setErrorMessage(Messages.GenericConfigurationDialog_SERVER_NAME_MUST_NOT_BE_BLANK);
            error = true;
            ok.setEnabled(false);
        } else if (this.serverNames.contains(name)) {
            this.setErrorMessage(Messages.GenericConfigurationDialog_SERVER_NAME_EXISTS);
            error = true;
        } else if (hostname.trim().length() == 0) {
            this.setErrorMessage(Messages.GenericConfigurationDialog_HOST_NAME_MUST_NOT_BE_BLANK);
            error = true;
        }
        if (!error) {
            try {
                i = Integer.parseInt(port);
                if (i < 0 || i > 65535) {
                    this.setErrorMessage(Messages.GenericConfigurationDialog_PORT_MUST_BE_IN_RANGE);
                    error = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(Messages.GenericConfigurationDialog_PORT_MUST_BE_INTEGER);
                error = true;
            }
        }
        if (!error && this.isLocal.getSelection()) {
            String docRootPath;
            File file = new File(this.path.getText());
            if (file.exists()) {
                if (file.isFile()) {
                    error = false;
                    if (this.startText.getText().length() == 0) {
                        this.setErrorMessage(Messages.GenericConfigurationDialog_START_IS_EMPTY);
                        error = true;
                    } else if (this.stopText.getText().length() == 0) {
                        this.setErrorMessage(Messages.GenericConfigurationDialog_STOP_IS_EMPTY);
                        error = true;
                    } else if (!(this.log.getText().length() == 0 || (file = new File(this.log.getText())).exists() && file.isFile())) {
                        this.setErrorMessage(Messages.GenericConfigurationDialog_PATH_TO_LOG_FILE_SHOULD_BE_EMPTY_OR_POINT_TO_FILE);
                        error = true;
                    }
                } else {
                    error = true;
                    this.setErrorMessage(Messages.GenericConfigurationDialog_PATH_SHOULD_NOT_POINT_TO_DIRECTORY);
                }
            } else {
                error = true;
                this.setErrorMessage(Messages.GenericConfigurationDialog_NO_FILE_UNDER_A_GIVEN_PATH);
            }
            if (!error && (docRootPath = this.docRootText.getText().trim()).length() == 0 && !new File(docRootPath).isDirectory()) {
                error = true;
                this.setErrorMessage(Messages.GenericConfigurationDialog_DOCUMENT_ROOT_ERROR);
            }
        }
        if (!error && this.healthURLText.getText().trim().length() > 0) {
            try {
                new URL(this.healthURLText.getText().trim());
            }
            catch (MalformedURLException malformedURLException) {
                error = true;
                this.setErrorMessage(Messages.GenericConfigurationDialog_MSG_InvalidHeartbeat);
            }
            if (!error) {
                try {
                    i = Integer.parseInt(this.pollingIntervalText.getText());
                    if (i < 1) {
                        this.setErrorMessage(Messages.GenericConfigurationDialog_MSG_PollingBound);
                        error = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.setErrorMessage(Messages.GenericConfigurationDialog_MSG_PollingInteger);
                    error = true;
                }
            }
        }
        if (!error) {
            boolean allowed = false;
            if (this.server instanceof GenericServer) {
                boolean isLocal = this.configuration.getBooleanAttribute("isLocal");
                String healthURL = this.configuration.getStringAttribute("health_url");
                int pollingInterval = this.configuration.getIntAttribute("polling_interval");
                if (!isLocal && healthURL != null && healthURL.length() > 0 && pollingInterval > 0) {
                    allowed = true;
                }
            }
            if (this.server != null && !allowed && this.server.getServerState() != 4 && this.server.getServerState() != 0 && this.server.getServerState() != 6) {
                this.setErrorMessage(ServerLabelProvider.SERVER_IS_RUNNING_NO_EDIT);
                ok.setEnabled(false);
                return;
            }
            this.setErrorMessage(null);
        }
        ok.setEnabled(!error);
    }

    protected void okPressed() {
        this.configuration.setStringAttribute("name", this.serverNameText.getText());
        this.configuration.setStringAttribute("description", this.serverDescText.getText());
        this.configuration.setStringAttribute("host", this.hostnameText.getText());
        this.configuration.setIntAttribute("port", Integer.parseInt(this.portText.getText()));
        this.configuration.setStringAttribute("path", this.path.getText());
        this.configuration.setStringAttribute("start", this.startText.getText());
        this.configuration.setStringAttribute("stop", this.stopText.getText());
        this.configuration.setStringAttribute("pause", this.pauseText.getText());
        this.configuration.setStringAttribute("resume", this.resumeText.getText());
        this.configuration.setBooleanAttribute("isLocal", this.isLocal.getSelection());
        this.configuration.setStringAttribute("logpath", this.log.getText());
        this.configuration.setStringAttribute("health_url", this.healthURLText.getText());
        this.configuration.setStringAttribute("document_root", this.docRootText.getText());
        try {
            int polling = Integer.parseInt(this.pollingIntervalText.getText());
            this.configuration.setIntAttribute("polling_interval", polling * 1000);
        }
        catch (NumberFormatException e) {
            IdeLog.logInfo((Plugin)ServerCorePlugin.getDefault(), (String)Messages.GenericConfigurationDialog_INF_IntervalError, (Throwable)e);
        }
        super.okPressed();
    }

    public Dialog getDialog() {
        return this;
    }

    public boolean isEdit() {
        return this.isEdit;
    }

    public void setEdit(boolean isEdit) {
        this.isEdit = isEdit;
    }

    public IAbstractConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(IAbstractConfiguration configuration) {
        this.configuration = configuration;
    }

    private void checkLocal() {
        boolean en = this.isLocal.getSelection();
        this.healthURLText.setEnabled(!en);
        this.pollingIntervalText.setEnabled(!en);
        this.path.setEnabled(en);
        Object browseButton = this.path.getData("browse");
        if (browseButton instanceof Button) {
            ((Button)browseButton).setEnabled(en);
        }
        this.startText.setEnabled(en);
        this.stopText.setEnabled(en);
        this.pauseText.setEnabled(en);
        this.resumeText.setEnabled(en);
        this.docRootText.setEnabled(en);
        browseButton = this.docRootText.getData("browse");
        if (browseButton instanceof Button) {
            ((Button)browseButton).setEnabled(en);
        }
    }

    public void setServer(IServer server) {
        this.server = server;
    }
}

