/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.ui.views;

import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.core.IServerManager;
import com.aptana.ide.server.core.IServerManagerListener;
import com.aptana.ide.server.core.ServerManagerEvent;
import com.aptana.ide.server.core.impl.servers.GroupServer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;

public class ServerContentProvider
implements ITreeContentProvider,
IServerManagerListener {
    private TreeViewer viewer;
    private IServerManager manager;

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IServerManager) {
            IServerManager manager = (IServerManager)inputElement;
            return manager.getServers();
        }
        return new Object[0];
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.manager != null) {
            this.dispose();
        }
        if (newInput instanceof IServerManager) {
            this.manager = (IServerManager)newInput;
            this.manager.addServerManagerListener((IServerManagerListener)this);
        }
        this.viewer = (TreeViewer)viewer;
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.removeServerManagerListener((IServerManagerListener)this);
            this.manager = null;
        }
    }

    public void serverAdded(IServer server) {
        this.safeRefresh();
    }

    private void safeRefresh() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ServerContentProvider.this.viewer.refresh();
            }
        });
    }

    public void serverChanged(IServer server) {
        this.safeRefresh();
    }

    public void serverRemoved(IServer server) {
        this.safeRefresh();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof GroupServer) {
            return ((GroupServer)parentElement).getServers().toArray();
        }
        if (parentElement instanceof IServer) {
            IServer srv = (IServer)parentElement;
            return srv.getModules();
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof GroupServer) {
            return !((GroupServer)element).isEmpty();
        }
        if (element instanceof IServer) {
            IServer srv = (IServer)element;
            return srv.getModules().length > 0;
        }
        return false;
    }

    public void serversChanged(final ServerManagerEvent event) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (ServerContentProvider.this.viewer.getControl().isDisposed()) {
                    return;
                }
                switch (event.getKind()) {
                    case 0: {
                        ServerContentProvider.this.viewer.add((Object)new TreePath(new Object[0]), (Object)event.getServer());
                        break;
                    }
                    case 1: {
                        ServerContentProvider.this.viewer.remove((Object)event.getServer());
                    }
                    case 2: {
                        ServerContentProvider.this.viewer.refresh((Object)event.getServer(), true);
                    }
                }
            }
        });
    }
}

