/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.ui.views.actions;

import com.aptana.ide.server.ServerCore;
import com.aptana.ide.server.core.IServerType;
import com.aptana.ide.server.ui.ServerDialogPageRegistry;
import com.aptana.ide.server.ui.ServerUIPlugin;
import com.aptana.ide.server.ui.generic.dialogs.ServerTypeSelectionDialog;
import com.aptana.ide.server.ui.views.actions.ICanAdd;
import com.aptana.ide.server.ui.views.actions.Messages;
import com.aptana.ide.server.ui.views.actions.NewServerAction;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;

public class GenericAddServerAction
extends Action {
    private static final boolean USE_DROP_DOWN = false;

    public GenericAddServerAction() {
        super(Messages.GenericAddServerActionTITLE, 4);
        this.setImageDescriptor(ServerUIPlugin.getImageDescriptor("/icons/server/add_server.gif"));
        this.setMenuCreator(new IMenuCreator(){

            public void dispose() {
            }

            public Menu getMenu(Control parent) {
                MenuManager mn = new MenuManager();
                GenericAddServerAction.this.fillManager(mn);
                return mn.createContextMenu(parent);
            }

            public Menu getMenu(Menu parent) {
                MenuManager mn = new MenuManager();
                GenericAddServerAction.this.fillManager(mn);
                Menu menu = new Menu(parent);
                mn.fill(menu, 0);
                return menu;
            }
        });
    }

    public void run() {
        ServerTypeSelectionDialog s = new ServerTypeSelectionDialog(Display.getCurrent().getActiveShell());
        s.open();
        IServerType result = s.getResult();
        if (result != null) {
            new NewServerAction(result).run();
        }
    }

    private void fillManager(MenuManager mn) {
        IServerType[] knownServerTypes = ServerCore.getServerManager().getServerTypes();
        Arrays.sort(knownServerTypes, new Comparator<IServerType>(){

            @Override
            public int compare(IServerType arg0, IServerType arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        int a = 0;
        while (a < knownServerTypes.length) {
            boolean b;
            IServerType type = knownServerTypes[a];
            boolean hasDialog = ServerDialogPageRegistry.getInstance().hasDialog(type.getId());
            boolean bl = b = type.getAdapter(ICanAdd.class) != null;
            if (hasDialog || b) {
                NewServerAction action = new NewServerAction(type);
                mn.add((IAction)action);
            }
            ++a;
        }
    }
}

