/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.ui.views.actions;

import com.aptana.ide.server.ServerCore;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.core.IServerManagerListener;
import com.aptana.ide.server.core.ServerManagerEvent;
import com.aptana.ide.server.ui.ServerUIPlugin;
import com.aptana.ide.server.ui.views.actions.ICanOpenConsole;
import com.aptana.ide.server.ui.views.actions.Messages;
import java.util.WeakHashMap;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.TextConsole;

public class OpenConsole
extends Action
implements ISelectionChangedListener {
    private static final String TITLE = Messages.OpenConsole_TITLE;
    private static WeakHashMap<IServer, IConsole> consoles = new WeakHashMap();
    protected IServer server;

    static {
        ConsolePlugin.getDefault().getConsoleManager().addConsoleListener(new IConsoleListener(){

            public void consolesAdded(IConsole[] consoles) {
                IConsole[] iConsoleArray = consoles;
                int n = consoles.length;
                int n2 = 0;
                while (n2 < n) {
                    TextConsole cm;
                    IProcess attribute;
                    IConsole c = iConsoleArray[n2];
                    if (c instanceof TextConsole && (attribute = (IProcess)(cm = (TextConsole)c).getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_PROCESS")) != null) {
                        IServer[] iServerArray = ServerCore.getServerManager().getServers();
                        int n3 = iServerArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IProcess[] processes;
                            IServer s = iServerArray[n4];
                            IProcess[] iProcessArray = processes = s.getProcesses();
                            int n5 = processes.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IProcess m = iProcessArray[n6];
                                if (m != null && m.equals(attribute)) {
                                    consoles.put(s, cm);
                                }
                                ++n6;
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }

            public void consolesRemoved(IConsole[] consoles) {
            }
        });
        ServerCore.getServerManager().addServerManagerListener(new IServerManagerListener(){

            public void serversChanged(ServerManagerEvent event) {
                IConsole[] iConsoleArray = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
                int n = iConsoleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConsole m = iConsoleArray[n2];
                    if (m instanceof TextConsole) {
                        TextConsole cs = (TextConsole)m;
                        IProcess attribute = (IProcess)cs.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_PROCESS");
                        IServer[] iServerArray = ServerCore.getServerManager().getServers();
                        int n3 = iServerArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IProcess[] processes;
                            IServer s = iServerArray[n4];
                            IProcess[] iProcessArray = processes = s.getProcesses();
                            int n5 = processes.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IProcess ma = iProcessArray[n6];
                                if (ma != null && ma.equals(attribute)) {
                                    consoles.put(s, cs);
                                }
                                ++n6;
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
        });
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object firstElement;
        StructuredSelection ss;
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            this.setEnabled(false);
        }
        if (selection instanceof StructuredSelection && (ss = (StructuredSelection)selection).size() == 1 && (firstElement = ss.getFirstElement()) instanceof IServer) {
            this.server = (IServer)firstElement;
            ICanOpenConsole adapter = (ICanOpenConsole)this.server.getAdapter(ICanOpenConsole.class);
            this.setEnabled(adapter != null || consoles.get(this.server) != null);
            return;
        }
        this.setEnabled(false);
    }

    public OpenConsole(ISelectionProvider provider) {
        super(TITLE);
        this.setToolTipText(TITLE);
        provider.addSelectionChangedListener((ISelectionChangedListener)this);
        this.setImageDescriptor(ServerUIPlugin.getImageDescriptor("/icons/server/console_view.gif"));
    }

    public void run() {
        if (this.server != null) {
            IConsole console2;
            ICanOpenConsole adapter = (ICanOpenConsole)this.server.getAdapter(ICanOpenConsole.class);
            if (adapter != null) {
                adapter.openConsole();
            }
            if ((console2 = consoles.get(this.server)) != null) {
                ConsolePlugin.getDefault().getConsoleManager().showConsoleView(console2);
            }
        }
        super.run();
    }
}

