/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.ui.views.actions;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.ui.ServerUIPlugin;
import com.aptana.ide.server.ui.views.actions.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class OpenStatisticsAction
extends Action {
    private ISelectionProvider provider;

    public OpenStatisticsAction(ISelectionProvider provider) {
        this.setImageDescriptor(ServerUIPlugin.getImageDescriptor("/icons/stats.png"));
        this.setToolTipText(Messages.OpenStatisticsAction_TTP_ViewStats);
        this.provider = provider;
        this.provider.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof StructuredSelection && !selection.isEmpty()) {
                    StructuredSelection ss = (StructuredSelection)selection;
                    if (ss.getFirstElement() instanceof IServer) {
                        IServer server = (IServer)ss.getFirstElement();
                        OpenStatisticsAction.this.setEnabled(server.suppliesStatistics());
                    } else {
                        OpenStatisticsAction.this.setEnabled(false);
                    }
                } else {
                    OpenStatisticsAction.this.setEnabled(false);
                }
            }
        });
    }

    public void run() {
        StructuredSelection ss;
        ISelection selection = this.provider.getSelection();
        if (selection instanceof StructuredSelection && !selection.isEmpty() && (ss = (StructuredSelection)selection).getFirstElement() != null && ss.getFirstElement() instanceof IServer) {
            IServer server = (IServer)ss.getFirstElement();
            if (server.suppliesStatisticsInterface()) {
                server.showStatisticsInterface();
            } else {
                String stats = server.fetchStatistics();
                MessageDialog dialog = new MessageDialog(Display.getDefault().getActiveShell(), StringUtils.format((String)Messages.OpenStatisticsAction_Stats_Title, (String)server.getName()), null, stats, 2, new String[]{IDialogConstants.OK_LABEL}, 0){

                    protected Control createMessageArea(Composite composite) {
                        super.createMessageArea(composite);
                        GridData mlData = new GridData(4, 4, true, true);
                        this.messageLabel.setLayoutData((Object)mlData);
                        return composite;
                    }

                    protected int getMessageLabelStyle() {
                        return 16384;
                    }
                };
                dialog.open();
            }
        }
    }
}

