/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.ui.views.actions;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.ui.ServerUIPlugin;
import com.aptana.ide.server.ui.views.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;

public final class StartServerAction
extends Action {
    private ISelectionProvider provider;
    private String mode;

    public StartServerAction(ISelectionProvider provider, String mode) {
        if (mode.equals("run")) {
            this.setImageDescriptor(ServerUIPlugin.getImageDescriptor("/icons/server/start.gif"));
            this.setToolTipText(Messages.ServersView_START);
        } else if (mode.equals("debug")) {
            this.setImageDescriptor(ServerUIPlugin.getImageDescriptor("/icons/server/debug.gif"));
            this.setToolTipText(Messages.ServersView_DEBUG);
        } else if (mode.equals("profile")) {
            this.setImageDescriptor(ServerUIPlugin.getImageDescriptor("/icons/server/profile.gif"));
            this.setToolTipText(Messages.ServersView_PROFILE);
        }
        this.provider = provider;
        this.mode = mode;
    }

    public boolean isEnabled() {
        IStructuredSelection selection = (IStructuredSelection)this.provider.getSelection();
        if (!selection.isEmpty()) {
            IServer server = (IServer)selection.getFirstElement();
            IStatus canStart = server.canStart(this.mode);
            return canStart.isOK();
        }
        return false;
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.provider.getSelection();
        if (!selection.isEmpty()) {
            IServer server = (IServer)selection.getFirstElement();
            try {
                server.start(this.mode, null, null);
            }
            catch (Exception e) {
                IdeLog.log((Plugin)ServerUIPlugin.getDefault(), (int)4, (String)"exception while starting server", (Throwable)e);
            }
        }
    }
}

