/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.widgets;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class TreeViewerSorter
extends ViewerSorter {
    private int columnIndex = 0;

    public TreeViewerSorter(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int order = 0;
        if (viewer instanceof TreeViewer) {
            TreeViewer tv = (TreeViewer)viewer;
            Tree table = tv.getTree();
            table.setSortColumn(table.getColumn(this.columnIndex));
            int idx1 = -1;
            int idx2 = -1;
            TreeItem[] items = table.getItems();
            int i = 0;
            while (i < items.length) {
                Object obj = items[i].getData();
                if (obj.equals(e1)) {
                    idx1 = i;
                } else if (obj.equals(e2)) {
                    idx2 = i;
                }
                if (idx1 > 0 && idx2 > 0) break;
                ++i;
            }
            if (idx1 > -1 && idx2 > -1) {
                String str1 = table.getItems()[idx1].getText(this.columnIndex);
                String str2 = table.getItems()[idx2].getText(this.columnIndex);
                order = str1.compareTo(str2);
                try {
                    Double d1 = Double.valueOf(str1);
                    Double d2 = Double.valueOf(str2);
                    order = d1.compareTo(d2);
                }
                catch (NumberFormatException numberFormatException) {}
                if (table.getSortDirection() != 128) {
                    order *= -1;
                }
            }
        }
        return order;
    }

    public static void bind(final TreeViewer tableViewer) {
        final Tree table = tableViewer.getTree();
        int i = 0;
        while (i < table.getColumnCount()) {
            final int columnNum = i;
            TreeColumn column = table.getColumn(i);
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TreeViewerSorter sorter = new TreeViewerSorter(columnNum);
                    if (table.getSortDirection() == 128) {
                        table.setSortDirection(1024);
                    } else if (table.getSortDirection() == 1024) {
                        table.setSortDirection(128);
                    } else {
                        table.setSortDirection(128);
                    }
                    tableViewer.setSorter((ViewerSorter)sorter);
                }
            });
            ++i;
        }
    }
}

