/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io;

import com.aptana.ide.core.PlatformUtils;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.misc.ExternalProgramImageDescriptor;

public final class ImageUtils {
    private static final String USER_HOME = PlatformUtils.expandEnvironmentStrings((String)PlatformUtils.HOME_DIRECTORY);
    private static final String DESKTOP = PlatformUtils.expandEnvironmentStrings((String)"%DesktopDirectory%");
    private static final boolean ON_WINDOWS = "win32".equals(Platform.getOS());
    private static JFileChooser jFileChooser;
    private static final WeakHashMap<Object, String> iconToKeyMap;

    static {
        iconToKeyMap = new WeakHashMap();
    }

    private ImageUtils() {
    }

    public static ImageDescriptor getImageDescriptor(File file) {
        ImageDescriptor imageDescriptor;
        if (file.isFile() && (imageDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(file.getName())) != null) {
            return imageDescriptor;
        }
        if (file.exists()) {
            String fileType;
            if (jFileChooser == null) {
                jFileChooser = new JFileChooser();
            }
            if ((fileType = jFileChooser.getTypeDescription(file)) == null || fileType.length() == 0 || "Directory".equals(fileType) || "System Folder".equals(fileType) || "Generic File".equals(fileType)) {
                String name = file.getName();
                try {
                    name = file.getCanonicalFile().getName();
                }
                catch (IOException iOException) {
                    name = file.getName();
                }
                if (name.equals(new Path(DESKTOP).lastSegment())) {
                    fileType = "Desktop";
                } else if (!file.isDirectory()) {
                    int index = name.lastIndexOf(46);
                    fileType = index >= 0 && index < name.length() - 1 ? name.substring(index + 1) : "unknown";
                } else if ("Directory".equals(fileType) || name.length() == 0) {
                    fileType = file.getAbsolutePath();
                } else if ("System Folder".equals(fileType) && file.getAbsolutePath().equals(USER_HOME)) {
                    fileType = "UserHome";
                }
            }
            String imageKey = "os.fileType_" + fileType;
            ImageRegistry imageRegistry = JFaceResources.getImageRegistry();
            ImageDescriptor imageDescriptor2 = imageRegistry.getDescriptor(imageKey);
            if (imageDescriptor2 != null) {
                return imageDescriptor2;
            }
            Icon icon = ON_WINDOWS ? FileSystemView.getFileSystemView().getSystemIcon(file) : jFileChooser.getIcon(file);
            if (icon != null) {
                String existingImageKey = iconToKeyMap.get(icon);
                if (existingImageKey != null && (imageDescriptor2 = imageRegistry.getDescriptor(existingImageKey)) != null) {
                    return imageDescriptor2;
                }
                ImageData imageData = ImageUtils.awtImageIconToSWTImageData(icon, null);
                if (imageData != null) {
                    imageDescriptor2 = ImageDescriptor.createFromImageData((ImageData)imageData);
                    imageRegistry.put(imageKey, imageDescriptor2);
                    iconToKeyMap.put(icon, imageKey);
                    return imageRegistry.getDescriptor(imageKey);
                }
            }
        }
        return ImageUtils.getImageDescriptor(file.getName());
    }

    public static ImageDescriptor getImageDescriptor(String filename) {
        ImageDescriptor imageDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(filename);
        if (imageDescriptor == null) {
            imageDescriptor = ImageUtils.getExtensionImageDescriptor(new Path(filename).getFileExtension());
        }
        return imageDescriptor;
    }

    private static ImageDescriptor getExtensionImageDescriptor(String extension) {
        String imageKey;
        ImageRegistry imageRegistry = JFaceResources.getImageRegistry();
        ImageDescriptor imageDescriptor = imageRegistry.getDescriptor(imageKey = "extension_" + extension);
        if (imageDescriptor == null) {
            Program program = Program.findProgram((String)extension);
            if (program == null) {
                return null;
            }
            imageDescriptor = new ExternalProgramImageDescriptor(program);
            imageRegistry.put(imageKey, imageDescriptor);
            imageDescriptor = imageRegistry.getDescriptor(imageKey);
        }
        return imageDescriptor;
    }

    private static ImageData awtImageIconToSWTImageData(Icon icon, Color backgroundColor) {
        java.awt.Color bgColor = ImageUtils.swtColorToAWTColor(backgroundColor != null ? backgroundColor : Display.getCurrent().getSystemColor(25));
        BufferedImage bi = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 1);
        Graphics2D imageGraphics = bi.createGraphics();
        try {
            if (icon instanceof ImageIcon) {
                imageGraphics.drawImage(((ImageIcon)icon).getImage(), 0, 0, bgColor, null);
            } else {
                if (jFileChooser == null) {
                    jFileChooser = new JFileChooser();
                }
                imageGraphics.setBackground(bgColor);
                imageGraphics.clearRect(0, 0, icon.getIconWidth(), icon.getIconHeight());
                icon.paintIcon(jFileChooser, imageGraphics, 0, 0);
            }
            ImageData imageData = ImageUtils.awtBufferedImageToSWTImageData(bi);
            return imageData;
        }
        finally {
            imageGraphics.dispose();
        }
    }

    private static java.awt.Color swtColorToAWTColor(Color color) {
        return new java.awt.Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    private static ImageData awtBufferedImageToSWTImageData(BufferedImage bufferedImage) {
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel colorModel = (DirectColorModel)bufferedImage.getColorModel();
            PaletteData palette = new PaletteData(colorModel.getRedMask(), colorModel.getGreenMask(), colorModel.getBlueMask());
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[3];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    int pixel = palette.getPixel(new RGB(pixelArray[0], pixelArray[1], pixelArray[2]));
                    data.setPixel(x, y, pixel);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel colorModel = (IndexColorModel)bufferedImage.getColorModel();
            int size = colorModel.getMapSize();
            byte[] reds = new byte[size];
            byte[] greens = new byte[size];
            byte[] blues = new byte[size];
            colorModel.getReds(reds);
            colorModel.getGreens(greens);
            colorModel.getBlues(blues);
            RGB[] rgbs = new RGB[size];
            int i = 0;
            while (i < rgbs.length) {
                rgbs[i] = new RGB(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
                ++i;
            }
            PaletteData palette = new PaletteData(rgbs);
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            data.transparentPixel = colorModel.getTransparentPixel();
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[1];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    data.setPixel(x, y, pixelArray[0]);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        return null;
    }
}

