/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.dialogs;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.ui.io.FileSystemUtils;
import com.aptana.ide.ui.io.IOUIPlugin;
import com.aptana.ide.ui.io.navigator.DeferredTreeContentManager;
import com.aptana.ide.ui.io.navigator.DeferredTreeSelectionExpander;
import com.aptana.ide.ui.io.navigator.FileSystemElementComparer;
import com.aptana.ide.ui.io.navigator.FileTreeDeferredContentProvider;
import com.aptana.ide.ui.io.navigator.FileTreeNameSorter;
import java.util.ArrayList;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class FileTreeSelectionDialog
extends ElementTreeSelectionDialog {
    private IFileStore selection;

    public FileTreeSelectionDialog(Shell parent, boolean allowFiles) {
        super(parent, (ILabelProvider)new DecoratingLabelProvider((ILabelProvider)new FileLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()), (ITreeContentProvider)new FileContentProvider(allowFiles));
        this.setTitle("Browse");
        this.setComparator((ViewerComparator)new FileTreeNameSorter());
    }

    public void setInput(Object input) {
        Assert.isLegal((input instanceof IConnectionPoint || input instanceof IFileStore ? 1 : 0) != 0);
        super.setInput(input);
    }

    public void setInitialSelection(Object selection) {
        if (selection instanceof IFileStore) {
            this.selection = (IFileStore)selection;
        }
    }

    public void create() {
        super.create();
        if (this.selection == null) {
            return;
        }
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                TreeViewer treeViewer = FileTreeSelectionDialog.this.getTreeViewer();
                Object input = treeViewer.getInput();
                try {
                    IFileStore fileStore = null;
                    if (input instanceof IConnectionPoint) {
                        fileStore = ((IConnectionPoint)input).getRoot();
                        if (!fileStore.isParentOf(FileTreeSelectionDialog.this.selection)) {
                            return;
                        }
                    } else if (input instanceof IFileStore) {
                        fileStore = (IFileStore)input;
                        if (fileStore.equals(FileTreeSelectionDialog.this.selection) || !fileStore.isParentOf(FileTreeSelectionDialog.this.selection)) {
                            return;
                        }
                    } else {
                        return;
                    }
                    ArrayList<IFileStore> list = new ArrayList<IFileStore>();
                    IFileStore i = FileTreeSelectionDialog.this.selection;
                    while (i != null) {
                        list.add(0, i);
                        if (i.equals(fileStore)) break;
                        i = i.getParent();
                    }
                    TreePath treePath = new TreePath(list.toArray());
                    DeferredTreeSelectionExpander selectionExpander = (DeferredTreeSelectionExpander)((Object)treeViewer.getData("selection_expander"));
                    if (selectionExpander != null) {
                        selectionExpander.setSelection(treePath);
                    }
                }
                catch (CoreException e) {
                    IdeLog.logImportant((Plugin)IOUIPlugin.getDefault(), (String)"", (Throwable)e);
                }
            }
        });
    }

    private static class FileContentProvider
    implements ITreeContentProvider {
        protected static final String SELECTION_EXPANDER_KEY = "selection_expander";
        private boolean allowFiles;

        public FileContentProvider(boolean allowFiles) {
            this.allowFiles = allowFiles;
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return new Object[1];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            AbstractTreeViewer treeViewer = (AbstractTreeViewer)viewer;
            if (treeViewer.getContentProvider() != this) {
                return;
            }
            DeferredTreeContentManager deferredTreeContentManager = new DeferredTreeContentManager(treeViewer){

                protected void addChildren(Object parent, Object[] children, IProgressMonitor monitor) {
                    if (!FileContentProvider.this.allowFiles) {
                        ArrayList<Object> filtered = new ArrayList<Object>();
                        Object[] objectArray = children;
                        int n = children.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IFileInfo fileInfo;
                            Object i = objectArray[n2];
                            if (i instanceof IAdaptable && (fileInfo = (IFileInfo)((IAdaptable)i).getAdapter(IFileInfo.class)) != null) {
                                if (fileInfo.isDirectory()) {
                                    filtered.add(i);
                                }
                            } else {
                                filtered.add(i);
                            }
                            ++n2;
                        }
                        children = filtered.toArray();
                    }
                    super.addChildren(parent, children, monitor);
                }
            };
            treeViewer.setContentProvider((IContentProvider)new FileTreeDeferredContentProvider(deferredTreeContentManager){

                public Object[] getElements(Object element) {
                    if (element instanceof IConnectionPoint) {
                        try {
                            return new Object[]{((IConnectionPoint)element).getRoot()};
                        }
                        catch (CoreException e) {
                            IdeLog.logImportant((Plugin)IOUIPlugin.getDefault(), (String)"", (Throwable)e);
                        }
                    }
                    return super.getElements(element);
                }
            });
            treeViewer.setComparer((IElementComparer)new FileSystemElementComparer());
            DeferredTreeSelectionExpander selectionExpander = new DeferredTreeSelectionExpander(deferredTreeContentManager, treeViewer);
            treeViewer.setData(SELECTION_EXPANDER_KEY, (Object)selectionExpander);
        }
    }

    private static class FileLabelProvider
    extends LabelProvider {
        private static final Image IMG_FOLDER = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        private static final Image IMG_FILE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        private ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

        private FileLabelProvider() {
        }

        public Image getImage(Object element) {
            ImageDescriptor imageDescriptor;
            IWorkbenchAdapter workbenchAdapter;
            IFileInfo fileInfo = FileSystemUtils.getFileInfo(element);
            if (fileInfo != null) {
                return fileInfo.isDirectory() ? IMG_FOLDER : IMG_FILE;
            }
            IFileStore fileStore = FileSystemUtils.getFileStore(element);
            if (fileStore != null && Path.ROOT.toPortableString().equals(fileStore.getName())) {
                return IMG_FOLDER;
            }
            if (element instanceof IAdaptable && (workbenchAdapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class)) != null && (imageDescriptor = workbenchAdapter.getImageDescriptor(element)) != null) {
                return (Image)this.resourceManager.get((DeviceResourceDescriptor)imageDescriptor);
            }
            return null;
        }

        public String getText(Object element) {
            IFileStore fileStore = FileSystemUtils.getFileStore(element);
            if (fileStore != null) {
                return fileStore.getName();
            }
            return super.getText(element);
        }
    }
}

