/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.internal;

import com.aptana.ide.ui.io.internal.Utils;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;

public class FileSystemObjectPropertyTester
extends PropertyTester {
    private static final String PROPERTY_IS_DIRECTORY = "isDirectory";
    private static final String PROPERTY_IS_LOCAL = "isLocal";
    private static final String PROPERTY_IS_SYMLINK = "isSymlink";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)receiver;
            IFileStore fileStore = Utils.getFileStore(adaptable);
            IFileInfo fileInfo = Utils.getFileInfo(adaptable);
            boolean value = FileSystemObjectPropertyTester.toBoolean(expectedValue);
            if (PROPERTY_IS_DIRECTORY.equals(property)) {
                return fileInfo.isDirectory() == value;
            }
            if (PROPERTY_IS_SYMLINK.equals(property)) {
                return fileInfo.getAttribute(32) == value;
            }
            if (PROPERTY_IS_LOCAL.equals(property)) {
                try {
                    return fileStore.toLocalFile(0, null) != null == value;
                }
                catch (CoreException coreException) {
                    return false;
                }
            }
        }
        return false;
    }

    private static boolean toBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return false;
    }
}

