/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.navigator.actions;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.io.efs.LocalFile;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.ui.UIUtils;
import com.aptana.ide.ui.io.navigator.actions.Messages;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.progress.UIJob;

public class EditorUtils {
    public static void openFileInEditor(final IFileStore fileStore) {
        Job job = new Job(String.valueOf(Messages.EditorUtils_MSG_OpeningRemoteFile) + fileStore.getName()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    final IFileStore localFileStore = EditorUtils.toLocalFileStore(fileStore, monitor);
                    if (localFileStore != null) {
                        UIJob openEditor = new UIJob("Opening editor"){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                try {
                                    IWorkbenchPage page = CoreUIUtils.getActivePage();
                                    IEditorPart editorPart = null;
                                    if (page != null) {
                                        RemoteFileStoreEditorInput editorInput = new RemoteFileStoreEditorInput(localFileStore, fileStore);
                                        boolean opened = page.findEditor((IEditorInput)editorInput) != null;
                                        editorPart = page.openEditor((IEditorInput)editorInput, IDE.getEditorDescriptor((String)localFileStore.getName()).getId());
                                        if (!opened && editorPart != null) {
                                            EditorUtils.attachSaveListener(fileStore, localFileStore, editorPart);
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    UIUtils.showErrorMessage((String)StringUtils.format((String)Messages.EditorUtils_ERR_OpeningEditor, (String)fileStore.toString()), (Throwable)e);
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        openEditor.setSystem(true);
                        openEditor.schedule();
                    }
                }
                catch (Exception e) {
                    UIUtils.showErrorMessage((String)StringUtils.format((String)Messages.EditorUtils_ERR_OpeningEditor, (String)fileStore.toString()), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public static void attachSaveListener(final IFileStore originalFile, final IFileStore localCacheFile, IEditorPart editorPart) {
        if (originalFile == localCacheFile) {
            return;
        }
        editorPart.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                if (propId == 257 && source instanceof EditorPart) {
                    EditorPart ed = (EditorPart)source;
                    if (ed.isDirty()) {
                        return;
                    }
                    Job job = new Job(String.valueOf(Messages.EditorUtils_MSG_RemotelySaving) + ed.getPartName()){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                localCacheFile.copy(originalFile, 2, monitor);
                            }
                            catch (CoreException e) {
                                UIUtils.showErrorMessage((String)StringUtils.format((String)Messages.EditorUtils_ERR_SavingRemoteFile, (String)originalFile.getName()), (Throwable)e);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
            }
        });
    }

    private static IFileStore toLocalFileStore(IFileStore fileStore, IProgressMonitor monitor) throws CoreException {
        File file = fileStore.toLocalFile(0, monitor);
        if (file != null) {
            return fileStore;
        }
        try {
            file = File.createTempFile(fileStore.getFileSystem().getScheme(), fileStore.getName());
        }
        catch (IOException iOException) {
            return fileStore;
        }
        LocalFile localFileStore = new LocalFile(file);
        fileStore.copy((IFileStore)localFileStore, 2, monitor);
        file.deleteOnExit();
        return localFileStore;
    }

    public static class RemoteFileStoreEditorInput
    extends FileStoreEditorInput {
        private IFileStore fRemoteFileStore;

        public RemoteFileStoreEditorInput(IFileStore localFileStore, IFileStore remoteFileStore) {
            super(localFileStore);
            this.fRemoteFileStore = remoteFileStore;
        }

        public String getName() {
            return this.fRemoteFileStore.getName();
        }

        public String getToolTipText() {
            return this.fRemoteFileStore.toString();
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public int hashCode() {
            return this.fRemoteFileStore.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof RemoteFileStoreEditorInput) {
                return this.fRemoteFileStore.equals(((RemoteFileStoreEditorInput)((Object)o)).fRemoteFileStore);
            }
            return false;
        }
    }
}

